/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.sketch.client.renderer;

import com.teamabode.sketch.Sketch;
import com.teamabode.sketch.common.entity.boat.SketchBoatAccessor;
import com.teamabode.sketch.common.entity.boat.SketchBoatType;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;

public class SketchBoatRenderer
extends class_897<class_1690> {
    public static final class_5601 BOAT = new class_5601(Sketch.id("boat"), "main");
    public static final class_5601 CHEST_BOAT = new class_5601(Sketch.id("chest_boat"), "main");
    private final class_4595<class_1690> model;
    private final boolean chestBoat;

    public SketchBoatRenderer(class_5617.class_5618 context, boolean chestBoat) {
        super(context);
        this.model = this.createBoatModel(context, chestBoat);
        this.chestBoat = chestBoat;
    }

    public void render(class_1690 boat, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        float h;
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.375f, 0.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float f = (float)boat.method_54295() - partialTicks;
        float g = boat.method_54294() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * g / 10.0f * (float)boat.method_54296()));
        }
        if (!class_3532.method_15347((float)(h = boat.method_7547(partialTicks)), (float)0.0f)) {
            matrixStack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        this.model.method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 boatVertex = buffer.getBuffer(this.model.method_23500(this.getTextureLocation(boat)));
        this.model.method_60879(matrixStack, boatVertex, packedLight, class_4608.field_21444);
        if (!boat.method_5869()) {
            class_4588 waterPatchVertex = buffer.getBuffer(class_1921.method_23589());
            class_4595<class_1690> class_45952 = this.model;
            if (class_45952 instanceof class_7755) {
                class_7755 waterPatchModel = (class_7755)class_45952;
                waterPatchModel.method_22954().method_22698(matrixStack, waterPatchVertex, packedLight, class_4608.field_21444);
            }
        }
        matrixStack.method_22909();
        super.method_3936((class_1297)boat, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 context, boolean chestBoat) {
        class_630 modelPart = context.method_32167(chestBoat ? CHEST_BOAT : BOAT);
        return chestBoat ? new class_7752(modelPart) : new class_554(modelPart);
    }

    public class_2960 getTextureLocation(class_1690 boat) {
        class_2960 asset = ((SketchBoatType)((SketchBoatAccessor)boat).getBoatType().comp_349()).assetId();
        String subdirectory = this.chestBoat ? "chest_boat" : "boat";
        return asset.method_45134(path -> "textures/entity/" + subdirectory + "/" + path + ".png");
    }
}

