/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.sketch.core.api.animation;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.SimpleMapCodec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import com.teamabode.sketch.core.api.animation.KeyframeHolder;
import com.teamabode.sketch.core.api.animation.TargetType;
import java.util.Map;
import net.minecraft.class_3542;
import net.minecraft.class_5699;

public record AnimationHolder(float lengthInSeconds, boolean looping, Map<String, Map<TargetType, Map<String, KeyframeHolder>>> bones) {
    public static final Codec<String> TIMESTAMP_CODEC = Codec.STRING.validate(value -> {
        try {
            float parsedValue = Float.parseFloat(value);
            return DataResult.success((Object)Float.toString(parsedValue));
        }
        catch (NumberFormatException exception) {
            return DataResult.error(() -> "Timestamp must be a float: " + value);
        }
    });
    public static final Codec<AnimationHolder> CODEC = RecordCodecBuilder.create(instance -> {
        RecordCodecBuilder length = class_5699.field_34387.fieldOf("length_in_seconds").forGetter(AnimationHolder::lengthInSeconds);
        RecordCodecBuilder looping = Codec.BOOL.fieldOf("looping").forGetter(AnimationHolder::looping);
        UnboundedMapCodec timestamps = Codec.unboundedMap(TIMESTAMP_CODEC, KeyframeHolder.CODEC);
        SimpleMapCodec targets = Codec.simpleMap(TargetType.CODEC, (Codec)timestamps, (Keyable)class_3542.method_28142((class_3542[])TargetType.values()));
        RecordCodecBuilder bones = Codec.unboundedMap((Codec)Codec.STRING, (Codec)targets.codec()).fieldOf("bones").forGetter(AnimationHolder::bones);
        Products.P3 group = instance.group((App)length, (App)looping, (App)bones);
        return group.apply((Applicative)instance, AnimationHolder::new);
    });

    public AnimationHolder(float lengthInSeconds, boolean looping, Map<String, Map<TargetType, Map<String, KeyframeHolder>>> bones) {
        this.lengthInSeconds = lengthInSeconds;
        this.looping = looping;
        this.bones = ImmutableMap.copyOf(bones);
    }
}

