/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.sketch.core.api.animation;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabode.sketch.Sketch;
import com.teamabode.sketch.core.api.animation.AnimationHolder;
import com.teamabode.sketch.core.api.animation.KeyframeHolder;
import com.teamabode.sketch.core.api.animation.TargetType;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7179;
import net.minecraft.class_7184;
import net.minecraft.class_7186;

public class AnimationManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final class_7184 FALLBACK_ANIMATION = class_7184.class_7185.method_41818((float)0.0f).method_41821();
    private static final Gson GSON = new GsonBuilder().create();
    public static final AnimationManager INSTANCE = new AnimationManager();
    private Map<class_2960, class_7184> animations = Map.of();

    public AnimationManager() {
        super(GSON, "sketch/animations");
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder registry = new ImmutableMap.Builder();
        data.forEach((resourceLocation, jsonElement) -> {
            try {
                AnimationHolder animationHolder = (AnimationHolder)AnimationHolder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).getOrThrow(JsonParseException::new);
                registry.put(resourceLocation, (Object)this.createAnimation(animationHolder));
            }
            catch (Exception exception) {
                Sketch.LOGGER.error("Failed to parse custom animation {}: {}", resourceLocation, (Object)exception);
            }
        });
        this.animations = registry.buildOrThrow();
    }

    public class_7184 getAnimation(class_2960 id) {
        if (this.animations.containsKey(id)) {
            return this.animations.get(id);
        }
        return FALLBACK_ANIMATION;
    }

    private class_7184 createAnimation(AnimationHolder data) {
        class_7184.class_7185 builder = class_7184.class_7185.method_41818((float)data.lengthInSeconds());
        Map<String, Map<TargetType, Map<String, KeyframeHolder>>> bones = data.bones();
        bones.forEach((bone, targetMap) -> {
            Map targets = (Map)bones.get(bone);
            targets.forEach((target, timestampMap) -> {
                Map timestamps = (Map)targets.get(target);
                class_7186[] keyframes = new class_7186[timestampMap.size()];
                AtomicInteger current = new AtomicInteger(0);
                timestamps.forEach((timestamp, keyframe) -> {
                    keyframes[current.get()] = new class_7186(Float.parseFloat(timestamp), target.transformTarget(keyframe.transformation()), keyframe.interpolation().getInterpolationFromType());
                    current.addAndGet(1);
                });
                builder.method_41820(bone, new class_7179(target.getTarget(), keyframes));
            });
        });
        if (data.looping()) {
            builder.method_41817();
        }
        return builder.method_41821();
    }

    public class_2960 getFabricId() {
        return Sketch.id("animation_manager");
    }
}

