/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.sketch.core.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamabode.sketch.Sketch;
import com.teamabode.sketch.core.api.config.Config;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class ConfigManager {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ConfigManager INSTANCE = new ConfigManager();

    private ConfigManager() {
    }

    public void register(Config config) {
        if (!config.getFile().exists()) {
            this.writeConfig(config);
        }
        this.readConfig(config);
    }

    private void writeConfig(Config config) {
        try (FileWriter writer = new FileWriter(config.getFile());){
            JsonObject configJson = this.serialize(config);
            String data = GSON.toJson((JsonElement)configJson);
            writer.write(data);
        }
        catch (Exception e) {
            Sketch.LOGGER.error("Failed to write configuration file {}: {}", (Object)config.name, (Object)e);
        }
    }

    private void readConfig(Config config) {
        try (FileReader reader = new FileReader(config.getFile());){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            config.categories.forEach((categoryName, properties) -> {
                JsonObject categoryJson = root.getAsJsonObject(categoryName);
                properties.forEach(property -> {
                    Object newValue = property.fromJson(categoryJson.get(property.getName()));
                    property.set(newValue);
                });
            });
        }
        catch (Exception e) {
            Sketch.LOGGER.error("Failed to read configuration file {}: {}", (Object)config.name, (Object)e);
        }
    }

    private JsonObject serialize(Config config) {
        JsonObject root = new JsonObject();
        config.categories.forEach((categoryName, properties) -> {
            JsonObject categoryJson = new JsonObject();
            properties.forEach(property -> {
                String name = property.getName();
                JsonElement element = property.toJson();
                categoryJson.add(name, element);
            });
            root.add(categoryName, (JsonElement)categoryJson);
        });
        return root;
    }
}

