/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.sketch.core.api.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.teamabode.sketch.Sketch;
import com.teamabode.sketch.core.api.model.ModelOverride;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import net.minecraft.class_799;

public class ModelOverrideManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ModelOverride.class, (Object)new ModelOverride.Deserializer()).registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(class_799.class, (Object)new class_799.class_800()).create();
    public static final ModelOverrideManager INSTANCE = new ModelOverrideManager();
    private static final class_7654 MODEL_OVERRIDE_LISTER = class_7654.method_45114((String)"sketch/model_overrides");
    private Map<class_2960, List<class_799>> modelOverrides = Map.of();

    public void loadModelOverrides(class_3300 manager) {
        HashMap registry = Maps.newHashMap();
        CompletableFuture.runAsync(() -> MODEL_OVERRIDE_LISTER.method_45116(manager).forEach((location, resources) -> {
            resources.forEach(resource -> {
                try (BufferedReader reader = resource.method_43039();){
                    ModelOverride modelOverride = (ModelOverride)class_3518.method_15276((Gson)GSON, (Reader)reader, ModelOverride.class);
                    class_2960 item = modelOverride.getModel();
                    List<class_799> overrides = modelOverride.getOverrides();
                    registry.computeIfPresent(item, (id, oldOverrides) -> Stream.concat(oldOverrides.stream(), overrides.stream()).toList());
                    registry.put(item, overrides);
                }
                catch (Exception e) {
                    Sketch.LOGGER.error("Failed to parse model override {}: {}", location, (Object)e);
                }
            });
            this.modelOverrides = ImmutableMap.copyOf((Map)registry);
        }));
    }

    public Map<class_2960, List<class_799>> getRegistry() {
        return this.modelOverrides;
    }

    public List<class_799> get(class_2960 model) {
        return this.modelOverrides.get(model);
    }
}

