/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.constraint;

import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

public class Constraint {
    public static final Constraint NONE = new Constraint(null){

        @Override
        public void apply() {
        }
    };
    protected final Constrainable parent;
    private Property left;
    private Property right;
    private Property top;
    private Property bottom;
    private Property width;
    private Property height;

    public Constraint(Constrainable parent) {
        this.parent = parent;
        this.width = this.height = Property.NONE;
        this.bottom = this.height;
        this.top = this.height;
        this.right = this.height;
        this.left = this.height;
    }

    public Constraint left(Rectangle c, Property.Type type, int i) {
        this.left = c == null ? Property.NONE : new Property(c, Property.Type.LEFT, type, i);
        return this;
    }

    public Constraint right(Rectangle c, Property.Type type, int i) {
        this.right = c == null ? Property.NONE : new Property(c, Property.Type.RIGHT, type, i);
        return this;
    }

    public Constraint top(Rectangle c, Property.Type type, int i) {
        this.top = c == null ? Property.NONE : new Property(c, Property.Type.TOP, type, i);
        return this;
    }

    public Constraint bottom(Rectangle c, Property.Type type, int i) {
        this.bottom = c == null ? Property.NONE : new Property(c, Property.Type.BOTTOM, type, i);
        return this;
    }

    public Constraint width(Rectangle c, Property.Type type, int i) {
        this.width = c == null ? Property.NONE : new Property(c, Property.Type.WIDTH, type, i);
        return this;
    }

    public Constraint height(Rectangle c, Property.Type type, int i) {
        this.height = c == null ? Property.NONE : new Property(c, Property.Type.HEIGHT, type, i);
        return this;
    }

    public Constraint type(Property.Type link, Rectangle c, Property.Type type, int i) {
        switch (link.ordinal()) {
            case 0: {
                return this.left(c, type, i);
            }
            case 1: {
                return this.right(c, type, i);
            }
            case 2: {
                return this.top(c, type, i);
            }
            case 3: {
                return this.bottom(c, type, i);
            }
            case 4: {
                return this.width(c, type, i);
            }
            case 5: {
                return this.height(c, type, i);
            }
        }
        return this;
    }

    public Property get(Property.Type type) {
        switch (type.ordinal()) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
            case 2: {
                return this.top;
            }
            case 3: {
                return this.bottom;
            }
            case 4: {
                return this.width;
            }
        }
        return this.height;
    }

    public boolean hasLeft() {
        return this.left != Property.NONE;
    }

    public boolean hasRight() {
        return this.right != Property.NONE;
    }

    public boolean hasTop() {
        return this.top != Property.NONE;
    }

    public boolean hasBottom() {
        return this.bottom != Property.NONE;
    }

    public boolean hasWidth() {
        return this.width != Property.NONE;
    }

    public boolean hasHeight() {
        return this.height != Property.NONE;
    }

    public static Constraint matchParent(@NotNull Constrainable c, @NotNull Rectangle parent, int i) {
        return new Constraint(c).left(parent, Property.Type.LEFT, i).right(parent, Property.Type.RIGHT, i).top(parent, Property.Type.TOP, i).bottom(parent, Property.Type.BOTTOM, i);
    }

    public static Constraint matchParentRatio(@NotNull Constrainable c, @NotNull Rectangle parent, int i) {
        return new Constraint(c).width(parent, Property.Type.WIDTH, i).height(parent, Property.Type.HEIGHT, i);
    }

    public static Constraint sizeOnly(@NotNull Constrainable c) {
        return new Constraint(c){

            @Override
            public void apply() {
                this.parent.contractX(this.parent.getMaxWidth());
                this.parent.contractY(this.parent.getMaxHeight());
                this.parent.expandX(this.parent.getMinWidth());
                this.parent.expandY(this.parent.getMinHeight());
            }
        };
    }

    public void apply() {
        if (this.parent != null) {
            Rectangle attachment;
            this.parent.contractX(this.parent.getMaxWidth());
            this.parent.contractY(this.parent.getMaxHeight());
            this.parent.expandX(this.parent.getMinWidth());
            this.parent.expandY(this.parent.getMinHeight());
            this.width.apply(this);
            this.height.apply(this);
            if (!(this.left.apply(this) | this.right.apply(this))) {
                if (this.hasTop() || this.hasBottom()) {
                    attachment = this.hasTop() ? this.top.reference : this.bottom.reference;
                    this.parent.setLeft(attachment.getLeft() + (attachment.getRight() - attachment.getLeft() - this.parent.getWidth()) / 2);
                } else {
                    this.parent.setPosX((this.parent.getParentWidth() - this.parent.getWidth()) / 2);
                }
            }
            if (!(this.top.apply(this) | this.bottom.apply(this))) {
                if (this.hasLeft() || this.hasRight()) {
                    attachment = this.hasLeft() ? this.left.reference : this.right.reference;
                    this.parent.setTop(attachment.getTop() + (attachment.getBottom() - attachment.getTop() - this.parent.getHeight()) / 2);
                } else {
                    this.parent.setPosY((this.parent.getParentHeight() - this.parent.getHeight()) / 2);
                }
            }
            this.parent.contractX(this.parent.getMaxWidth());
            this.parent.contractY(this.parent.getMaxHeight());
            this.parent.expandX(this.parent.getMinWidth());
            this.parent.expandY(this.parent.getMinHeight());
        }
    }

    public static class Property {
        public static final Property NONE = new Property(null, null, null, 0){

            @Override
            public boolean apply(Constraint c) {
                return false;
            }
        };
        private Rectangle reference;
        private Type self;
        private Type type;
        private int dist;

        public Property(Rectangle reference, Type self, Type type, int dist) {
            this.reference = reference;
            this.self = self;
            this.type = type;
            this.dist = dist;
        }

        public boolean apply(Constraint c) {
            switch (this.self.ordinal()) {
                case 0: {
                    c.parent.setLeft(this.type.get(this.reference) + this.dist);
                    if (c.hasRight()) {
                        c.right.apply(c);
                    }
                    return true;
                }
                case 1: {
                    if (c.hasLeft()) {
                        c.parent.setRight(this.type.get(this.reference) - this.dist);
                    } else {
                        c.parent.setLeft(this.type.get(this.reference) - this.dist - c.parent.getWidth());
                    }
                    return true;
                }
                case 2: {
                    c.parent.setTop(this.type.get(this.reference) + this.dist);
                    if (c.hasBottom()) {
                        c.bottom.apply(c);
                    }
                    return true;
                }
                case 3: {
                    if (c.hasTop()) {
                        c.parent.setBottom(this.type.get(this.reference) - this.dist);
                    } else {
                        c.parent.setTop(this.type.get(this.reference) - this.dist - c.parent.getHeight());
                    }
                    return true;
                }
                case 4: {
                    c.parent.setWidth((int)((float)(this.type.get(this.reference) * this.dist) / 100.0f));
                    return true;
                }
                case 5: {
                    c.parent.setHeight((int)((float)(this.type.get(this.reference) * this.dist) / 100.0f));
                    return true;
                }
            }
            return false;
        }

        public Rectangle getReference() {
            return this.reference;
        }

        public Type getType() {
            return this.type;
        }

        public int getDist() {
            return this.dist;
        }

        public static enum Type {
            LEFT,
            RIGHT,
            TOP,
            BOTTOM,
            WIDTH,
            HEIGHT;


            public int get(Rectangle reference) {
                switch (this.ordinal()) {
                    case 0: {
                        return reference.getLeft();
                    }
                    case 1: {
                        return reference.getRight();
                    }
                    case 2: {
                        return reference.getTop();
                    }
                    case 3: {
                        return reference.getBottom();
                    }
                    case 4: {
                        return reference.getWidth();
                    }
                    case 5: {
                        return reference.getHeight();
                    }
                }
                return -1;
            }

            public Type getOpposite() {
                switch (this.ordinal()) {
                    case 0: {
                        return RIGHT;
                    }
                    case 1: {
                        return LEFT;
                    }
                    case 2: {
                        return BOTTOM;
                    }
                    case 3: {
                        return TOP;
                    }
                    case 4: {
                        return HEIGHT;
                    }
                }
                return WIDTH;
            }

            public class_2350.class_2351 getAxis() {
                switch (this.ordinal()) {
                    case 0: 
                    case 1: 
                    case 4: {
                        return class_2350.class_2351.field_11048;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        return class_2350.class_2351.field_11052;
                    }
                }
                return class_2350.class_2351.field_11051;
            }
        }
    }
}

