/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.TextureDefinition;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class ElementNumberInput
extends ElementTextField {
    public static final int BUTTON_WIDTH = 10;
    public boolean isDouble;
    public Predicate<String> min = s -> true;
    public Predicate<String> max = s -> true;
    public Predicate<String> maxDec = s -> true;
    public int decimals;
    public Predicate<String> finalValidator = s -> true;
    public boolean clickUp;
    public boolean clickDown;

    public ElementNumberInput(@NotNull Fragment parent, boolean isDouble) {
        super(parent);
        this.isDouble = isDouble;
    }

    public <T extends ElementNumberInput> T setMin(double d) {
        this.min = s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                double d1 = Double.parseDouble(s);
                return d1 >= d;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return (T)this;
    }

    public <T extends ElementNumberInput> T setMax(double d) {
        this.max = s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                double d1 = Double.parseDouble(s);
                return d1 <= d;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return (T)this;
    }

    public <T extends ElementNumberInput> T setMaxDec(int i) {
        this.decimals = Math.max(0, i);
        if (i >= 0) {
            this.maxDec = s -> {
                int dot = s.indexOf(".");
                return dot == -1 || dot + 1 + i >= s.length();
            };
        }
        return (T)this;
    }

    @Override
    public void init() {
        super.init();
        this.finalValidator = (this.isDouble ? NUMBERS : INTEGERS).and(this.min).and(this.max).and(this.maxDec);
        this.widget.method_1890(this.finalValidator);
    }

    @Override
    public void drawTextBox(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        class_4587 stack = graphics.method_51448();
        if (this.renderMinecraftStyle() > 0) {
            this.widget.method_1858(true);
            this.widget.method_25394(graphics, mouseX, mouseY, partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderMinecraftStyleButton(stack, this.getRight() - 10, this.getTop(), 10, (int)((double)this.height / 2.0), this.clickUp ? Element.ButtonState.CLICK : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0) ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
            this.renderMinecraftStyleButton(stack, this.getRight() - 10, this.getTop() + (int)((double)this.height / 2.0), 10, (int)((double)this.height / 2.0), this.clickDown ? Element.ButtonState.CLICK : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom()) ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
            int size = 4;
            ElementNumberInput.bindTexture(this.resourceUp());
            double[] coords = TEXDEF_UP.getCoords(TextureDefinition.DrawType.FILL);
            RenderHelper.draw(stack, this.getRight() - size - 3, (double)this.getTop() + (double)this.height / 2.0 / 2.0 - (double)size / 2.0, size, size, 0.0, coords[0], coords[1], coords[2], coords[3]);
            ElementNumberInput.bindTexture(this.resourceDown());
            coords = TEXDEF_DOWN.getCoords(TextureDefinition.DrawType.FILL);
            RenderHelper.draw(stack, this.getRight() - size - 3, (double)this.getTop() + ((double)this.height - 0.5) / 2.0 / 2.0 * 3.0 - (double)size / 2.0, size, size, 0.0, coords[0], coords[1], coords[2], coords[3]);
        } else {
            int[] colour = ElementNumberInput.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width - 10) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height) ? this.getTheme().elementInputBackgroundHover : this.getTheme().elementInputBackgroundInactive;
            this.fill(graphics, this.getTheme().elementInputBorder, 0);
            this.fill(graphics, colour, 1);
            this.widget.method_1858(false);
            this.widget.method_25394(graphics, mouseX, mouseY, partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            colour = this.clickUp ? this.getTheme().elementInputUpDownClick : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0) ? this.getTheme().elementInputUpDownHover : this.getTheme().elementInputBorder);
            RenderHelper.drawColour(graphics, colour[0], colour[1], colour[2], 255, this.getRight() - 10, this.getTop(), 10.0, (double)this.height / 2.0, 0.0);
            colour = this.clickDown ? this.getTheme().elementInputUpDownClick : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom()) ? this.getTheme().elementInputUpDownHover : this.getTheme().elementInputBorder);
            RenderHelper.drawColour(graphics, colour[0], colour[1], colour[2], 255, this.getRight() - 10, (double)this.getTop() + (double)this.height / 2.0, 10.0, (double)this.height / 2.0, 0.0);
            stack.method_22903();
            float scale = 0.5f;
            stack.method_22905(scale, scale, scale);
            float f = (float)(this.getRight() - 10 + 4) / scale;
            float f2 = (float)this.getTop() + 2.5f;
            double d = (double)this.height / 2.0 / 2.0;
            Objects.requireNonNull(this.getFontRenderer());
            this.drawString(graphics, "\u25b2", f, (f2 + (float)(d - 9.0 / 2.0)) / scale);
            float f3 = (float)(this.getRight() - 10 + 4) / scale;
            float f4 = (float)this.getTop() + 2.5f;
            double d2 = ((double)this.height - 0.5) / 2.0 / 2.0 * 3.0;
            Objects.requireNonNull(this.getFontRenderer());
            this.drawString(graphics, "\u25bc", f3, (f4 + (float)(d2 - 9.0 / 2.0)) / scale);
            stack.method_22909();
        }
    }

    @Override
    public void adjustWidget() {
        if (this.widget != null) {
            if (this.renderMinecraftStyle() > 0) {
                this.widget.method_46421(this.getLeft() + 1);
                this.widget.method_46419(this.getTop() + 1);
                this.widget.method_25358(this.width - 2 - 10);
                this.widget.method_53533(this.height - 2);
            } else {
                this.widget.method_46421(this.getLeft() + 5);
                int n = this.getTop() + 1;
                Objects.requireNonNull(this.getFontRenderer());
                this.widget.method_46419(n + (this.height - 9) / 2);
                this.widget.method_25358(this.width - 6 - 10);
                this.widget.method_53533(this.height - 2);
            }
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            this.method_25395((class_364)this.widget);
            this.widget.method_25365(true);
            if (button == 1) {
                this.widget.method_1852("");
            } else if (button == 2) {
                this.widget.method_1867(class_310.method_1551().field_1774.method_1460());
            }
            this.widget.method_25402(mouseX, mouseY, button);
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0)) {
                this.clickUp = true;
            }
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom())) {
                this.clickDown = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.clickUp) {
            this.clickUp = false;
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0)) {
                this.changeValue(true, class_437.method_25442(), class_437.method_25441());
                if (this.renderMinecraftStyle() > 0) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
            }
        }
        if (this.clickDown) {
            this.clickDown = false;
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom())) {
                this.changeValue(false, class_437.method_25442(), class_437.method_25441());
                if (this.renderMinecraftStyle() > 0) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (ElementNumberInput.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width - 10) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height)) {
            this.changeValue(scrollY > 0.0, class_437.method_25442(), class_437.method_25441());
            return true;
        }
        return false;
    }

    public void changeValue(boolean up, boolean hasShiftDown, boolean hasControlDown) {
        double amp;
        String s = this.widget.method_1882();
        if (s.isEmpty()) {
            s = "0";
        }
        double d = amp = this.isDouble ? Math.pow(0.1, Math.max(0, this.decimals - 1)) : 1.0;
        if (hasShiftDown && hasControlDown) {
            amp *= 100.0;
        } else if (hasShiftDown) {
            amp *= 10.0;
        } else if (hasControlDown) {
            amp *= 0.1;
        }
        if (this.isDouble) {
            try {
                double d2 = Double.parseDouble(s);
                String newVal = String.format(Locale.ENGLISH, "%." + Integer.toString(this.decimals) + "f", d2 += (double)(up ? 1 : -1) * amp);
                if (this.finalValidator.test(newVal)) {
                    this.widget.method_1852(newVal);
                }
            }
            catch (NumberFormatException d2) {}
        } else {
            amp = Math.max(1.0, amp);
            int i = Integer.parseInt(s);
            String newVal = Integer.toString(i = (int)((double)i + (double)(up ? 1 : -1) * amp));
            if (this.finalValidator.test(newVal)) {
                this.widget.method_1852(newVal);
            }
        }
    }

    public int getInt() {
        String s = this.widget.method_1882();
        if (s.contains(".")) {
            try {
                return (int)Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (!s.isEmpty() && !s.equals("-")) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public double getDouble() {
        String s = this.widget.method_1882();
        if (!s.isEmpty() && !s.equals("-")) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    @Override
    public int getMinWidth() {
        return 20;
    }
}

