/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.network;

import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public abstract class PacketChannel {
    protected final class_2960 channelId;
    protected final Object2ByteOpenHashMap<Class<? extends AbstractPacket>> clzToId;
    protected final Class<? extends AbstractPacket>[] idToClz;

    @SafeVarargs
    public PacketChannel(class_2960 name, Class<? extends AbstractPacket> ... packetTypes) {
        this.channelId = name;
        this.clzToId = new Object2ByteOpenHashMap(packetTypes.length);
        for (int i = 0; i < packetTypes.length; ++i) {
            this.clzToId.put(packetTypes[i], (byte)i);
        }
        this.idToClz = packetTypes;
    }

    public abstract void sendToServer(AbstractPacket var1);

    public abstract void sendTo(AbstractPacket var1, class_3222 var2);

    public abstract void sendToAll(AbstractPacket var1);

    public abstract void sendToTracking(AbstractPacket var1, class_1297 var2);

    public abstract void sendToAround(AbstractPacket var1, class_3218 var2, double var3, double var5, double var7, double var9);

    protected PacketPayload payload(AbstractPacket packet) {
        return new PacketPayload(packet);
    }

    protected PacketPayload readPacket(class_2540 buffer) {
        AbstractPacket packet;
        byte id = buffer.readByte();
        Class<? extends AbstractPacket> clz = this.idToClz[id];
        try {
            packet = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            packet.readFrom(buffer);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create packet for " + this.channelId.toString() + " with id " + id, e);
        }
        return new PacketPayload(packet);
    }

    @Environment(value=EnvType.CLIENT)
    protected class_1657 getPlayer() {
        return iChunUtil.eC().getPlayer();
    }

    protected class_9139<class_2540, PacketPayload> createCodec() {
        return new class_9139<class_2540, PacketPayload>(){

            public PacketPayload decode(class_2540 buffer) {
                return PacketChannel.this.readPacket(buffer);
            }

            public void encode(class_2540 buffer, PacketPayload payload) {
                payload.write(buffer);
            }
        };
    }

    protected class PacketPayload
    implements class_8710 {
        private final AbstractPacket packet;

        private PacketPayload(AbstractPacket packet) {
            this.packet = packet;
        }

        public void write(class_2540 buffer) {
            buffer.method_52997((int)PacketChannel.this.clzToId.getByte(this.packet.getClass()));
            this.packet.writeTo(buffer);
        }

        public Optional<Runnable> process(@Nullable class_1657 player) {
            return this.packet.process(player);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return new class_8710.class_9154(PacketChannel.this.channelId);
        }
    }
}

