/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.fabric;

import com.google.common.collect.MapMaker;
import java.util.Map;
import me.ichun.mods.ichunutil.common.entity.EntityPersistentDataHandler;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class EntityPersistentDataHandlerFabric
implements EntityPersistentDataHandler {
    public static final String DATA_KEY = "ichunutil_persistent";
    public Map<class_1297, class_2487> entToTagMap = new MapMaker().weakKeys().makeMap();

    public EntityPersistentDataHandlerFabric() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> this.clean());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.clean());
        ServerEntityWorldChangeEvents.AFTER_ENTITY_CHANGE_WORLD.register((originalEntity, newEntity, origin, destination) -> {
            if (this.entToTagMap.containsKey(originalEntity)) {
                this.entToTagMap.put(newEntity, this.entToTagMap.get(originalEntity));
                this.entToTagMap.remove(originalEntity);
            }
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            class_2487 oldPersistent = this.getPersistentData((class_1297)oldPlayer);
            if (oldPersistent.method_10545("PlayerPersisted")) {
                this.getPersistentData((class_1297)newPlayer).method_10566("PlayerPersisted", oldPersistent.method_10580("PlayerPersisted"));
            }
        });
    }

    @Override
    @NotNull
    public class_2487 getPersistentData(@NotNull class_1297 ent) {
        return this.entToTagMap.computeIfAbsent(ent, e -> new class_2487());
    }

    @Override
    public void savePersistentData(@NotNull class_1297 ent, @NotNull class_2487 tag) {
        if (this.entToTagMap.containsKey(ent)) {
            tag.method_10566(DATA_KEY, (class_2520)this.entToTagMap.get(ent).method_10553());
        }
    }

    @Override
    public void loadPersistentData(@NotNull class_1297 ent, @NotNull class_2487 tag) {
        if (tag.method_10573(DATA_KEY, 10)) {
            this.entToTagMap.put(ent, tag.method_10562(DATA_KEY));
        }
    }

    public void clean() {
        this.entToTagMap.clear();
    }
}

