/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.fabric.config.loader;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.config.ConfigToToml;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.util.WatchServiceThread;
import me.ichun.mods.ichunutil.loader.fabric.PacketChannelFabric;
import me.ichun.mods.ichunutil.loader.fabric.config.loader.PacketConfig;
import me.ichun.shadow.com.moandjiezana.toml.Toml;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public final class FabricConfigLoader {
    private static final Map<ConfigBase.Type, ArrayList<ConfigBase>> REGISTERED_CONFIGS = Collections.synchronizedMap(new EnumMap(ConfigBase.Type.class));
    private static final PacketChannelFabric CHANNEL = new PacketChannelFabric(class_2960.method_60655((String)"ichunutil", (String)"config"), PacketConfig.class);
    private static Path currentServerConfigPath = null;

    public static <T extends ConfigBase> T registerConfig(T config) {
        ArrayList configBases = REGISTERED_CONFIGS.computeIfAbsent(config.getConfigType(), k -> new ArrayList());
        configBases.add(config);
        if (config.getConfigType() != ConfigBase.Type.SERVER) {
            FabricConfigLoader.loadOrCreateConfig(config, false);
        }
        return config;
    }

    public static void loadOrCreateConfig(ConfigBase config, boolean isReload) {
        Path configPath = FabricConfigLoader.getPathForConfig(config);
        if (configPath == null) {
            iChunUtil.LOGGER.error("Config path is null, something went wrong here.");
            return;
        }
        try {
            boolean loadSuccessful = false;
            if (Files.exists(configPath, new LinkOption[0]) && Files.isRegularFile(configPath, new LinkOption[0])) {
                try {
                    Toml toml = new Toml().read(FileUtils.readFileToString((File)configPath.toFile(), (Charset)Charsets.UTF_8));
                    loadSuccessful = ConfigToToml.assignValuesFromToml(config, toml, isReload);
                }
                catch (IllegalAccessException | IllegalStateException e) {
                    iChunUtil.LOGGER.warn("Errors detected loading up config file {}. Recreating config.", (Object)configPath, (Object)e);
                }
            }
            if (!loadSuccessful) {
                if (!Files.exists(configPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                }
                String tomlString = ConfigToToml.convertToToml(config, false);
                Files.writeString(configPath, (CharSequence)tomlString, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            WatchServiceThread.watchFile(configPath, FabricConfigLoader::onFileChanged);
            config.setSaveMethod(() -> {
                try {
                    String tomlString = ConfigToToml.convertToToml(config, false);
                    Files.writeString(configPath, (CharSequence)tomlString, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    iChunUtil.LOGGER.error("Error saving config file {}", (Object)config.getFileName(), (Object)e);
                }
            });
            if (!isReload) {
                config.onConfigLoaded();
            }
        }
        catch (IOException e) {
            iChunUtil.LOGGER.error("Something went wrong loading up config {} {}", new Object[]{config.getConfigName(), config.getConfigType().toString(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onFileChanged(String fileName) {
        Map<ConfigBase.Type, ArrayList<ConfigBase>> map = REGISTERED_CONFIGS;
        synchronized (map) {
            REGISTERED_CONFIGS.forEach((k, v) -> v.forEach(c -> {
                if (c.getFileName().equals(fileName)) {
                    FabricConfigLoader.loadOrCreateConfig(c, true);
                }
            }));
        }
    }

    private static void serverStatus(MinecraftServer server) {
        if (REGISTERED_CONFIGS.containsKey((Object)ConfigBase.Type.SERVER)) {
            if (server == null) {
                if (currentServerConfigPath != null) {
                    WatchServiceThread.stopWatchFolder(currentServerConfigPath);
                    for (ConfigBase config : REGISTERED_CONFIGS.get((Object)ConfigBase.Type.SERVER)) {
                        config.setSaveMethod(null);
                    }
                    currentServerConfigPath = null;
                }
            } else {
                currentServerConfigPath = server.method_27050(class_5218.field_24184).resolve("/serverconfig");
                for (ConfigBase config : REGISTERED_CONFIGS.get((Object)ConfigBase.Type.SERVER)) {
                    Path defaultConfigPath;
                    Path configPath = FabricConfigLoader.getPathForConfig(config);
                    if ((!Files.exists(configPath, new LinkOption[0]) || !Files.isRegularFile(configPath, new LinkOption[0])) && Files.exists(defaultConfigPath = iChunUtil.d().getConfigDir().getParent().resolve("/defaultconfigs").resolve(config.getFileName()), new LinkOption[0]) && Files.isRegularFile(defaultConfigPath, new LinkOption[0])) {
                        try {
                            FileUtils.copyFile((File)defaultConfigPath.toFile(), (File)configPath.toFile());
                        }
                        catch (IOException e) {
                            iChunUtil.LOGGER.error("Error copying default config for config {}", (Object)config.getFileName(), (Object)e);
                        }
                    }
                    FabricConfigLoader.loadOrCreateConfig(config, false);
                }
            }
        }
    }

    private static void sendServerConfigs(class_3244 handler, PacketSender sender, MinecraftServer server) {
        ArrayList<ConfigBase> configBases = REGISTERED_CONFIGS.get((Object)ConfigBase.Type.SERVER);
        if (configBases != null) {
            for (ConfigBase configBase : configBases) {
                CHANNEL.sendTo((AbstractPacket)new PacketConfig(configBase.getFileName(), ConfigToToml.convertToToml(configBase, true)), handler.method_32311());
            }
        }
    }

    public static void receiveServerConfig(String fileName, String tomlString) {
        ArrayList<ConfigBase> configBases = REGISTERED_CONFIGS.get((Object)ConfigBase.Type.SERVER);
        if (configBases != null) {
            for (ConfigBase configBase : configBases) {
                if (!configBase.getFileName().equals(fileName)) continue;
                try {
                    configBase.cache();
                    Toml toml = new Toml().read(tomlString);
                    ConfigToToml.assignValuesFromToml(configBase, toml, true);
                }
                catch (IllegalAccessException | IllegalStateException e) {
                    iChunUtil.LOGGER.error("Error receiving config {} from server.", (Object)fileName, (Object)e);
                }
            }
        }
    }

    @Nullable
    public static Path getPathForConfig(ConfigBase config) {
        if (config.getConfigType() == ConfigBase.Type.SERVER) {
            return currentServerConfigPath == null ? null : currentServerConfigPath.resolve(config.getFileName());
        }
        return iChunUtil.d().getConfigDir().resolve(config.getFileName());
    }

    static {
        ServerLifecycleEvents.SERVER_STARTING.register(FabricConfigLoader::serverStatus);
        ServerLifecycleEvents.SERVER_STOPPED.register(FabricConfigLoader::serverStatus);
        ServerPlayConnectionEvents.JOIN.register(FabricConfigLoader::sendServerConfigs);
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            ClientPlayConnectionEvents.DISCONNECT.register((h, c) -> ConfigHandler.onServerDisconnect());
        }
    }
}

