/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.format;

import dev.toma.configuration.config.exception.ConfigReadException;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.value.ConfigValue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public interface IConfigFormat {
    public void writeBoolean(String var1, boolean var2);

    public boolean readBoolean(String var1) throws ConfigValueMissingException;

    public void writeChar(String var1, char var2);

    public char readChar(String var1) throws ConfigValueMissingException;

    public void writeByte(String var1, byte var2);

    public byte readByte(String var1) throws ConfigValueMissingException;

    public void writeShort(String var1, short var2);

    public short readShort(String var1) throws ConfigValueMissingException;

    public void writeInt(String var1, int var2);

    public int readInt(String var1) throws ConfigValueMissingException;

    public void writeLong(String var1, long var2);

    public long readLong(String var1) throws ConfigValueMissingException;

    public void writeFloat(String var1, float var2);

    public float readFloat(String var1) throws ConfigValueMissingException;

    public void writeDouble(String var1, double var2);

    public double readDouble(String var1) throws ConfigValueMissingException;

    public void writeString(String var1, String var2);

    public String readString(String var1) throws ConfigValueMissingException;

    public void writeBoolArray(String var1, Boolean[] var2);

    public Boolean[] readBoolArray(String var1) throws ConfigValueMissingException;

    public void writeCharArray(String var1, Character[] var2);

    public Character[] readCharArray(String var1) throws ConfigValueMissingException;

    public void writeByteArray(String var1, Byte[] var2);

    public Byte[] readByteArray(String var1) throws ConfigValueMissingException;

    public void writeShortArray(String var1, Short[] var2);

    public Short[] readShortArray(String var1) throws ConfigValueMissingException;

    public void writeIntArray(String var1, Integer[] var2);

    public Integer[] readIntArray(String var1) throws ConfigValueMissingException;

    public void writeLongArray(String var1, Long[] var2);

    public Long[] readLongArray(String var1) throws ConfigValueMissingException;

    public void writeFloatArray(String var1, Float[] var2);

    public Float[] readFloatArray(String var1) throws ConfigValueMissingException;

    public void writeDoubleArray(String var1, Double[] var2);

    public Double[] readDoubleArray(String var1) throws ConfigValueMissingException;

    public void writeStringArray(String var1, String[] var2);

    public String[] readStringArray(String var1) throws ConfigValueMissingException;

    public <E extends Enum<E>> void writeEnum(String var1, E var2);

    public <E extends Enum<E>> E readEnum(String var1, Class<E> var2) throws ConfigValueMissingException;

    public <E extends Enum<E>> void writeEnumArray(String var1, E[] var2);

    public <E extends Enum<E>> E[] readEnumArray(String var1, Class<E> var2) throws ConfigValueMissingException;

    public void writeMap(String var1, Map<String, ConfigValue<?>> var2);

    public void readMap(String var1, Collection<ConfigValue<?>> var2) throws ConfigValueMissingException;

    public void readFile(File var1) throws IOException, ConfigReadException;

    public void writeFile(File var1) throws IOException;

    public void addComments(String[] var1);

    public static Boolean parseBoolean(String string) throws ConfigValueMissingException {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException(string);
        }
    }

    public static Character parseCharacter(String string) throws ConfigValueMissingException {
        if (string.isEmpty()) {
            throw new ConfigValueMissingException(string);
        }
        return Character.valueOf(string.charAt(0));
    }

    public static Byte parseByte(String string) throws ConfigValueMissingException {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException(string);
        }
    }

    public static Short parseShort(String string) throws ConfigValueMissingException {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException(string);
        }
    }

    public static Integer parseInteger(String string) throws ConfigValueMissingException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException(string);
        }
    }

    public static Long parseLong(String string) throws ConfigValueMissingException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException(string);
        }
    }

    public static Float parseFloat(String string) throws ConfigValueMissingException {
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException(string);
        }
    }

    public static Double parseDouble(String value) throws ConfigValueMissingException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueMissingException("Could not parse double value: " + value);
        }
    }

    @FunctionalInterface
    public static interface ValueDecoder<T> {
        public T decode(String var1) throws ConfigValueMissingException;
    }
}

