/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.EnumValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Array;
import net.minecraft.class_2540;

public class EnumArrayValue<E extends Enum<E>>
extends AbstractArrayValue<E> {
    private final String[] additionalComments = EnumValue.generateEnumComments(this.getElementType());

    public EnumArrayValue(ValueData<E[]> value) {
        super(value);
    }

    @Override
    public E createElementInstance() {
        Class<E> enumType = this.getElementType();
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        if (constants.length == 0) {
            throw new IllegalArgumentException("Enum does not define any constants");
        }
        return (E)constants[0];
    }

    public Class<E> getElementType() {
        return this.valueData.getValueType().getComponentType();
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.addComments(this.additionalComments);
        format.writeEnumArray(this.getId(), (Enum[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        Class<?> type = this.getValueType().getComponentType();
        this.setValue(format.readEnumArray(this.getId(), type));
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter<E[]> {
        @Override
        public ConfigValue<E[]> serialize(TypeAdapter.TypeAttributes<E[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new EnumArrayValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<E[]> value, class_2540 buffer) {
            Enum[] values = (Enum[])value.get();
            buffer.method_53002(values.length);
            for (Enum e : values) {
                buffer.method_10817(e);
            }
        }

        @Override
        public E[] decodeFromBuffer(ConfigValue<E[]> value, class_2540 buffer) {
            int count = buffer.readInt();
            Class<?> type = value.getValueType().getComponentType();
            Enum[] enumArray = (Enum[])Array.newInstance(type, count);
            for (int i = 0; i < count; ++i) {
                enumArray[i] = buffer.method_10818(type);
            }
            return enumArray;
        }
    }
}

