/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.INumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;

public abstract class NumericArrayValue<T extends Number>
extends AbstractArrayValue<T>
implements INumericValue<T> {
    private final T minValue;
    private final T maxValue;
    private NumberRange<T> range;

    public NumericArrayValue(ValueData<T[]> valueData, T minValue, T maxValue) {
        super(valueData);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public abstract NumberRange<T> getValueRange(Field var1);

    @Override
    protected void readFieldData(Field field) {
        super.readFieldData(field);
        this.range = this.getValueRange(field);
    }

    @Override
    protected T[] validateValue(T[] in) {
        Number[] updatedArray = (Number[])super.validateValue(in);
        for (int i = 0; i < updatedArray.length; ++i) {
            Number num = updatedArray[i];
            if (this.range == null || this.range.isWithinRange(num)) continue;
            Number clamped = this.range.clamp(num);
            ConfigUtils.logCorrectedMessage(this.getId() + "[" + i + "]", num, clamped);
            updatedArray[i] = clamped;
        }
        return updatedArray;
    }

    @Override
    public final T min() {
        return this.minValue;
    }

    @Override
    public final T max() {
        return this.maxValue;
    }

    @Override
    public final NumberRange<T> getRange() {
        return this.range;
    }
}

