/*
 * Decompiled with CFR 0.152.
 */
package cutefox.betterenchanting.Util;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import cutefox.betterenchanting.BetterEnchanting;
import cutefox.betterenchanting.config.GlobalConfig;
import cutefox.betterenchanting.datagen.ModEnchantIngredientMap;
import cutefox.betterenchanting.registry.ModEnchantmentTags;
import cutefox.betterenchanting.registry.ModItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.hyper_pigeon.horseshoes.Horseshoes;
import net.hyper_pigeon.horseshoes.items.HorseshoesItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class ModEnchantmentHelper {
    public static int getEnchantmentLevelCost(class_1887 enchantment, int enchantLevel, class_1799 stack, class_1937 world) {
        float tempCost = GlobalConfig.baseEnchantmentCost / enchantment.method_58445() + enchantLevel;
        tempCost = (float)((double)tempCost * (1.0 + GlobalConfig.consecutiveEnchantIncrease * (double)stack.method_58657().method_57541()));
        for (Object2IntMap.Entry e : stack.method_58657().method_57539()) {
            tempCost += (float)stack.method_58657().method_57536((class_6880)e.getKey());
        }
        if (ModEnchantmentHelper.enchantIsTreasure(enchantment, world)) {
            tempCost = (float)((double)tempCost * GlobalConfig.tresaureMultiplier);
        }
        int encahntability = stack.method_7909().method_7837();
        return Math.round(tempCost *= (float)(1 - encahntability / 100));
    }

    public static int getCatalystEnchantmentCost(class_1799 outputItem) {
        float tempCost = 0.0f;
        for (Object2IntMap.Entry e : class_1890.method_57532((class_1799)outputItem).method_57539()) {
            tempCost += (float)((class_1887)((class_6880)e.getKey()).comp_349()).method_58446();
            tempCost += (float)Math.min(Math.round(e.getIntValue() / 2), 1);
        }
        return Math.round(tempCost);
    }

    private static boolean enchantIsTreasure(class_1887 enchantment, class_1937 world) {
        Optional treasureList = world.method_30349().method_30530(class_7924.field_41265).method_40266(ModEnchantmentTags.BENEFICIAL_TREASURE);
        if (treasureList != null && !treasureList.isEmpty()) {
            return ((class_6885.class_6888)treasureList.get()).method_40239().filter(e -> e.comp_349() == enchantment).count() > 0L;
        }
        return false;
    }

    public static int getEnchantmentLeveRequierment(class_1887 enchantment, int enchantLevel) {
        int tempLevelReq = 10 - enchantment.method_58445() + enchantLevel * enchantLevel;
        return tempLevelReq > 30 ? 30 : tempLevelReq;
    }

    public static int getBookshelfCountRequierment(class_1887 enchantment, int enchantLevel) {
        int tempReq = (int)Math.floor(ModEnchantmentHelper.getEnchantmentLeveRequierment(enchantment, enchantLevel) / 2);
        return tempReq <= 3 ? 0 : tempReq;
    }

    public static class_1792 getEnchantIngredient(class_1887 enchantment, int enchantLevel) {
        return ModEnchantIngredientMap.getIngredientOfLevel(enchantment, enchantLevel);
    }

    public static List<class_1792> getIngredientsOfEnchantment(class_1887 enchantment) {
        return ModEnchantIngredientMap.getIngredientsOfEnchantment(enchantment);
    }

    public static int getEnchantmentIngredientCost(class_1887 value, int displayedEnchantLevel, class_1792 ingredient) {
        if (GlobalConfig.overideItemCost) {
            if (GlobalConfig.overidenItemCost > ingredient.method_7882()) {
                return ingredient.method_7882();
            }
            if (value.method_8183() == displayedEnchantLevel) {
                return 1;
            }
            return GlobalConfig.overidenItemCost;
        }
        int tempValue = (int)Math.floor(value.method_58445() / 2);
        if (value.method_8183() == displayedEnchantLevel) {
            tempValue = 1;
        }
        int n = tempValue = tempValue == 0 ? 1 : tempValue;
        if (ingredient == null) {
            return tempValue;
        }
        return tempValue > ingredient.method_7882() ? ingredient.method_7882() : tempValue;
    }

    public static List<class_1889> getPossibleEntries(int bookshelfCount, class_1799 itemToEnchant, class_5455 registryManager) {
        if (itemToEnchant.method_31574(class_1802.field_8529)) {
            return List.of();
        }
        Optional enchantingTableList = registryManager.method_30530(class_7924.field_41265).method_40266(class_9636.field_51547);
        Optional treasureList = registryManager.method_30530(class_7924.field_41265).method_40266(class_9636.field_51557);
        ArrayList list = Lists.newArrayList();
        if (enchantingTableList.isEmpty()) {
            return list;
        }
        Stream<class_6880> concatEnchantList = !treasureList.isEmpty() ? Stream.concat(((class_6885.class_6888)enchantingTableList.get()).method_40239(), ((class_6885.class_6888)treasureList.get()).method_40239()) : ((class_6885.class_6888)enchantingTableList.get()).method_40239();
        ArrayList<class_5321> swordEnchants = new ArrayList<class_5321>();
        swordEnchants.add(class_1893.field_9124);
        swordEnchants.add(class_1893.field_9110);
        swordEnchants.add(class_1893.field_9121);
        concatEnchantList.filter(enchant -> {
            if (enchant.method_40220(class_9636.field_51551)) {
                return false;
            }
            boolean validEnchant = ((class_1887)enchant.comp_349()).method_8192(itemToEnchant);
            if (!validEnchant && itemToEnchant.method_31573(class_3489.field_42612) && swordEnchants.contains(enchant.method_40230().get())) {
                validEnchant = true;
            }
            if (GlobalConfig.disabledEnchants.contains(((class_5321)enchant.method_40230().get()).method_29177())) {
                return false;
            }
            return validEnchant;
        }).forEach(enchant -> {
            class_1887 enchantmentValue = (class_1887)enchant.comp_349();
            if (ModEnchantmentHelper.isCompatible(itemToEnchant.method_58657().method_57534(), (class_6880<class_1887>)enchant)) {
                for (int j = enchantmentValue.method_8183(); j >= enchantmentValue.method_8187(); --j) {
                    if (ModEnchantmentHelper.getBookshelfCountRequierment(enchantmentValue, j) > bookshelfCount) continue;
                    list.add(new class_1889(enchant, j));
                    break;
                }
            }
        });
        return list;
    }

    public static boolean itemHasPreviousLevelOfEnchant(class_1799 stack, class_6880<class_1887> enchant, int targetLevel) {
        int currentEnchantLevel = class_1890.method_8225(enchant, (class_1799)stack);
        return currentEnchantLevel == targetLevel;
    }

    public static boolean canBeCombined(class_6880<class_1887> first, class_6880<class_1887> second) {
        return !((class_1887)first.comp_349()).comp_2688().method_40241(second) && !((class_1887)second.comp_349()).comp_2688().method_40241(first);
    }

    public static boolean isCompatible(Collection<class_6880<class_1887>> existing, class_6880<class_1887> candidate) {
        for (class_6880<class_1887> registryEntry : existing) {
            if (ModEnchantmentHelper.canBeCombined(registryEntry, candidate) || registryEntry.equals(candidate)) continue;
            return false;
        }
        return true;
    }

    public static boolean itemIsEnchantable(class_1799 itemStacks) {
        ArrayList<HorseshoesItem> enchantableModdedItems = new ArrayList<HorseshoesItem>();
        if (BetterEnchanting.HORSESHOES_PRESENT) {
            enchantableModdedItems.addAll(List.of(Horseshoes.DIAMOND_HORSESHOES_ITEM, Horseshoes.IRON_HORSESHOES_ITEM, Horseshoes.GOLD_HORSESHOES_ITEM));
        }
        return enchantableModdedItems.contains(itemStacks.method_7909()) || itemStacks.method_7909().method_7870(itemStacks);
    }

    public static List<class_1799> replaceEnchantedBook(@Nullable @Local LocalRef<class_1799> localRef, class_1799 item) {
        ArrayList<class_1799> returnList = new ArrayList<class_1799>();
        int i = 0;
        class_1799 localRefItemStack = item.method_7972();
        if (localRefItemStack.method_7909().equals(class_1802.field_8598)) {
            class_9304 bookEnchants = class_1890.method_57532((class_1799)localRefItemStack);
            for (Object2IntMap.Entry ench : bookEnchants.method_57539()) {
                class_1799 newItem;
                bookEnchants.method_57539();
                int enchantLevel = ench.getIntValue();
                class_1887 enchantment = (class_1887)((class_6880)ench.getKey()).comp_349();
                List<class_1792> ingredientsOfEnchant = ModEnchantIngredientMap.getIngredientsOfEnchantment(enchantment);
                if (ingredientsOfEnchant != null && !ingredientsOfEnchant.isEmpty()) {
                    if (enchantLevel > ingredientsOfEnchant.size()) {
                        enchantLevel = ingredientsOfEnchant.size();
                    }
                    newItem = new class_1799((class_1935)ingredientsOfEnchant.get(enchantLevel - 1));
                    if (enchantLevel < ingredientsOfEnchant.size()) {
                        class_5819 rand = class_5819.method_43047();
                        newItem.method_7939(enchantLevel + rand.method_39332(1, 3));
                    }
                } else {
                    newItem = new class_1799((class_1935)class_1802.field_8287);
                }
                if (i > 0 || localRef == null) {
                    returnList.add(newItem);
                } else if (localRef != null) {
                    localRef.set((Object)newItem);
                }
                ++i;
            }
        }
        return returnList;
    }

    public static class_1799 combineCatalyst(class_1799 firstCatalyst, class_1799 secondCatalyst) {
        class_1799 output = new class_1799((class_1935)ModItems.ENCHANTMENT_CATALYST);
        output.method_57379(class_9334.field_50071, (Object)1);
        class_1890.method_57532((class_1799)firstCatalyst).method_57539().stream().forEach(e -> output.method_7978((class_6880)e.getKey(), e.getIntValue()));
        for (Object2IntMap.Entry e2 : class_1890.method_57532((class_1799)secondCatalyst).method_57539()) {
            if (output.method_58657().method_57534().contains(e2.getKey())) {
                int oldValue;
                int newLevel = e2.getIntValue();
                if (newLevel > (oldValue = output.method_58657().method_57536((class_6880)e2.getKey()))) {
                    output.method_7978((class_6880)e2.getKey(), e2.getIntValue());
                    continue;
                }
                if (oldValue != newLevel) continue;
                int maxLevel = ((class_1887)((class_6880)e2.getKey()).comp_349()).method_8183();
                output.method_7978((class_6880)e2.getKey(), Math.min(oldValue + 1, maxLevel));
                continue;
            }
            if (!class_1890.method_8201((Collection)output.method_58657().method_57534(), (class_6880)((class_6880)e2.getKey()))) continue;
            output.method_7978((class_6880)e2.getKey(), e2.getIntValue());
        }
        return output;
    }
}

