/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.limitedlives.common.core;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Date;
import me.ichun.mods.ichunutil.common.entity.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.limitedlives.api.IApi;
import me.ichun.mods.limitedlives.common.LimitedLives;
import me.ichun.mods.limitedlives.common.command.CommandLimitedLives;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class EventHandlerServer
implements IApi {
    public static final String LL_PERSISTED_TAG = "LimitedLivesSave";
    public static final class_2960 HEALTH_MODIFIER_ID = class_2960.method_60655((String)"limitedlives", (String)"max_health_modifier");

    public EventHandlerServer() {
        iChunUtil.eS().registerPlayerTickEndListener(player -> {
            if (!player.method_37908().method_8608() && player.field_6012 % 20 == 0) {
                this.onPlayerTickEnd((class_1657)player);
            }
        });
        iChunUtil.eS().registerCommandRegistrationListener(this::onRegisterCommands);
    }

    public void onLivingDeath(class_1309 living) {
        class_3222 player;
        if (!living.method_5770().field_9236 && living instanceof class_3222 && !EntityHelper.isFakePlayer((class_3222)(player = (class_3222)living))) {
            if (player.field_13974.method_14257() == class_1934.field_9220 || player.field_13974.method_14257() == class_1934.field_9219) {
                return;
            }
            class_2487 tag = EntityHelper.getPlayerPersistentData((class_1657)player, (String)LL_PERSISTED_TAG);
            tag.method_10569("deathCount", tag.method_10550("deathCount") + 1);
            tag.method_10544("lastDeath", System.currentTimeMillis());
        }
    }

    public void onPlayerRespawn(class_3222 player, boolean endConquered) {
        if (endConquered) {
            return;
        }
        if (player.field_13974.method_14257() == class_1934.field_9220 || player.field_13974.method_14257() == class_1934.field_9219) {
            return;
        }
        class_2487 tag = EntityHelper.getPlayerPersistentData((class_1657)player, (String)LL_PERSISTED_TAG);
        int deaths = tag.method_10550("deathCount");
        if (deaths >= LimitedLives.config.maxLives) {
            class_1324 attribute = player.method_5996(class_5134.field_23716);
            attribute.method_6200(HEALTH_MODIFIER_ID);
            MinecraftServer server = player.method_5682();
            if (LimitedLives.config.banType == LimitedLives.BanType.SPECTATOR || server.method_3724() && server.method_43824().getName().equals(player.method_5477().getString())) {
                tag.method_10569("gameMode", player.field_13974.method_14257().method_8379());
                tag.method_10544("timeBanned", System.currentTimeMillis());
                player.method_7336(class_1934.field_9219);
                player.field_6017 = 0.0f;
                player.method_7353((class_2561)(LimitedLives.config.banDuration == 0 ? class_2561.method_43471((String)"limitedlives.spectateForcePerma") : class_2561.method_43469((String)"limitedlives.spectateForce", (Object[])new Object[]{LimitedLives.config.banDuration})), false);
            } else {
                class_3336 userlistbansentry = new class_3336(player.method_7334(), null, "Limited Lives", LimitedLives.config.banDuration == 0 ? null : new Date(System.currentTimeMillis() + (long)LimitedLives.config.banDuration * 1000L), class_2561.method_43471((String)"limitedlives.banReason").getString());
                server.method_3760().method_14563().method_14633((class_3330)userlistbansentry);
                player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"limitedlives.banKickReason"));
            }
        } else {
            this.setPlayerDeaths(player, deaths, true);
            if (LimitedLives.config.announceOnRespawn) {
                player.method_7353((class_2561)class_2561.method_43469((String)"limitedlives.livesLeft", (Object[])new Object[]{LimitedLives.config.maxLives - deaths}), false);
            }
        }
    }

    public void onPlayerTickEnd(class_1657 playerUnsided) {
        if (playerUnsided instanceof class_3222) {
            class_3222 player = (class_3222)playerUnsided;
            class_2487 tag = EntityHelper.getPlayerPersistentData((class_1657)player, (String)LL_PERSISTED_TAG);
            int deaths = tag.method_10550("deathCount");
            if (LimitedLives.config.timeToNewLife > 0 && tag.method_10545("lastDeath") && deaths > 0) {
                int timeToNewLifeMs;
                long timeOfLastDeath = tag.method_10537("lastDeath");
                long timeSinceLastDeath = System.currentTimeMillis() - timeOfLastDeath;
                if (timeSinceLastDeath >= (long)(timeToNewLifeMs = LimitedLives.config.timeToNewLife * 1000)) {
                    int livesToGive = class_3532.method_15340((int)((int)Math.floor((double)timeSinceLastDeath / (double)timeToNewLifeMs)), (int)0, (int)(LimitedLives.config.maxLives - deaths));
                    deaths = class_3532.method_15340((int)(deaths - livesToGive), (int)0, (int)Integer.MAX_VALUE);
                    tag.method_10569("deathCount", deaths);
                    tag.method_10544("lastDeath", System.currentTimeMillis());
                    player.method_7353((class_2561)class_2561.method_43469((String)"limitedlives.livesRegained", (Object[])new Object[]{livesToGive, LimitedLives.config.maxLives - deaths}), false);
                }
            }
            if (deaths >= LimitedLives.config.maxLives && LimitedLives.config.banDuration > 0 && player.method_5805()) {
                long timeBanned = tag.method_10537("timeBanned");
                long banDurationMs = (long)LimitedLives.config.banDuration * 1000L;
                long timeBanDone = System.currentTimeMillis() - timeBanned;
                long timeBanLeft = banDurationMs - timeBanDone;
                int announceTimeFrequency = LimitedLives.config.timeRemainingMessageFrequency * 60 * 1000;
                if (announceTimeFrequency > 0 && timeBanLeft % (long)announceTimeFrequency > (timeBanLeft + 1000L) % (long)announceTimeFrequency && timeBanLeft + 1000L > (long)announceTimeFrequency && player.field_13974.method_14257() == class_1934.field_9219) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"limitedlives.respawnTimeLeft", (Object[])new Object[]{(int)Math.ceil((float)timeBanLeft / 60000.0f)}), false);
                }
                if (new Date(timeBanned + banDurationMs).before(new Date()) || player.field_13974.method_14257() != class_1934.field_9219) {
                    this.pardon(player, tag);
                }
            }
        }
    }

    public void pardon(class_3222 player, class_2487 tag) {
        boolean respawn = false;
        if (player.field_13974.method_14257() == class_1934.field_9219) {
            respawn = true;
            player.field_13974.method_30118(class_1934.method_8384((int)tag.method_10550("gameMode")));
            class_1324 attribute = player.method_5996(class_5134.field_23716);
            attribute.method_6200(HEALTH_MODIFIER_ID);
        }
        tag.method_10551("deathCount");
        tag.method_10551("lastDeath");
        tag.method_10551("gameMode");
        tag.method_10551("timeBanned");
        if (respawn) {
            player.field_13987.field_14140 = player.method_5682().method_3760().method_14556(player, false, class_1297.class_5529.field_27002);
            player.method_7353((class_2561)class_2561.method_43471((String)"limitedlives.respawned"), false);
        }
    }

    public void onRegisterCommands(CommandDispatcher<class_2168> dispatcher) {
        CommandLimitedLives.register(dispatcher);
    }

    @Override
    public void setPlayerDeaths(@NotNull class_3222 player, int deaths, boolean resetHealth) {
        class_2487 tag = EntityHelper.getPlayerPersistentData((class_1657)player, (String)LL_PERSISTED_TAG);
        tag.method_10569("deathCount", deaths);
        tag.method_10544("lastDeath", System.currentTimeMillis());
        if (LimitedLives.config.healthAdjust != 0.0) {
            double healthRatio = player.method_6032() / player.method_6063();
            class_1324 attribute = player.method_5996(class_5134.field_23716);
            attribute.method_6200(HEALTH_MODIFIER_ID);
            double healthOffset = LimitedLives.config.healthAdjust * (double)deaths;
            if (LimitedLives.config.maxHealthReduction < 0.0 && healthOffset < LimitedLives.config.maxHealthReduction) {
                healthOffset = LimitedLives.config.maxHealthReduction;
            }
            attribute.method_26837(new class_1322(HEALTH_MODIFIER_ID, healthOffset, class_1322.class_1323.field_6328));
            if (resetHealth) {
                player.method_6033((float)attribute.method_6194());
            } else {
                double targetHealth = healthRatio * (double)player.method_6063();
                player.method_6033((float)targetHealth);
            }
        }
    }

    @Override
    public int getPlayerDeaths(@NotNull class_3222 player) {
        class_2487 tag = EntityHelper.getPlayerPersistentData((class_1657)player, (String)LL_PERSISTED_TAG);
        return tag.method_10550("deathCount");
    }
}

