/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.config;

import me.timvinci.terrastorage.config.ConfigProperty;
import me.timvinci.terrastorage.config.PropertyRange;
import me.timvinci.terrastorage.config.SingleOption;
import me.timvinci.terrastorage.config.SubProperty;
import me.timvinci.terrastorage.util.BorderVisibility;
import me.timvinci.terrastorage.util.ButtonsPlacement;
import me.timvinci.terrastorage.util.ButtonsStyle;
import me.timvinci.terrastorage.util.ButtonsTextures;
import me.timvinci.terrastorage.util.QuickStackMode;
import me.timvinci.terrastorage.util.SortType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TerrastorageClientConfig {
    @ConfigProperty(key="display_options_button", comment="Whether to display the options button in the storage screens")
    private boolean displayOptionsButton = true;
    @ConfigProperty(key="hotbar_protection", comment="Whether to protect hotbar items from the storage options")
    private boolean hotbarProtection = true;
    @ConfigProperty(key="sort_type", comment="The property by which items will be sorted")
    private SortType sortType = SortType.ITEM_GROUP;
    @ConfigProperty(key="buttons_tooltip", comment="Whether the storage option buttons have description tooltips.")
    @SubProperty
    private boolean buttonsTooltip = true;
    @ConfigProperty(key="buttons_style", comment="The style of the storage option buttons")
    @SubProperty
    private ButtonsStyle buttonsStyle = ButtonsStyle.DEFAULT;
    @ConfigProperty(key="buttons_placement", comment="The placement of the storage option buttons")
    @SubProperty
    private ButtonsPlacement buttonsPlacement = ButtonsPlacement.RIGHT;
    @ConfigProperty(key="buttons_x_offset", comment="The horizontal offset of the storage option buttons")
    @PropertyRange(min=-100, max=100)
    @SubProperty
    private int buttonsXOffset = 0;
    @ConfigProperty(key="buttons_y_offset", comment="The vertical offset aof the storage option buttons")
    @PropertyRange(min=-100, max=100)
    @SubProperty
    private int buttonsYOffset = 0;
    @ConfigProperty(key="buttons_width", comment="The width of the storage option buttons")
    @PropertyRange(min=20, max=150)
    @SubProperty
    private int buttonsWidth = 70;
    @ConfigProperty(key="buttons_height", comment="The height of the storage option buttons")
    @PropertyRange(min=5, max=50)
    private int buttonsHeight = 15;
    @ConfigProperty(key="buttons_spacing", comment="The vertical spacing between the storage option buttons")
    @PropertyRange(min=0, max=20)
    private int buttonsSpacing = 2;
    @ConfigProperty(key="border_visibility", comment="When the favorite item border is displayed on slots holding favorite items.")
    @SingleOption
    private BorderVisibility borderVisibility = BorderVisibility.ALWAYS;
    @ConfigProperty(key="storage_quick_stack_mode", comment="The quick stacking mode used when quick stacking into a single storage")
    @SingleOption
    private QuickStackMode storageQuickStackMode = QuickStackMode.SMART_DEPOSIT;
    @ConfigProperty(key="nearby_quick_stack_mode", comment="The quick stacking mode used when quick stacking to nearby storages")
    @SingleOption
    private QuickStackMode nearbyQuickStackMode = QuickStackMode.SMART_DEPOSIT;
    @ConfigProperty(key="buttons_textures", comment="The textures used by the inventory storage option buttons.")
    private ButtonsTextures buttonsTextures = ButtonsTextures.MINECRAFT;

    public boolean getDisplayOptionsButton() {
        return this.displayOptionsButton;
    }

    public boolean getHotbarProtection() {
        return this.hotbarProtection;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public boolean getButtonsTooltip() {
        return this.buttonsTooltip;
    }

    public void setButtonsTooltip(boolean buttonsTooltip) {
        this.buttonsTooltip = buttonsTooltip;
    }

    public ButtonsStyle getButtonsStyle() {
        return this.buttonsStyle;
    }

    public void setButtonsStyle(ButtonsStyle buttonsStyle) {
        this.buttonsStyle = buttonsStyle;
    }

    public ButtonsPlacement getButtonsPlacement() {
        return this.buttonsPlacement;
    }

    public void setButtonsPlacement(ButtonsPlacement buttonsPlacement) {
        this.buttonsPlacement = buttonsPlacement;
    }

    public int getButtonsXOffset() {
        return this.buttonsXOffset;
    }

    public void setButtonsXOffset(int buttonsXOffset) {
        this.buttonsXOffset = buttonsXOffset;
    }

    public int getButtonsYOffset() {
        return this.buttonsYOffset;
    }

    public void setButtonsYOffset(int buttonsYOffset) {
        this.buttonsYOffset = buttonsYOffset;
    }

    public int getButtonsWidth() {
        return this.buttonsWidth;
    }

    public void setButtonsWidth(int buttonsWidth) {
        this.buttonsWidth = buttonsWidth;
    }

    public int getButtonsHeight() {
        return this.buttonsHeight;
    }

    public void setButtonsHeight(int buttonsHeight) {
        this.buttonsHeight = buttonsHeight;
    }

    public int getButtonsSpacing() {
        return this.buttonsSpacing;
    }

    public void setButtonsSpacing(int buttonsSpacing) {
        this.buttonsSpacing = buttonsSpacing;
    }

    public QuickStackMode getStorageQuickStackMode() {
        return this.storageQuickStackMode;
    }

    public QuickStackMode getNearbyQuickStackMode() {
        return this.nearbyQuickStackMode;
    }

    public BorderVisibility getBorderVisibility() {
        return this.borderVisibility;
    }

    public ButtonsTextures getButtonsTextures() {
        return this.buttonsTextures;
    }
}

