/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.gui.widget;

import java.util.Locale;
import me.timvinci.terrastorage.config.ClientConfigManager;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.gui.RenameScreen;
import me.timvinci.terrastorage.gui.widget.StorageButtonWidget;
import me.timvinci.terrastorage.network.ClientNetworkHandler;
import me.timvinci.terrastorage.util.ButtonsStyle;
import me.timvinci.terrastorage.util.StorageAction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_344;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8666;

@Environment(value=EnvType.CLIENT)
public class StorageButtonCreator {
    public static StorageButtonWidget createStorageButton(StorageAction action, int x, int y, int width, int height, class_2561 buttonText, ButtonsStyle buttonStyle) {
        class_4185.class_4241 onPress;
        switch (action) {
            case SORT_ITEMS: {
                class_4185.class_4241 class_42412 = button -> ClientNetworkHandler.sendSortPayload(false);
                break;
            }
            case RENAME: {
                class_4185.class_4241 class_42412 = button -> {
                    class_310 client = class_310.method_1551();
                    String name = client.field_1755.method_25440().getString();
                    client.execute(() -> client.method_1507((class_437)new RenameScreen(client.field_1755, name)));
                };
                break;
            }
            default: {
                class_4185.class_4241 class_42412 = onPress = button -> ClientNetworkHandler.sendActionPayload(action);
            }
        }
        if (buttonStyle == ButtonsStyle.TEXT_ONLY) {
            width = class_310.method_1551().field_1772.method_27525((class_5348)buttonText) + 6;
        }
        return new StorageButtonWidget(x, y, width, height, buttonText, buttonStyle, onPress);
    }

    public static StorageButtonWidget createDummyStorageButton(int width, int height, class_2561 buttonText, ButtonsStyle buttonStyle) {
        if (buttonStyle == ButtonsStyle.TEXT_ONLY) {
            width = class_310.method_1551().field_1772.method_27525((class_5348)buttonText) + 6;
        }
        return new StorageButtonWidget(0, 0, width, height, buttonText, buttonStyle, onPress -> {});
    }

    public static class_3545<class_344, class_344> createInventoryButtons(int x, int y) {
        class_8666 quickStackTexture = StorageButtonCreator.getButtonTextures("quick_stack");
        class_8666 sortInventoryTexture = StorageButtonCreator.getButtonTextures("sort_inventory");
        class_344 quickStackButton = new class_344(x, y, 20, 18, quickStackTexture, onPress -> ClientNetworkHandler.sendActionPayload(StorageAction.QUICK_STACK_TO_NEARBY));
        quickStackButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"terrastorage.button.tooltip.quick_stack_to_nearby")));
        class_344 sortInventoryButton = new class_344(x + 24, y, 20, 18, sortInventoryTexture, onPress -> ClientNetworkHandler.sendSortPayload(true));
        sortInventoryButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"terrastorage.button.tooltip.sort_inventory")));
        return new class_3545((Object)quickStackButton, (Object)sortInventoryButton);
    }

    private static class_8666 getButtonTextures(String buttonName) {
        String stylePrefix = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsTextures().name().toLowerCase(Locale.ENGLISH);
        return new class_8666(class_2960.method_60655((String)"terrastorage", (String)(stylePrefix + "_" + buttonName)), class_2960.method_60655((String)"terrastorage", (String)(stylePrefix + "_" + buttonName + "_highlighted")));
    }
}

