/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import me.timvinci.terrastorage.api.ItemFavoritingUtils;
import me.timvinci.terrastorage.inventory.InventoryState;
import me.timvinci.terrastorage.item.StackIdentifier;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_9335;

public class CompactInventoryState
implements InventoryState {
    private final Map<StackIdentifier, ArrayList<Integer>> nonFullItemSlots = new HashMap<StackIdentifier, ArrayList<Integer>>();
    private boolean modified = false;

    public CompactInventoryState(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 inventoryStack = inventory.method_5438(i);
            if (inventoryStack.method_7960() || inventoryStack.method_7947() == inventoryStack.method_7914()) continue;
            this.nonFullItemSlots.computeIfAbsent(new StackIdentifier(inventoryStack), k -> new ArrayList()).add(i);
        }
    }

    public CompactInventoryState(class_1661 playerInventory, boolean hotbarProtection) {
        class_9335 components;
        StackIdentifier stackIdentifier;
        class_1799 playerStack;
        int i;
        for (i = class_1661.method_7368(); i < playerInventory.field_7547.size(); ++i) {
            playerStack = playerInventory.method_5438(i);
            if (playerStack.method_7960() || playerStack.method_7947() == playerStack.method_7914()) continue;
            if (!ItemFavoritingUtils.isFavorite(playerStack)) {
                stackIdentifier = new StackIdentifier(playerStack);
            } else {
                components = new class_9335(playerStack.method_57353());
                ItemFavoritingUtils.unFavorite(components);
                stackIdentifier = new StackIdentifier(playerStack.method_7909(), components);
            }
            this.nonFullItemSlots.computeIfAbsent(stackIdentifier, k -> new ArrayList()).add(i);
        }
        if (!hotbarProtection) {
            for (i = 0; i < class_1661.method_7368(); ++i) {
                playerStack = playerInventory.method_5438(i);
                if (playerStack.method_7960() || playerStack.method_7947() == playerStack.method_7914()) continue;
                if (!ItemFavoritingUtils.isFavorite(playerStack)) {
                    stackIdentifier = new StackIdentifier(playerStack);
                } else {
                    components = new class_9335(playerStack.method_57353());
                    ItemFavoritingUtils.unFavorite(components);
                    stackIdentifier = new StackIdentifier(playerStack.method_7909(), components);
                }
                this.nonFullItemSlots.computeIfAbsent(stackIdentifier, k -> new ArrayList()).add(i);
            }
        }
    }

    @Override
    public Map<StackIdentifier, ArrayList<Integer>> getNonFullItemSlots() {
        return this.nonFullItemSlots;
    }

    @Override
    public Queue<Integer> getEmptySlots() {
        return null;
    }

    @Override
    public void setModified() {
        this.modified = true;
    }

    @Override
    public boolean wasModified() {
        return this.modified;
    }
}

