/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.inventory;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import me.timvinci.terrastorage.inventory.InventoryState;
import me.timvinci.terrastorage.item.StackIdentifier;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

public class ExpandedInventoryState
implements InventoryState {
    private final Map<StackIdentifier, ArrayList<Integer>> nonFullItemSlots = new HashMap<StackIdentifier, ArrayList<Integer>>();
    private final Queue<Integer> emptySlots = new ArrayDeque<Integer>();
    private final Set<StackIdentifier> storedItems = new HashSet<StackIdentifier>();
    private boolean modified = false;

    public ExpandedInventoryState(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 inventoryStack = inventory.method_5438(i);
            if (inventoryStack.method_7960()) {
                this.emptySlots.add(i);
                continue;
            }
            StackIdentifier stackIdentifier = new StackIdentifier(inventoryStack);
            if (inventoryStack.method_7947() != inventoryStack.method_7914()) {
                this.nonFullItemSlots.computeIfAbsent(stackIdentifier, k -> new ArrayList()).add(i);
            }
            if (!inventoryStack.method_7946()) continue;
            this.storedItems.add(stackIdentifier);
        }
    }

    @Override
    public Map<StackIdentifier, ArrayList<Integer>> getNonFullItemSlots() {
        return this.nonFullItemSlots;
    }

    @Override
    public Queue<Integer> getEmptySlots() {
        return this.emptySlots;
    }

    public Set<StackIdentifier> getStoredItems() {
        return this.storedItems;
    }

    @Override
    public void setModified() {
        this.modified = true;
    }

    @Override
    public boolean wasModified() {
        return this.modified;
    }
}

