/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.inventory;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.api.ExpandedStorageAccessors;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import me.timvinci.terrastorage.api.ItemFavoritingUtils;
import me.timvinci.terrastorage.config.ConfigManager;
import me.timvinci.terrastorage.config.TerrastorageConfig;
import me.timvinci.terrastorage.inventory.CompactInventoryState;
import me.timvinci.terrastorage.inventory.ExpandedInventoryState;
import me.timvinci.terrastorage.inventory.InventoryState;
import me.timvinci.terrastorage.item.GhostItemEntity;
import me.timvinci.terrastorage.item.StackIdentifier;
import me.timvinci.terrastorage.item.StackProcessor;
import me.timvinci.terrastorage.util.ComparatorTypes;
import me.timvinci.terrastorage.util.SortType;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import net.minecraft.class_8836;
import net.minecraft.class_9331;
import net.minecraft.class_9335;

public class InventoryUtils {
    public static boolean expandedStorageLoaded = false;

    public static void transferStack(class_1263 to, InventoryState receiverState, class_1799 stack) {
        StackIdentifier stackIdentifier = new StackIdentifier(stack);
        if (receiverState.getNonFullItemSlots().containsKey(stackIdentifier) && InventoryUtils.transferToExistingStack(to, receiverState, stack)) {
            return;
        }
        if (!receiverState.getEmptySlots().isEmpty()) {
            int emptySlot = receiverState.getEmptySlots().poll();
            to.method_5447(emptySlot, stack.method_51164());
            receiverState.setModified();
            if (stack.method_7947() != stack.method_7914()) {
                receiverState.getNonFullItemSlots().computeIfAbsent(stackIdentifier, k -> new ArrayList()).add(emptySlot);
            }
        }
    }

    public static boolean transferToExistingStack(class_1263 to, InventoryState receiverState, class_1799 stackToTransfer) {
        StackIdentifier stackIdentifier = new StackIdentifier(stackToTransfer);
        ArrayList<Integer> slotsWithItem = receiverState.getNonFullItemSlots().get(stackIdentifier);
        Iterator<Integer> slotsIterator = slotsWithItem.iterator();
        while (slotsIterator.hasNext() && !stackToTransfer.method_7960()) {
            int transferAmount;
            int slotWithItem = slotsIterator.next();
            class_1799 existingStack = to.method_5438(slotWithItem);
            int spaceLeft = existingStack.method_7914() - existingStack.method_7947();
            if (spaceLeft <= stackToTransfer.method_7947()) {
                transferAmount = spaceLeft;
                slotsIterator.remove();
            } else {
                transferAmount = stackToTransfer.method_7947();
            }
            existingStack.method_7933(transferAmount);
            stackToTransfer.method_7934(transferAmount);
            receiverState.setModified();
        }
        if (slotsWithItem.isEmpty()) {
            receiverState.getNonFullItemSlots().remove(stackIdentifier);
        }
        return stackToTransfer.method_7960();
    }

    public static List<class_1799> combineAndSortInventory(class_1263 inventory, SortType type, int startIndex, int endIndex, boolean ignoreFavorites) {
        ArrayList<class_1799> combinedStacks = new ArrayList<class_1799>();
        int initialCapacity = Math.max(16, (endIndex - startIndex) / 3);
        HashMap<StackIdentifier, class_1799> lastStackMap = new HashMap<StackIdentifier, class_1799>(initialCapacity);
        Predicate<class_1799> shouldSkip = ignoreFavorites ? stack -> stack.method_7960() || ItemFavoritingUtils.isFavorite(stack) : class_1799::method_7960;
        for (int i = startIndex; i < endIndex; ++i) {
            class_1799 stack2 = inventory.method_5438(i);
            if (shouldSkip.test(stack2)) continue;
            if (stack2.method_7914() <= 1 || stack2.method_7947() == stack2.method_7914()) {
                combinedStacks.add(stack2.method_7972());
                inventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            StackIdentifier identifier = new StackIdentifier(stack2);
            class_1799 lastStack = (class_1799)lastStackMap.get(identifier);
            if (lastStack == null || lastStack.method_7947() == stack2.method_7914()) {
                class_1799 newStack = stack2.method_7972();
                combinedStacks.add(newStack);
                lastStackMap.put(identifier, newStack);
            } else {
                int spaceLeft = lastStack.method_7914() - lastStack.method_7947();
                if (spaceLeft < stack2.method_7947()) {
                    lastStack.method_7933(spaceLeft);
                    class_1799 newStack = stack2.method_7972();
                    newStack.method_7939(stack2.method_7947() - spaceLeft);
                    combinedStacks.add(newStack);
                    lastStackMap.put(identifier, newStack);
                } else {
                    lastStack.method_7933(stack2.method_7947());
                }
            }
            inventory.method_5447(i, class_1799.field_8037);
        }
        Comparator<class_1799> comparator = switch (type) {
            case SortType.ITEM_GROUP -> ComparatorTypes.BY_GROUP;
            case SortType.ITEM_COUNT -> ComparatorTypes.BY_COUNT;
            case SortType.ITEM_RARITY -> ComparatorTypes.BY_RARITY;
            case SortType.ITEM_NAME -> ComparatorTypes.BY_NAME;
            case SortType.ITEM_ID -> ComparatorTypes.BY_ID;
            default -> throw new IllegalArgumentException("Unknown sort type: " + String.valueOf((Object)type));
        };
        combinedStacks.sort(comparator);
        return combinedStacks;
    }

    public static List<class_3545<class_1263, class_243>> getNearbyStorages(class_3222 player) {
        class_1937 world = player.method_37908();
        ArrayList<class_3545<class_1263, class_243>> nearbyStorages = new ArrayList<class_3545<class_1263, class_243>>();
        HashSet processedChests = new HashSet();
        int range = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getQuickStackRange();
        boolean performLosCheck = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getLineOfSightCheck();
        class_2338 playerPos = player.method_24515();
        class_2338.method_25996((class_2338)playerPos, (int)range, (int)range, (int)range).forEach(pos -> {
            class_1263 inventory;
            if (processedChests.contains(pos)) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_26215() || !state.method_31709()) {
                return;
            }
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5439() >= 27) {
                class_243 losPoint;
                class_2624 lockable;
                if (blockEntity instanceof class_2624 && !(lockable = (class_2624)blockEntity).method_17489((class_1657)player)) {
                    return;
                }
                if (performLosCheck) {
                    losPoint = InventoryUtils.hasLineOfSight(player, world, pos);
                    if (losPoint == class_243.field_1353) {
                        return;
                    }
                } else {
                    losPoint = pos.method_46558();
                }
                if (blockEntity instanceof class_2595) {
                    class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
                    if (chestType == class_2745.field_12569) {
                        nearbyStorages.add(new class_3545((Object)inventory, (Object)losPoint));
                        return;
                    }
                    class_2338 neighboringChestPos = InventoryUtils.getNeighboringChestPos(pos, chestType, (class_2350)state.method_11654((class_2769)class_2281.field_10768));
                    class_243 doubleChestLosPoint = InventoryUtils.getDoubleChestCenter(losPoint, neighboringChestPos.method_46558());
                    class_1263 neighboringChestInventory = (class_1263)world.method_8321(neighboringChestPos);
                    class_1258 doubleInventory = chestType == class_2745.field_12571 ? new class_1258(inventory, neighboringChestInventory) : new class_1258(neighboringChestInventory, inventory);
                    nearbyStorages.add(new class_3545((Object)doubleInventory, (Object)doubleChestLosPoint));
                    processedChests.add(neighboringChestPos);
                } else if (expandedStorageLoaded) {
                    Optional chestType = ExpandedStorageAccessors.getChestType((class_2680)state);
                    if (chestType.isEmpty() || chestType.get() == EsChestType.SINGLE) {
                        nearbyStorages.add(new class_3545((Object)inventory, (Object)losPoint));
                        return;
                    }
                    class_2338 neighboringChestPos = pos.method_10093((class_2350)ExpandedStorageAccessors.getAttachedChestDirection((class_2680)state).get());
                    class_243 doubleChestLosPoint = InventoryUtils.getDoubleChestCenter(losPoint, neighboringChestPos.method_46558());
                    class_1263 neighboringChestInventory = (class_1263)world.method_8321(neighboringChestPos);
                    class_1258 doubleInventory = chestType.get() == EsChestType.RIGHT ? new class_1258(inventory, neighboringChestInventory) : new class_1258(neighboringChestInventory, inventory);
                    nearbyStorages.add(new class_3545((Object)doubleInventory, (Object)doubleChestLosPoint));
                    processedChests.add(neighboringChestPos);
                } else {
                    nearbyStorages.add(new class_3545((Object)inventory, (Object)losPoint));
                }
            }
        });
        class_238 searchBox = new class_238(playerPos).method_1014((double)range);
        world.method_18023(class_5575.method_31795(class_8836.class), searchBox, entity -> {
            class_1263 inventory;
            return entity instanceof class_1263 && (inventory = (class_1263)entity).method_5439() >= 27;
        }).forEach(entity -> {
            class_243 losPoint;
            if (performLosCheck) {
                losPoint = InventoryUtils.hasLineOfSightToEntity(player, world, (class_1297)entity);
                if (losPoint == class_243.field_1353) {
                    return;
                }
            } else {
                losPoint = entity.method_5829().method_1005();
            }
            nearbyStorages.add(new class_3545((Object)((class_1263)entity), (Object)losPoint));
        });
        return nearbyStorages;
    }

    private static class_2338 getNeighboringChestPos(class_2338 chestBlockPos, class_2745 chestType, class_2350 facing) {
        return chestBlockPos.method_10093(chestType == class_2745.field_12574 ? facing.method_10170() : facing.method_10160());
    }

    private static class_243 getDoubleChestCenter(class_243 losPoint, class_243 secondChestCenter) {
        return losPoint.method_1031(secondChestCenter.field_1352, losPoint.field_1351, secondChestCenter.field_1350).method_1021(0.5);
    }

    private static class_243 hasLineOfSight(class_3222 player, class_1937 world, class_2338 pos) {
        class_243[] pointsToCheck;
        class_243 playerEyes = player.method_33571();
        class_243 centerPos = pos.method_46558();
        for (class_243 end : pointsToCheck = new class_243[]{centerPos, centerPos.method_1031(0.0, 0.5, 0.0), centerPos.method_1031(0.0, -0.5, 0.0)}) {
            class_3959 context = new class_3959(playerEyes, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 hitResult = world.method_17742(context);
            if (!hitResult.method_17777().equals((Object)pos) && hitResult.method_17783() != class_239.class_240.field_1333) continue;
            return end;
        }
        return class_243.field_1353;
    }

    private static class_243 hasLineOfSightToEntity(class_3222 player, class_1937 world, class_1297 entity) {
        class_243 end;
        class_243 playerEyes = player.method_33571();
        class_3965 result = world.method_17742(new class_3959(playerEyes, end = entity.method_5829().method_1005(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return result.method_17783() == class_239.class_240.field_1333 ? end : class_243.field_1353;
    }

    public static void triggerFlyOutAnimation(class_3218 world, class_243 playerEyes, int itemAnimationLength, Map<class_243, ArrayList<class_1792>> animationMap) {
        int itemAnimationInterval = ((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getItemAnimationInterval();
        for (Map.Entry<class_243, ArrayList<class_1792>> entry : animationMap.entrySet()) {
            class_243 targetPos = entry.getKey();
            class_243 itemVelocity = new class_243((targetPos.field_1352 - playerEyes.field_1352) / (double)itemAnimationLength, (targetPos.field_1351 - playerEyes.field_1351) / (double)itemAnimationLength, (targetPos.field_1350 - playerEyes.field_1350) / (double)itemAnimationLength);
            ArrayList<class_1792> items = entry.getValue();
            for (int i = 0; i < items.size(); ++i) {
                int movementDelay = i * itemAnimationInterval;
                GhostItemEntity ghostItem = new GhostItemEntity((class_1937)world, playerEyes.field_1352, playerEyes.field_1351, playerEyes.field_1350, items.get(i).method_7854(), itemVelocity, itemAnimationLength, movementDelay);
                world.method_8649((class_1297)ghostItem);
            }
        }
    }

    public static boolean areItemsAndComponentsEqual(class_1799 firstStack, class_1799 secondStack) {
        return class_1799.method_7984((class_1799)firstStack, (class_1799)secondStack) && InventoryUtils.areComponentsEqual(firstStack, secondStack);
    }

    private static boolean areComponentsEqual(class_1799 firstStack, class_1799 secondStack) {
        boolean secondStackIsFavorite;
        if (Objects.equals(firstStack.method_57353(), secondStack.method_57353())) {
            return true;
        }
        boolean firstStackIsFavorite = ItemFavoritingUtils.isFavorite(firstStack);
        if (firstStackIsFavorite ^ (secondStackIsFavorite = ItemFavoritingUtils.isFavorite(secondStack))) {
            class_9335 firstComponentMap = new class_9335(firstStack.method_57353());
            class_9335 secondComponentMap = new class_9335(secondStack.method_57353());
            if (firstStackIsFavorite) {
                ItemFavoritingUtils.unFavorite(firstComponentMap);
            } else {
                ItemFavoritingUtils.unFavorite(secondComponentMap);
            }
            return InventoryUtils.areComponentMapsEqual(firstComponentMap, secondComponentMap);
        }
        return false;
    }

    public static boolean areComponentMapsEqual(class_9335 firstMap, class_9335 secondMap) {
        if (firstMap.method_57835() != secondMap.method_57835()) {
            return false;
        }
        for (class_9331 type : firstMap.method_57831()) {
            Object value2;
            Object value1 = firstMap.method_57829(type);
            if (Objects.equals(value1, value2 = secondMap.method_57829(type))) continue;
            return false;
        }
        return true;
    }

    public static StackProcessor createStackProcessor(InventoryState storageInventoryState, class_1263 storageInventory, boolean smartDepositMode) {
        return smartDepositMode ? new StackProcessor(stack -> {
            StackIdentifier stackIdentifier = new StackIdentifier((class_1799)stack);
            return storageInventoryState.getNonFullItemSlots().containsKey(stackIdentifier) || ((ExpandedInventoryState)storageInventoryState).getStoredItems().contains(stackIdentifier) && !storageInventoryState.getEmptySlots().isEmpty();
        }, stack -> InventoryUtils.transferStack(storageInventory, storageInventoryState, stack)) : new StackProcessor(stack -> !stack.method_7960() && storageInventoryState.getNonFullItemSlots().containsKey(new StackIdentifier((class_1799)stack)), stack -> InventoryUtils.transferToExistingStack(storageInventory, storageInventoryState, stack));
    }

    public static Function<class_1263, InventoryState> getInventoryStateFactory(boolean smartDepositMode) {
        return smartDepositMode ? ExpandedInventoryState::new : CompactInventoryState::new;
    }
}

