/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.mixin.client;

import me.timvinci.terrastorage.api.ItemFavoritingUtils;
import me.timvinci.terrastorage.config.ClientConfigManager;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.gui.TerrastorageOptionsScreen;
import me.timvinci.terrastorage.gui.widget.StorageButtonCreator;
import me.timvinci.terrastorage.gui.widget.StorageButtonWidget;
import me.timvinci.terrastorage.keybinding.TerrastorageKeybindings;
import me.timvinci.terrastorage.network.ClientNetworkHandler;
import me.timvinci.terrastorage.util.BorderVisibility;
import me.timvinci.terrastorage.util.ButtonsPlacement;
import me.timvinci.terrastorage.util.ButtonsStyle;
import me.timvinci.terrastorage.util.LocalizedTextProvider;
import me.timvinci.terrastorage.util.ScreenInteractionUtils;
import me.timvinci.terrastorage.util.StorageAction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class HandledScreenMixin<T extends class_1703>
extends class_437 {
    @Unique
    private final class_2960 favoriteBorder = class_2960.method_60655((String)"terrastorage", (String)"textures/gui/sprites/favorite_border.png");
    @Shadow
    protected T field_2797;
    @Shadow
    protected int field_2792;
    @Shadow
    protected int field_2779;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    @Nullable
    protected class_1735 field_2787;

    protected HandledScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        if (class_310.method_1551().field_1724.method_7325() || this.field_2797 instanceof class_481.class_483 || this.field_2797 instanceof class_1723) {
            return;
        }
        boolean largeNonPlayerInventory = false;
        int nonPlayerSlotCount = 0;
        for (class_1735 slot : ((class_1703)this.field_2797).field_7761) {
            if (slot.field_7871 instanceof class_1661) continue;
            if (slot.field_7871.method_5439() >= 27) {
                largeNonPlayerInventory = true;
                break;
            }
            ++nonPlayerSlotCount;
        }
        if (!largeNonPlayerInventory && nonPlayerSlotCount < 27) {
            return;
        }
        boolean isEnderChest = this.field_2797 instanceof class_1707 && this.method_25440().equals((Object)class_2561.method_43471((String)"container.enderchest"));
        StorageAction[] buttonActions = StorageAction.getButtonsActions(isEnderChest);
        ButtonsStyle buttonsStyle = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsStyle();
        int buttonsXOffset = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsXOffset();
        int buttonsYOffset = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsYOffset();
        int buttonsWidth = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsWidth();
        int buttonsHeight = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsHeight();
        int buttonsSpacing = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsSpacing();
        int buttonX = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsPlacement() == ButtonsPlacement.RIGHT ? this.field_2776 + this.field_2792 + 5 + buttonsXOffset : this.field_2776 - ((buttonsStyle == ButtonsStyle.DEFAULT ? buttonsWidth : 70) + 5) + buttonsXOffset;
        int containerHeight = this.field_2779 - 94;
        int buttonSectionHeight = buttonActions.length * buttonsHeight + (buttonActions.length - 1) * buttonsSpacing;
        int buttonY = this.field_2800 - (buttonSectionHeight - containerHeight) / 2 + buttonsYOffset;
        if (((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getButtonsTooltip()) {
            for (StorageAction storageAction : buttonActions) {
                class_2561 buttonText = LocalizedTextProvider.buttonTextCache.get((Object)storageAction);
                class_7919 buttonTooltip = LocalizedTextProvider.buttonTooltipCache.get((Object)storageAction);
                StorageButtonWidget storageButton = StorageButtonCreator.createStorageButton(storageAction, buttonX, buttonY, buttonsWidth, buttonsHeight, buttonText, buttonsStyle);
                storageButton.method_47400(buttonTooltip);
                this.method_37063((class_364)storageButton);
                buttonY += buttonsHeight + buttonsSpacing;
            }
        } else {
            for (StorageAction storageAction : buttonActions) {
                class_2561 buttonText = LocalizedTextProvider.buttonTextCache.get((Object)storageAction);
                StorageButtonWidget storageButton = StorageButtonCreator.createStorageButton(storageAction, buttonX, buttonY, buttonsWidth, buttonsHeight, buttonText, buttonsStyle);
                this.method_37063((class_364)storageButton);
                buttonY += buttonsHeight + buttonsSpacing;
            }
        }
        if (((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getDisplayOptionsButton()) {
            int optionsButtonX = (this.field_22789 - 120) / 2;
            int optionsButtonY = this.field_2800 - 20;
            class_4185 optionsButtonWidget = class_4185.method_46430((class_2561)class_2561.method_43471((String)"terrastorage.button.options"), onPress -> this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new TerrastorageOptionsScreen(this.field_22787.field_1755)))).method_46437(120, 15).method_46433(optionsButtonX, optionsButtonY).method_46431();
            optionsButtonWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"terrastorage.button.tooltip.options")));
            this.method_37063((class_364)optionsButtonWidget);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Util;getMeasuringTimeMs()J")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir, boolean bl, class_1735 slot) {
        if (button != 0 || slot == null || !slot.method_7681() || !this.field_2797.method_34255().method_7960()) {
            return;
        }
        boolean modifierIsPressed = class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)KeyBindingHelper.getBoundKeyOf((class_304)TerrastorageKeybindings.favoriteItemModifier).method_1444());
        boolean playerOwnedSlot = slot.field_7871 instanceof class_1661;
        if (modifierIsPressed && playerOwnedSlot) {
            boolean toggledValue;
            class_1799 slotStack = slot.method_7677();
            int slotId = this.field_2797 instanceof class_481.class_483 ? slot.method_34266() : slot.field_7874;
            boolean bl2 = toggledValue = !ItemFavoritingUtils.isFavorite(slotStack);
            if (ClientNetworkHandler.sendItemFavoritedPayload(slotId, toggledValue)) {
                ItemFavoritingUtils.setFavorite(slotStack, toggledValue);
            }
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void mouseClickedTail(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir, boolean bl, class_1735 slot) {
        if (slot == null || slot.field_7871.method_5439() < 27) {
            return;
        }
        if (TerrastorageKeybindings.sortInventoryBind.method_1433(button)) {
            ClientNetworkHandler.sendSortPayload(slot.field_7871 instanceof class_1661);
        }
    }

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        ScreenInteractionUtils.processSlotClick(this.field_22787, this.field_2797.method_34255(), slot, slotId, button, actionType, ci);
    }

    @Inject(method={"keyPressed"}, at={@At(value="TAIL")})
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_2787 == null || this.field_2787.field_7871.method_5439() < 27) {
            return;
        }
        if (TerrastorageKeybindings.sortInventoryBind.method_1417(keyCode, scanCode)) {
            ClientNetworkHandler.sendSortPayload(this.field_2787.field_7871 instanceof class_1661);
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void drawSlot(class_332 context, class_1735 slot, CallbackInfo ci, int i, int j, class_1799 itemStack) {
        boolean needsModifierPressed;
        if (!(slot.field_7871 instanceof class_1661) || !ItemFavoritingUtils.isFavorite(itemStack)) {
            return;
        }
        BorderVisibility borderVisibility = ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getBorderVisibility();
        if (borderVisibility == BorderVisibility.NEVER) {
            return;
        }
        boolean bl = needsModifierPressed = borderVisibility == BorderVisibility.ON_PRESS || borderVisibility == BorderVisibility.ON_PRESS_NON_HOTBAR;
        if (!needsModifierPressed || class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)KeyBindingHelper.getBoundKeyOf((class_304)TerrastorageKeybindings.favoriteItemModifier).method_1444())) {
            context.method_25290(this.favoriteBorder, i, j, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }
}

