/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.network;

import java.util.Optional;
import me.timvinci.terrastorage.config.ClientConfigManager;
import me.timvinci.terrastorage.config.ServerConfigHolder;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.network.c2s.ItemFavoritePayload;
import me.timvinci.terrastorage.network.c2s.RenamePayload;
import me.timvinci.terrastorage.network.c2s.SortPayload;
import me.timvinci.terrastorage.network.c2s.StorageActionPayload;
import me.timvinci.terrastorage.util.LocalizedTextProvider;
import me.timvinci.terrastorage.util.QuickStackMode;
import me.timvinci.terrastorage.util.StorageAction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class ClientNetworkHandler {
    private static long lastActionWorldTime = 0L;
    private static class_1937 lastWorld = null;

    public static void sendActionPayload(StorageAction action) {
        if (!ClientNetworkHandler.canSendPayload(StorageActionPayload.ID) || action != StorageAction.QUICK_STACK_TO_NEARBY && class_310.method_1551().field_1724.field_7512 == null) {
            return;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            StorageActionPayload payload = switch (action) {
                case StorageAction.QUICK_STACK -> new StorageActionPayload(Optional.of(ClientNetworkHandler.getSyncId()), action, ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection(), Optional.of(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getStorageQuickStackMode() == QuickStackMode.SMART_DEPOSIT));
                case StorageAction.QUICK_STACK_TO_NEARBY -> new StorageActionPayload(Optional.empty(), action, ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection(), Optional.of(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getNearbyQuickStackMode() == QuickStackMode.SMART_DEPOSIT));
                default -> new StorageActionPayload(Optional.of(ClientNetworkHandler.getSyncId()), action, ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection(), Optional.empty());
            };
            ClientPlayNetworking.send((class_8710)payload);
        } else {
            LocalizedTextProvider.sendCooldownMessage();
        }
    }

    public static void sendSortPayload(boolean playerInventory) {
        if (!ClientNetworkHandler.canSendPayload(SortPayload.ID) || !playerInventory && class_310.method_1551().field_1724.field_7512 == null) {
            return;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            SortPayload payload = playerInventory ? new SortPayload(Optional.empty(), ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getSortType(), Optional.of(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getHotbarProtection())) : new SortPayload(Optional.of(ClientNetworkHandler.getSyncId()), ((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getSortType(), Optional.empty());
            ClientPlayNetworking.send((class_8710)payload);
        } else {
            LocalizedTextProvider.sendCooldownMessage();
        }
    }

    public static void sendRenamePayload(String newName) {
        if (!ClientNetworkHandler.canSendPayload(RenamePayload.ID) || class_310.method_1551().field_1724.field_7512 == null) {
            return;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            ClientPlayNetworking.send((class_8710)new RenamePayload(ClientNetworkHandler.getSyncId(), newName));
        } else {
            LocalizedTextProvider.sendCooldownMessage();
        }
    }

    public static boolean sendItemFavoritedPayload(int slotId, boolean value) {
        if (!ClientNetworkHandler.canSendPayload(ItemFavoritePayload.ID)) {
            return false;
        }
        if (ClientNetworkHandler.canPerformAction()) {
            ClientPlayNetworking.send((class_8710)new ItemFavoritePayload(slotId, value));
            return true;
        }
        LocalizedTextProvider.sendCooldownMessage();
        return false;
    }

    private static boolean canSendPayload(class_8710.class_9154<?> type) {
        if (!ClientPlayNetworking.canSend(type)) {
            LocalizedTextProvider.sendUnsupportedMessage();
            return false;
        }
        return true;
    }

    private static boolean canPerformAction() {
        int actionCooldown = ServerConfigHolder.actionCooldown;
        if (actionCooldown == 0) {
            return true;
        }
        class_310 client = class_310.method_1551();
        class_638 currentWorld = client.field_1687;
        long currentWorldTime = currentWorld.method_8510();
        if (lastWorld != currentWorld) {
            lastActionWorldTime = 0L;
            lastWorld = currentWorld;
        }
        if (currentWorldTime - lastActionWorldTime >= (long)actionCooldown) {
            lastActionWorldTime = currentWorldTime;
            return true;
        }
        return false;
    }

    private static int getSyncId() {
        return class_310.method_1551().field_1724.field_7512.field_7763;
    }
}

