/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.network;

import java.util.Collection;
import me.timvinci.terrastorage.Terrastorage;
import me.timvinci.terrastorage.config.ConfigManager;
import me.timvinci.terrastorage.config.TerrastorageConfig;
import me.timvinci.terrastorage.network.s2c.BlockRenamedPayload;
import me.timvinci.terrastorage.network.s2c.ServerConfigPayload;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class NetworkHandler {
    public static void sendGlobalBlockRenamedPayload(class_3218 serverWorld, class_2338 pos, String newName) {
        Collection serverPlayersInRange = PlayerLookup.tracking((class_3218)serverWorld, (class_2338)pos);
        for (class_3222 serverPlayer : serverPlayersInRange) {
            NetworkHandler.sendBlockRenamedPayload(serverPlayer, pos, newName);
        }
    }

    public static void sendBlockRenamedPayload(class_3222 player, class_2338 pos, String newName) {
        if (ServerPlayNetworking.canSend((class_3222)player, BlockRenamedPayload.ID)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new BlockRenamedPayload(pos, newName));
        }
    }

    public static void sendGlobalServerConfigPayload(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            NetworkHandler.sendServerConfigPayload(player);
        }
    }

    public static void sendServerConfigPayload(class_3222 player) {
        if (ServerPlayNetworking.canSend((class_3222)player, ServerConfigPayload.ID)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerConfigPayload(((TerrastorageConfig)ConfigManager.getInstance().getConfig()).getActionCooldown(), Terrastorage.itemFavoritingEnabled));
        }
    }
}

