/*
 * Decompiled with CFR 0.152.
 */
package me.timvinci.terrastorage.util;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import me.timvinci.terrastorage.config.ClientConfigManager;
import me.timvinci.terrastorage.config.TerrastorageClientConfig;
import me.timvinci.terrastorage.util.QuickStackMode;
import me.timvinci.terrastorage.util.StorageAction;
import me.timvinci.terrastorage.util.TextStyler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class LocalizedTextProvider {
    public static final Map<StorageAction, class_2561> buttonTextCache = new EnumMap<StorageAction, class_2561>(StorageAction.class);
    public static final Map<StorageAction, class_7919> buttonTooltipCache = new EnumMap<StorageAction, class_7919>(StorageAction.class);

    public static void initializeButtonCaches() {
        for (StorageAction action : StorageAction.values()) {
            buttonTextCache.put(action, (class_2561)class_2561.method_43471((String)("terrastorage.button." + action.name().toLowerCase(Locale.ENGLISH))));
            if (action == StorageAction.QUICK_STACK) {
                LocalizedTextProvider.updateQuickStackTooltip(((TerrastorageClientConfig)ClientConfigManager.getInstance().getConfig()).getStorageQuickStackMode());
                continue;
            }
            buttonTooltipCache.put(action, class_7919.method_47407((class_2561)class_2561.method_43471((String)("terrastorage.button.tooltip." + action.name().toLowerCase(Locale.ENGLISH)))));
        }
    }

    public static void updateQuickStackTooltip(QuickStackMode quickStackMode) {
        String translationKey = "terrastorage.button.tooltip.quick_stack." + quickStackMode.name().toLowerCase(Locale.ENGLISH);
        buttonTooltipCache.put(StorageAction.QUICK_STACK, class_7919.method_47407((class_2561)class_2561.method_43471((String)translationKey)));
    }

    public static class_2561 getBooleanOptionText(String propertyKey, boolean currentValue) {
        return class_2561.method_43471((String)("terrastorage.option." + propertyKey)).method_27693(": ").method_10852((class_2561)TextStyler.styleBooleanValue(currentValue));
    }

    public static <T extends Enum<T>> class_2561 getEnumOptionText(String propertyKey, T currentValue) {
        return class_2561.method_43471((String)("terrastorage.option." + propertyKey)).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)("terrastorage.option." + propertyKey + "." + currentValue.name().toLowerCase(Locale.ENGLISH))));
    }

    public static void sendUnsupportedMessage() {
        class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"terrastorage.message.unsupported_payload"));
    }

    public static void sendCooldownMessage() {
        class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"terrastorage.message.payload_cooldown"));
    }
}

