/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.tag.known;

import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTag;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;

public abstract class ActionKnownTagModify<T>
extends ActionKnownTag<T> {
    private final List<T> values;

    public ActionKnownTagModify(KnownTag<T> mcTag, List<T> values) {
        super(mcTag);
        this.values = values;
    }

    protected List<class_6880<T>> holderValues() {
        return Lists.transform(this.values(), input -> this.makeHolder(Either.left((Object)input)));
    }

    public List<T> values() {
        return this.values;
    }

    @Override
    public boolean validate(Logger logger) {
        if (this.values() == null) {
            logger.error("Tag entries cannot be null!", (Throwable)new NullPointerException("Tag entries cannot be null!"));
            return false;
        }
        if (this.values().isEmpty()) {
            logger.error("Tag entries cannot be empty!", (Throwable)new IndexOutOfBoundsException("Tag entries cannot be empty!"));
            return false;
        }
        return super.validate(logger);
    }

    public String describeValues() {
        return this.values().stream().map(it -> Services.REGISTRY.key((class_5321)GenericUtil.uncheck(((KnownTagManager)this.manager()).resourceKey()), it).map(class_2960::toString).orElseGet(() -> Objects.toString(it))).collect(Collectors.joining(", ", "[", "]"));
    }
}

