/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ByteArrayData")
@ZenRegister
@Document(value="vanilla/api/data/ByteArrayData")
public class ByteArrayData
implements IData {
    private final class_2479 internal;

    public ByteArrayData(class_2479 internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ByteArrayData(byte[] internal) {
        this.internal = new class_2479(internal);
    }

    @Override
    public void put(String index, IData value) {
        try {
            this.getInternal().method_10535(Integer.parseInt(index), (class_2520)class_2481.method_23233((byte)value.asByte()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Provided index: '%s' is not an Integer!".formatted(index));
        }
    }

    @Override
    public IData getAt(int index) {
        return TagToDataConverter.convert((class_2520)this.getInternal().method_10523(index));
    }

    @Override
    public void remove(int index) {
        this.getInternal().method_17804(index);
    }

    @Override
    public boolean contains(IData other) {
        if (other.isListable()) {
            List<IData> dataValues = other.asList();
            return dataValues != null && this.containsList(dataValues);
        }
        return this.getInternal().contains((Object)class_2481.method_23233((byte)other.asByte()));
    }

    @Override
    public int compareTo(@NotNull IData other) {
        return Arrays.compare(this.asByteArray(), other.asByteArray());
    }

    @Override
    public boolean equalTo(IData other) {
        return Arrays.equals(this.asByteArray(), other.asByteArray());
    }

    @Override
    public List<IData> asList() {
        return Lists.transform((List)this.getInternal(), ByteData::new);
    }

    @Override
    public boolean isListable() {
        return true;
    }

    @Override
    public byte[] asByteArray() {
        return this.getInternal().method_10521();
    }

    @Override
    public int[] asIntArray() {
        byte[] bytes = this.asByteArray();
        int[] ints = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ints[i] = bytes[i];
        }
        return ints;
    }

    @Override
    public long[] asLongArray() {
        byte[] bytes = this.asByteArray();
        long[] longs = new long[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            longs[i] = bytes[i];
        }
        return longs;
    }

    @Override
    public int length() {
        return this.getInternal().size();
    }

    @Override
    @NotNull
    public Iterator<IData> iterator() {
        return this.asList().iterator();
    }

    public class_2479 getInternal() {
        return this.internal;
    }

    @Override
    public ByteArrayData copy() {
        return new ByteArrayData(this.getInternal());
    }

    @Override
    public ByteArrayData copyInternal() {
        return new ByteArrayData((class_2479)this.getInternal().method_10707());
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitByteArray(this);
    }

    @Override
    public IData.Type getType() {
        return IData.Type.BYTE_ARRAY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayData iData = (ByteArrayData)o;
        return Objects.equals(this.getInternal(), iData.getInternal());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal());
    }

    public String toString() {
        return this.getAsString();
    }
}

