/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.event.bus;

import com.blamejared.crafttweaker.api.event.Phase;
import com.blamejared.crafttweaker.api.event.bus.IEventBus;
import com.blamejared.crafttweaker.api.event.bus.IFabricPhaseMapper;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2960;

final class OneToOnePhaseMapper
implements IFabricPhaseMapper {
    private final Map<class_2960, Phase> phaseMappings;

    private OneToOnePhaseMapper(Map<class_2960, Phase> phaseMappings) {
        this.phaseMappings = Collections.unmodifiableMap(phaseMappings);
    }

    @SafeVarargs
    static OneToOnePhaseMapper of(Map.Entry<class_2960, Phase> ... phases) {
        Objects.requireNonNull(phases, "phases");
        Map<class_2960, Phase> phaseMappings = IntStream.range(0, phases.length).mapToObj(it -> Objects.requireNonNull(phases[it], () -> "phases[" + it + "]")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!phaseMappings.containsKey(Event.DEFAULT_PHASE)) {
            throw new NoSuchElementException("Missing mapping for '" + String.valueOf(Event.DEFAULT_PHASE) + "', but it is required");
        }
        return new OneToOnePhaseMapper(phaseMappings);
    }

    @Override
    public <E> void prepareEvent(Event<E> event) {
    }

    @Override
    public <W> void dispatch(IEventBus<W> bus, W event, class_2960 fabricPhase) {
        Phase phase = this.phaseMappings.get(fabricPhase);
        assert (phase != null);
        bus.post(phase, event);
    }

    @Override
    public Set<class_2960> targetPhases() {
        return this.phaseMappings.keySet();
    }
}

