/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.condition;

import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.google.common.base.Predicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public final class IngredientConditions
implements Predicate<IItemStack> {
    public static final Codec<IngredientConditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IIngredientCondition.CODEC.listOf().fieldOf("conditions").forGetter(IngredientConditions::conditions)).apply((Applicative)instance, IngredientConditions::new));
    public static final class_9139<class_9129, IngredientConditions> STREAM_CODEC = class_9139.method_56434((class_9139)IIngredientCondition.STREAM_CODEC.method_56433(class_9135.method_56363()), IngredientConditions::conditions, IngredientConditions::new);
    public static IngredientConditions EMPTY = new IngredientConditions();
    private final List<IIngredientCondition> conditions;
    private final List<IIngredientCondition> conditionsView;

    public IngredientConditions() {
        this(new ArrayList<IIngredientCondition>());
    }

    public IngredientConditions(List<IIngredientCondition> conditions) {
        this.conditions = conditions;
        this.conditionsView = Collections.unmodifiableList(this.conditions);
    }

    public IngredientConditions copy() {
        return new IngredientConditions(new ArrayList<IIngredientCondition>(this.conditions));
    }

    public boolean isEmpty() {
        return this == EMPTY || this.conditions().isEmpty();
    }

    @Override
    public boolean test(IItemStack stack) {
        return this.conditions.stream().allMatch(iIngredientCondition -> iIngredientCondition.matches(stack));
    }

    public Predicate<class_9331<?>> componentFilter() {
        return this.conditions().stream().map(IIngredientCondition::componentFilter).reduce((Predicate)Predicates.alwaysTrue(), Predicate::and);
    }

    public String getCommandString(String base) {
        return this.conditions().stream().map(iIngredientTransformer -> iIngredientTransformer.getCommandString(base)).collect(Collectors.joining());
    }

    public void add(IIngredientCondition transformer) {
        if (this == EMPTY) {
            throw new UnsupportedOperationException("Unable to add '" + String.valueOf(transformer) + "' to an empty conditions!");
        }
        this.conditions.add(transformer);
    }

    public List<IIngredientCondition> conditions() {
        return this.conditionsView;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngredientConditions that = (IngredientConditions)o;
        return Objects.equals(this.conditions, that.conditions) && Objects.equals(this.conditionsView, that.conditionsView);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.conditionsView);
    }
}

