/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.component.ComponentAccess;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.IngredientConditions;
import com.blamejared.crafttweaker.api.ingredient.transformer.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transformer.IngredientTransformers;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientIItemStack;
import com.blamejared.crafttweaker.api.item.IItemStackConstants;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8173;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9766;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/item/IItemStack")
public interface IItemStack
extends IIngredient,
IIngredientWithAmount,
class_9322,
ComponentAccess<IItemStack> {
    public static final class_2960 INGREDIENT_ID;
    public static final Codec<IItemStack> CODEC;
    public static final class_9139<class_9129, IItemStack> STREAM_CODEC;
    @ZenCodeType.Field
    public static final String CRAFTTWEAKER_DATA_KEY = "CraftTweakerData";
    @ZenCodeType.Field
    public static final class_2960 BASE_ATTACK_DAMAGE_ID;
    @ZenCodeType.Field
    public static final class_2960 BASE_ATTACK_SPEED_ID;

    public static IItemStack empty() {
        return IItemStackConstants.EMPTY_STACK.get();
    }

    public static IItemStack of(class_1935 item) {
        return IItemStack.of(new class_1799(item));
    }

    public static IItemStack of(class_1799 stack) {
        return Services.PLATFORM.createItemStack(stack, IngredientConditions.EMPTY, IngredientTransformers.EMPTY);
    }

    public static IItemStack of(class_1799 stack, IngredientConditions conditions, IngredientTransformers transformers) {
        return Services.PLATFORM.createItemStack(stack, conditions, transformers);
    }

    public static IItemStack of(class_1799 stack, boolean mutable) {
        return mutable ? IItemStack.ofMutable(stack) : IItemStack.of(stack);
    }

    public static IItemStack ofMutable(class_1799 stack) {
        return Services.PLATFORM.createItemStackMutable(stack, IngredientConditions.EMPTY, IngredientTransformers.EMPTY);
    }

    public static IItemStack ofMutable(class_1799 stack, IngredientConditions conditions, IngredientTransformers transformers) {
        return Services.PLATFORM.createItemStackMutable(stack, conditions, transformers);
    }

    public static IItemStack of(class_1799 stack, boolean mutable, IngredientConditions conditions, IngredientTransformers transformers) {
        return mutable ? IItemStack.ofMutable(stack, conditions, transformers) : IItemStack.of(stack, conditions, transformers);
    }

    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public class_2960 getRegistryName() {
        return class_7923.field_41178.method_10221((Object)this.getInternal().method_7909());
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        return this.getRegistryName().method_12836();
    }

    @Override
    default public boolean isEmpty() {
        return this.getInternal().method_7960();
    }

    @ZenCodeType.Getter(value="prototype")
    default public class_9323 getPrototype() {
        return this.getInternal().method_58658();
    }

    @ZenCodeType.Getter(value="componentsPatch")
    default public class_9326 getComponentsPatch() {
        return this.getInternal().method_57380();
    }

    @ZenCodeType.Method
    default public <T> IItemStack with(class_9331<T> type, @ZenCodeType.Nullable T value) {
        return this.modify(itemStack -> itemStack.method_57379(type, value));
    }

    @ZenCodeType.Method
    default public <T> IItemStack without(class_9331<T> type) {
        return this.remove(type);
    }

    @ZenCodeType.Method
    default public IItemStack withJsonComponent(class_9331 type, @ZenCodeType.Nullable IData value) {
        return this.modify(itemStack -> {
            if (value == null) {
                itemStack.method_57381(type);
            } else {
                Codec codec = type.method_57876();
                DataResult decode = codec.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
                itemStack.method_57379(type, ((Pair)decode.getOrThrow()).getFirst());
            }
        });
    }

    @ZenCodeType.Method
    default public IItemStack withJsonComponents(IData value) {
        return this.modify(itemStack -> {
            DataResult decoded = class_9326.field_49589.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
            Pair pair = (Pair)decoded.getOrThrow();
            itemStack.method_57366((class_9326)pair.getFirst());
        });
    }

    @ZenCodeType.Method
    default public <T, U> IItemStack update(class_9331<T> type, T defaultValue, U data, BiFunction<T, U, T> operator) {
        return this.modify(itemStack -> itemStack.method_57367(type, defaultValue, data, operator));
    }

    @ZenCodeType.Method
    default public <T> IItemStack update(class_9331<T> type, T defaultValue, UnaryOperator<T> operator) {
        return this.modify(itemStack -> itemStack.method_57368(type, defaultValue, operator));
    }

    @ZenCodeType.Method
    default public <T> IItemStack remove(class_9331<T> type) {
        return this.modify(itemStack -> itemStack.method_57381(type));
    }

    @ZenCodeType.Method
    default public IItemStack applyComponents(class_9323 map) {
        return this.modify(itemStack -> itemStack.method_57365(map));
    }

    @ZenCodeType.Method
    default public IItemStack applyComponents(class_9326 patch) {
        return this.modify(itemStack -> itemStack.method_57366(patch));
    }

    @ZenCodeType.Method
    default public IItemStack applyComponentsAndValidate(class_9326 patch) {
        return this.modify(itemStack -> itemStack.method_59692(patch));
    }

    @ZenCodeType.Getter(value="displayName")
    default public class_2561 getDisplayName() {
        return this.getInternal().method_7954();
    }

    @ZenCodeType.Getter(value="hoverName")
    default public class_2561 getHoverName() {
        return this.getInternal().method_7964();
    }

    @ZenCodeType.Getter(value="hasFoil")
    default public boolean hasFoil() {
        return this.getInternal().method_7958();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().method_7923();
    }

    @Override
    @ZenCodeType.Getter(value="amount")
    default public int amount() {
        return this.getInternal().method_7947();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IItemStack withAmount(int amount) {
        return this.modify(itemStack -> itemStack.method_7939(amount));
    }

    @ZenCodeType.Method
    default public IItemStack grow(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withAmount(this.amount() + amount);
    }

    @ZenCodeType.Method
    default public IItemStack shrink(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withAmount(this.amount() - amount);
    }

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().method_7946();
    }

    @ZenCodeType.Method
    default public Map<class_1320, List<class_1322>> getAttributes(class_1304 slotType) {
        HashMap<class_1320, List<class_1322>> ret = new HashMap<class_1320, List<class_1322>>();
        this.getInternal().method_57354(slotType, (attributeHolder, attributeModifier) -> ret.computeIfAbsent((class_1320)attributeHolder.comp_349(), attribute -> new ArrayList()).add(attributeModifier));
        return ret;
    }

    @ZenCodeType.Getter(value="damageableItem")
    default public boolean isDamageableItem() {
        return this.getInternal().method_7963();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().method_7986();
    }

    @Override
    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().method_7936();
    }

    @ZenCodeType.Getter(value="descriptionId")
    default public String getDescriptionId() {
        return this.getInternal().method_7922();
    }

    @Override
    default public boolean matches(IItemStack stack) {
        return ItemStackUtil.areStacksTheSame(this.getInternal(), stack.getInternal(), this.conditions()) && this.conditions().test(stack);
    }

    @Override
    default public String getCommandString() {
        return ItemStackUtil.getCommandString(this.getInternal(), this.isMutable());
    }

    @ZenCodeType.Method
    default public int getUseDuration(class_1309 entity) {
        return this.getInternal().method_7935(entity);
    }

    @ZenCodeType.Getter(value="useOnRelease")
    default public boolean useOnRelease() {
        return this.getInternal().method_7967();
    }

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return Services.EVENT.getBurnTime(this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potPatternId")
    default public @ZenCodeType.Nullable class_5321<class_9766> getPotPatternId() {
        return class_8173.method_49206((class_1792)this.getInternal().method_7909());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potPattern")
    default public @ZenCodeType.Nullable class_9766 getPotPattern() {
        return (class_9766)class_7923.field_42940.method_29107(this.getPotPatternId());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public Percentaged<IItemStack> percent(double percentage) {
        return new Percentaged<IItemStack>(this, percentage / 100.0, iItemStack -> iItemStack.getCommandString() + " % " + percentage);
    }

    @ZenCodeType.Caster(implicit=true)
    default public Percentaged<IItemStack> asWeightedItemStack() {
        return this.percent(100.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="definition")
    @ZenCodeType.Caster(implicit=true)
    default public class_1792 getDefinition() {
        return this.getInternal().method_7909();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public class_1935 asItemLike() {
        return this.getInternal().method_7909();
    }

    @ZenCodeType.Method
    public IItemStack asMutable();

    @ZenCodeType.Method
    public IItemStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isMutable")
    default public boolean isMutable() {
        return !this.isImmutable();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public class_1799 getInternal();

    @Override
    default public class_1856 asVanillaIngredient() {
        if (this.getInternal().method_7960()) {
            return class_1856.field_9017;
        }
        return IngredientIItemStack.ingredient(this);
    }

    @ZenCodeType.Method
    default public class_1799 getImmutableInternal() {
        return this.getInternal().method_7972();
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        return this;
    }

    @Override
    default public IItemStack ingredient() {
        return this;
    }

    @Override
    default public IData asIData() {
        IData data = IIngredient.super.asIData();
        if (!1.$assertionsDisabled && !(data instanceof MapData)) {
            throw new AssertionError();
        }
        data.put("count", new IntData(this.amount()));
        return data;
    }

    @Override
    default public IIngredient transform(IIngredientTransformer transformer) {
        return this.modifyThis(iItemStack -> iItemStack.transformers().add(transformer));
    }

    @Override
    default public IIngredient condition(IIngredientCondition condition) {
        return this.modifyThis(iItemStack -> iItemStack.conditions().add(condition));
    }

    public IItemStack modify(Consumer<class_1799> var1);

    public IItemStack modifyThis(Consumer<IItemStack> var1);

    @NotNull
    default public class_9323 method_57353() {
        return this.getInternal().method_57353();
    }

    default public <T> T method_57824(@NotNull class_9331<? extends T> type) {
        return (T)this.getInternal().method_57824(type);
    }

    @NotNull
    default public <T> T method_57825(@NotNull class_9331<? extends T> type, @NotNull T value) {
        return (T)this.getInternal().method_57825(type, value);
    }

    default public boolean method_57826(@NotNull class_9331<?> type) {
        return this.getInternal().method_57826(type);
    }

    @Override
    default public <U> IItemStack _without(class_9331<U> componentType) {
        return this.without(componentType);
    }

    @Override
    default public <U> IItemStack _with(class_9331<U> componentType, @Nullable U value) {
        return this.with(componentType, value);
    }

    @Override
    default public <U> U _get(class_9331<? extends U> componentType) {
        return this.method_57824(componentType);
    }

    @Override
    default public <U> boolean _has(class_9331<U> componentType) {
        return this.method_57826(componentType);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        INGREDIENT_ID = CraftTweakerConstants.rl("iitemstack");
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").forGetter(IItemStack::getInternal), (App)Codec.BOOL.fieldOf("mutable").forGetter(IItemStack::isMutable), (App)IngredientConditions.CODEC.optionalFieldOf("conditions", (Object)IngredientConditions.EMPTY).forGetter(IIngredient::conditions), (App)IngredientTransformers.CODEC.optionalFieldOf("transformers", (Object)IngredientTransformers.EMPTY).forGetter(IIngredient::transformers)).apply((Applicative)instance, IItemStack::of));
        STREAM_CODEC = class_9139.method_56905((class_9139)class_1799.field_48349, IItemStack::getInternal, (class_9139)class_9135.field_48547, IItemStack::isMutable, IngredientConditions.STREAM_CODEC, IIngredient::conditions, IngredientTransformers.STREAM_CODEC, IIngredient::transformers, IItemStack::of);
        BASE_ATTACK_DAMAGE_ID = class_1792.field_8006;
        BASE_ATTACK_SPEED_ID = class_1792.field_8001;
    }
}

