/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveAllGenericRecipes;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipe;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByModId;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByName;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByOutput;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByRegex;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.NameUtil;
import com.blamejared.crafttweaker.api.zencode.util.PositionUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_151;
import net.minecraft.class_156;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.GenericRecipesManager")
@Document(value="vanilla/api/recipe/manager/GenericRecipesManager")
public class GenericRecipesManager {
    @ZenCodeGlobals.Global(value="recipes")
    public static final GenericRecipesManager INSTANCE = new GenericRecipesManager();
    private static final Set<String> FORBIDDEN_MANAGERS = Set.of(CraftTweakerConstants.rl("scripts").toString());

    private GenericRecipesManager() {
    }

    @ZenCodeType.Method
    public void addJsonRecipe(String name, MapData data) {
        String fixedName = (String)class_156.method_656(() -> {
            CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
            return NameUtil.fixing(name, (fixed, mistakes) -> CommonLoggers.api().warn("{}Invalid recipe name '{}', mistakes:\n{}\nNew recipe name: {}", position == CodePosition.UNKNOWN ? "" : String.valueOf(position) + ": ", (Object)name, (Object)String.join((CharSequence)"\n", mistakes), fixed));
        });
        IData requestedSerializer = data.getAt("type");
        if (requestedSerializer == null) {
            throw new IllegalArgumentException("Serializer type missing!");
        }
        if (FORBIDDEN_MANAGERS.contains(requestedSerializer.getAsString().toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException("Cannot add a recipe to the recipe type " + requestedSerializer.asString() + "!");
        }
        class_2960 serializerKey = (class_2960)class_156.method_656(() -> {
            try {
                return class_2960.method_60654((String)requestedSerializer.getAsString());
            }
            catch (ClassCastException | IllegalStateException | class_151 ex) {
                throw new IllegalArgumentException("Expected 'type' field to be a valid resource location", ex);
            }
        });
        class_1865 serializer = (class_1865)class_7923.field_41189.method_17966(serializerKey).orElseThrow(() -> new IllegalArgumentException("Recipe Serializer '%s' does not exist.".formatted(requestedSerializer)));
        class_2960 recipeName = CraftTweakerConstants.rl(fixedName);
        class_1860 recipe = (class_1860)serializer.method_53736().codec().parse(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)data).getOrThrow(IllegalArgumentException::new);
        IRecipeManager<class_1860<?>> manager = RecipeTypeBracketHandler.getOrDefault(recipe.method_17716());
        class_8786 holder = new class_8786(recipeName, recipe);
        CraftTweakerAPI.apply(new ActionAddRecipe(manager, (class_8786)GenericUtil.uncheck(holder)));
    }

    @ZenCodeType.Method
    public class_8786<class_1860<class_9695>> getRecipeByName(String name) {
        class_8786<class_1860<class_9695>> recipe = this.getRecipeMap().get(class_2960.method_60654((String)name));
        if (recipe == null) {
            throw new IllegalArgumentException("No recipe found with name: \"" + name + "\"");
        }
        return recipe;
    }

    @ZenCodeType.Method
    public List<class_8786<class_1860<class_9695>>> getRecipesByOutput(IIngredient output) {
        return this.getAllRecipes().stream().filter(recipe -> output.matches(IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1860)recipe.comp_1933()).method_8110(arg_0))))).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    public List<class_8786<class_1860<class_9695>>> getRecipesMatching(Predicate<class_8786<class_1860<class_9695>>> predicate) {
        return this.getAllRecipes().stream().filter(predicate).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allRecipes")
    public List<class_8786<class_1860<class_9695>>> getAllRecipes() {
        return (List)GenericUtil.uncheck(this.getAllRecipesRaw());
    }

    public List<class_8786<?>> getAllRecipesRaw() {
        return new ArrayList(this.getRecipeMap().values());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    public Map<class_2960, class_8786<class_1860<class_9695>>> getRecipeMap() {
        return (Map)GenericUtil.uncheck(CraftTweakerAPI.getAccessibleElementsProvider().accessibleRecipeManager().crafttweaker$getByName());
    }

    @ZenCodeType.Method
    public void remove(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByOutput(output));
    }

    @ZenCodeType.Method
    public void removeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipe(holder -> holder.comp_1933().method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(input.getInternal()))));
    }

    @ZenCodeType.Method
    public void removeByName(String ... names) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByName((class_2960[])Arrays.stream(names).map(class_2960::method_60654).toArray(class_2960[]::new)));
    }

    @ZenCodeType.Method
    public void removeByModid(String modId) {
        this.removeByModid(modId, null);
    }

    @ZenCodeType.Method
    public void removeByModid(String modId, Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByModId(modId, exclude));
    }

    @ZenCodeType.Method
    public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByRegex(regex));
    }

    @ZenCodeType.Method
    public void removeMatching(Predicate<class_8786<class_1860<class_9695>>> predicate) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipe(predicate));
    }

    @ZenCodeType.Method
    public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAllGenericRecipes());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allManagers")
    public List<IRecipeManager<?>> getAllManagers() {
        return new ArrayList(RecipeTypeBracketHandler.getManagerInstances());
    }
}

