/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.mod.PlatformMod;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import net.minecraft.class_8144;
import org.apache.logging.log4j.Logger;

final class CraftTweakerModList {
    private final SortedSet<DiscoveredMod> addedMods = new TreeSet<DiscoveredMod>(Comparator.comparing(DiscoveredMod::id));

    CraftTweakerModList() {
    }

    void add(PlatformMod info) {
        this.addedMods.add(this.toDiscoveredMod(info));
    }

    void printToLog() {
        Logger logger = CraftTweakerCommon.logger();
        logger.info("The following mods have explicit CraftTweaker support, provided through the CraftTweaker compatibility plugin:");
        Collections2.transform(this.addedMods, this::formatInfo).forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private DiscoveredMod toDiscoveredMod(PlatformMod info) {
        return new DiscoveredMod(info.id(), info.version(), this.discoverSupports(info));
    }

    private String[] discoverSupports(PlatformMod info) {
        String[] stringArray;
        block8: {
            Path supportFiles = info.file("/META-INF/crafttweaker/supports.list");
            Stream<String> lines = Files.lines(supportFiles);
            try {
                stringArray = (String[])lines.toArray(String[]::new);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            lines.close();
        }
        return stringArray;
    }

    private String formatInfo(DiscoveredMod info) {
        return "- '%s' version '%s'%s".formatted(info.id(), info.version(), class_8144.method_49079((Object)info.namedSupports(), it -> ", supporting mods " + String.join((CharSequence)", ", it), () -> ""));
    }

    private record DiscoveredMod(String id, String version, String[] namedSupports) {
    }
}

