/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.TaggableElementManagerFactory;
import com.blamejared.crafttweaker.api.plugin.ITaggableElementRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.manager.TagManagerFactory;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TaggableElement;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

final class TaggableElementsRegistrationManager {
    TaggableElementsRegistrationManager() {
    }

    void attemptRegistration(Class<?> clazz, ITaggableElementRegistrationHandler handler) {
        if (clazz.isAnnotationPresent(NativeTypeRegistration.class)) {
            this.tryNativeRegistration(clazz, handler);
        } else {
            this.tryClassRegistration(clazz, handler);
        }
    }

    private void tryClassRegistration(Class<?> clazz, ITaggableElementRegistrationHandler handler) {
        if (clazz.isAnnotationPresent(TaggableElement.class)) {
            this.tryElementRegistration(clazz, clazz.getAnnotation(TaggableElement.class), handler);
        }
        if (clazz.isAnnotationPresent(TaggableElementManagerFactory.class)) {
            if (!TagManagerFactory.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Provided manager factory class: '" + String.valueOf(clazz) + "' is not an instance of TagManagerFactory!");
            }
            this.tryManagerRegistration(clazz, clazz.getAnnotation(TaggableElementManagerFactory.class), handler);
        }
    }

    private void tryNativeRegistration(Class<?> clazz, ITaggableElementRegistrationHandler handler) {
        if (!clazz.isAnnotationPresent(TaggableElement.class)) {
            return;
        }
        NativeTypeRegistration ntr = clazz.getAnnotation(NativeTypeRegistration.class);
        Class<?> nativeType = ntr.value();
        this.tryElementRegistration(nativeType, clazz.getAnnotation(TaggableElement.class), handler);
    }

    private void tryElementRegistration(Class<?> clazz, TaggableElement data, ITaggableElementRegistrationHandler handler) {
        try {
            class_2960 id = class_2960.method_60654((String)data.value());
            class_5321 registryKey = class_5321.method_29180((class_2960)id);
            handler.registerTaggableElement(registryKey, (Class)GenericUtil.uncheck(clazz));
        }
        catch (class_151 e) {
            throw new IllegalArgumentException("Provided resource location '" + data.value() + "' for taggable element " + clazz.getName() + " is invalid", e);
        }
    }

    private void tryManagerRegistration(Class<?> clazz, TaggableElementManagerFactory data, ITaggableElementRegistrationHandler handler) {
        try {
            class_2960 id = class_2960.method_60654((String)data.value());
            class_5321 registryKey = class_5321.method_29180((class_2960)id);
            handler.registerManager((class_5321)GenericUtil.uncheck(registryKey), (TagManagerFactory)InstantiationUtil.getOrCreateInstance(clazz));
        }
        catch (class_151 e) {
            throw new IllegalArgumentException("Provided resource location '" + data.value() + "' for taggable element " + clazz.getName() + " is invalid", e);
        }
    }
}

