/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.recipe;

import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.impl.registry.recipe.DefaultRecipeHandler;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1860;

public final class RecipeHandlerRegistry
implements IRecipeHandlerRegistry {
    private final Map<Class<? extends class_1860<?>>, IRecipeHandler<?>> recipeHandlers = new HashMap();

    public <T extends class_1860<?>> void register(Class<? extends T> clazz, IRecipeHandler<T> handler) {
        this.recipeHandlers.put(clazz, handler);
    }

    @Override
    public <T extends class_1860<?>> IRecipeHandler<T> getRecipeHandlerFor(T recipe) {
        return this.getRecipeHandlerFor(recipe.getClass());
    }

    @Override
    public <T extends class_1860<?>> IRecipeHandler<T> getRecipeHandlerFor(Class<T> recipeClass) {
        return this.getRecipeHandlerForClass(recipeClass).orElse(DefaultRecipeHandler.INSTANCE);
    }

    private Optional<IRecipeHandler<?>> getRecipeHandlerForClass(Class<?> recipeClass) {
        ArrayDeque classes = new ArrayDeque();
        classes.offer(recipeClass);
        while (!classes.isEmpty()) {
            Class target = (Class)classes.poll();
            if (target == class_1860.class) continue;
            IRecipeHandler<?> attempt = this.recipeHandlers.get(target);
            if (attempt != null) {
                return Optional.of(attempt);
            }
            if (target.getSuperclass() != null) {
                classes.offer(target.getSuperclass());
            }
            Arrays.stream(target.getInterfaces()).forEach(classes::offer);
        }
        return Optional.empty();
    }
}

