/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.block;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.block.ActionSetBlockProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.mixin.common.access.block.AccessBlockStateBase;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/BlockState")
@NativeTypeRegistration(value=class_2680.class, zenCodeName="crafttweaker.api.block.BlockState")
public class ExpandBlockState {
    private static final BiPredicate<class_2680, class_2680> PROPERTY_EQUALS = (ts, os) -> ts.method_11656().entrySet().stream().allMatch(entry -> ((Comparable)entry.getValue()).equals(os.method_11654((class_2769)entry.getKey())));

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="soundType")
    public static class_2498 getSoundType(class_2680 internal) {
        return internal.method_26231();
    }

    @ZenCodeType.Method
    public static class_2680 rotate(class_2680 internal, class_2470 rotation) {
        return internal.method_26186(rotation);
    }

    @ZenCodeType.Getter(value="block")
    @ZenCodeType.Caster(implicit=true)
    public static class_2248 getBlock(class_2680 internal) {
        return internal.method_26204();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="lightEmission")
    public static int getLightEmission(class_2680 internal) {
        return internal.method_26213();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSignalSource")
    public static boolean isSignalSource(class_2680 internal) {
        return internal.method_26219();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canOcclude")
    public static boolean canOcclude(class_2680 internal) {
        return internal.method_26225();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isRandomlyTicking")
    public static boolean isRandomlyTicking(class_2680 internal) {
        return internal.method_26229();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hasBlockEntity")
    public static boolean hasBlockEntity(class_2680 internal) {
        return internal.method_31709();
    }

    @ZenCodeType.Method
    public static class_2680 withProperty(class_2680 internal, String name, String value) {
        class_2769 property = internal.method_26204().method_9595().method_11663(name);
        if (property == null) {
            CommonLoggers.api().warn("Invalid property name '" + name + "'");
        } else {
            Optional propValue = property.method_11900(value);
            if (propValue.isPresent()) {
                return (class_2680)internal.method_11657(property, (Comparable)propValue.get());
            }
            CommonLoggers.api().warn("Invalid property value for name '" + name + "'");
        }
        return internal;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="propertyNames")
    public static List<String> getPropertyNames(class_2680 internal) {
        ArrayList<String> props = new ArrayList<String>();
        for (class_2769 prop : internal.method_28501()) {
            props.add(prop.method_11899());
        }
        return ImmutableList.copyOf(props);
    }

    @ZenCodeType.Method
    public static String getPropertyValue(class_2680 internal, String name) {
        class_2769 prop = internal.method_26204().method_9595().method_11663(name);
        if (prop != null) {
            return internal.method_11654(prop).toString();
        }
        CommonLoggers.api().warn("Invalid property name");
        return "";
    }

    @ZenCodeType.Method
    public static List<String> getAllowedValuesForProperty(class_2680 internal, String name) {
        class_2769 prop = internal.method_26204().method_9595().method_11663(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.method_11898().forEach(v -> values.add(v.toString()));
            return values;
        }
        CommonLoggers.api().warn("Invalid property name");
        return ImmutableList.of();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="properties")
    public static Map<String, String> getProperties(class_2680 internal) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (class_2769 key : internal.method_28501()) {
            props.put(key.method_11899(), internal.method_11654(key).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @ZenCodeType.Method
    public static boolean hasProperty(class_2680 internal, String name) {
        class_2769 prop = internal.method_26204().method_9595().method_11663(name);
        return prop != null;
    }

    @ZenCodeType.Method
    public static String asString(class_2680 internal) {
        return internal.toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="destroySpeed")
    public static float getDestroySpeed(class_2680 internal) {
        return ((AccessBlockStateBase)internal).crafttweaker$getDestroySpeed();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="destroySpeed")
    public static void setDestroySpeed(class_2680 internal, float destroySpeed) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Destroy Speed", Float.valueOf(destroySpeed), Float.valueOf(((AccessBlockStateBase)internal).crafttweaker$getDestroySpeed()), value -> ((AccessBlockStateBase)internal).crafttweaker$setDestroySpeed(value.floatValue())));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    @ZenCodeType.Caster
    public static String getCommandString(class_2680 internal) {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(ExpandBlock.getRegistryName(ExpandBlockState.getBlock(internal)));
        if (!ExpandBlockState.getProperties(internal).isEmpty()) {
            builder.append(":");
            builder.append(ExpandBlockState.getProperties(internal).entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        }
        builder.append(">");
        return builder.toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public static CTBlockIngredient asBlockIngredient(class_2680 internal) {
        return new CTBlockIngredient.BlockStateIngredient(internal);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static CTBlockIngredient asList(class_2680 internal, CTBlockIngredient other) {
        ArrayList<CTBlockIngredient> elements = new ArrayList<CTBlockIngredient>();
        elements.add(ExpandBlockState.asBlockIngredient(internal));
        elements.add(other);
        return new CTBlockIngredient.CompoundBlockIngredient(elements);
    }

    @ZenCodeType.Method
    public static boolean matches(class_2680 internal, class_2680 other) {
        return internal.method_27852(other.method_26204()) && internal.method_28501().stream().allMatch(property -> internal.method_11654(property).equals(other.method_11654(property)));
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public static boolean equals(class_2680 internal, class_2680 other) {
        return internal.method_27852(other.method_26204()) && PROPERTY_EQUALS.test(internal, other) && PROPERTY_EQUALS.test(other, internal);
    }
}

