/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.food;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_4174;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/food/FoodProperties")
@NativeTypeRegistration(value=class_4174.class, zenCodeName="crafttweaker.api.food.FoodProperties")
public class ExpandFoodProperties {
    @ZenCodeType.StaticExpansionMethod
    public static class_4174 create(int nutrition, float saturation, boolean canAlwaysEat, float eatSeconds) {
        return ExpandFoodProperties.create(nutrition, saturation, canAlwaysEat, eatSeconds, IItemStack.empty());
    }

    @ZenCodeType.StaticExpansionMethod
    public static class_4174 create(int nutrition, float saturation, boolean canAlwaysEat, float eatSeconds, IItemStack usingConvertsTo) {
        return ExpandFoodProperties.create(nutrition, saturation, canAlwaysEat, eatSeconds, usingConvertsTo, List.of());
    }

    @ZenCodeType.StaticExpansionMethod
    public static class_4174 create(int nutrition, float saturation, boolean canAlwaysEat, float eatSeconds, IItemStack usingConvertsTo, List<class_4174.class_9423> effects) {
        return new class_4174(nutrition, saturation, canAlwaysEat, eatSeconds, usingConvertsTo.isEmpty() ? Optional.empty() : Optional.of(usingConvertsTo.getInternal()), effects);
    }

    @ZenCodeType.Getter(value="nutrition")
    public static int nutrition(class_4174 internal) {
        return internal.comp_2491();
    }

    @ZenCodeType.Method
    public static class_4174 withNutrition(class_4174 internal, int nutrition) {
        return new class_4174(nutrition, internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), internal.comp_2495());
    }

    @ZenCodeType.Getter(value="saturationModifier")
    public static float saturation(class_4174 internal) {
        return internal.comp_2492();
    }

    @ZenCodeType.Method
    public static class_4174 withSaturation(class_4174 internal, float saturation) {
        return new class_4174(internal.comp_2491(), saturation, internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), internal.comp_2495());
    }

    @ZenCodeType.Getter(value="canAlwaysEat")
    public static boolean canAlwaysEat(class_4174 internal) {
        return internal.comp_2493();
    }

    @ZenCodeType.Method
    public static class_4174 withCanAlwaysEat(class_4174 internal, boolean canAlwaysEat) {
        return new class_4174(internal.comp_2491(), internal.comp_2492(), canAlwaysEat, internal.comp_2494(), internal.comp_2794(), internal.comp_2495());
    }

    @ZenCodeType.Getter(value="eatSeconds")
    public static float eatSeconds(class_4174 internal) {
        return internal.comp_2494();
    }

    @ZenCodeType.Method
    public static class_4174 withEatSeconds(class_4174 internal, int eatSeconds) {
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), (float)eatSeconds, internal.comp_2794(), internal.comp_2495());
    }

    @ZenCodeType.Getter(value="usingConvertsTo")
    public static IItemStack usingConvertsTo(class_4174 internal) {
        return internal.comp_2794().map(IItemStack::of).orElseGet(IItemStack::empty);
    }

    @ZenCodeType.Method
    public static class_4174 withUsingConvertsTo(class_4174 internal, IItemStack usingConvertsTo) {
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), usingConvertsTo.isEmpty() ? Optional.empty() : Optional.of(usingConvertsTo.getInternal()), internal.comp_2495());
    }

    @ZenCodeType.Getter(value="effects")
    public static List<class_4174.class_9423> getEffects(class_4174 internal) {
        return internal.comp_2495();
    }

    @ZenCodeType.Method
    public static class_4174 withEffect(class_4174 internal, class_1293 effect, float probability) {
        ArrayList<class_4174.class_9423> possibleEffects = new ArrayList<class_4174.class_9423>(internal.comp_2495());
        possibleEffects.add(Services.PLATFORM.createPossibleEffect(effect, probability));
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), possibleEffects);
    }

    @ZenCodeType.Method
    public static class_4174 withEffect(class_4174 internal, class_4174.class_9423 effect) {
        ArrayList<class_4174.class_9423> possibleEffects = new ArrayList<class_4174.class_9423>(internal.comp_2495());
        possibleEffects.add(effect);
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), possibleEffects);
    }

    @ZenCodeType.Method
    public static class_4174 withEffects(class_4174 internal, List<class_4174.class_9423> effects) {
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), effects);
    }

    @ZenCodeType.Method
    public static class_4174 withoutEffect(class_4174 internal, class_1291 effect) {
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), internal.comp_2495().stream().filter(possibleEffect -> possibleEffect.comp_2496().method_5579().comp_349() != effect).toList());
    }

    @ZenCodeType.Method
    public static class_4174 withoutEffect(class_4174 internal, class_4174.class_9423 effect) {
        return new class_4174(internal.comp_2491(), internal.comp_2492(), internal.comp_2493(), internal.comp_2494(), internal.comp_2794(), internal.comp_2495().stream().filter(possibleEffect -> !possibleEffect.equals((Object)effect)).toList());
    }

    @ZenRegister
    @Document(value="vanilla/api/food/FoodPropertiesPossibleEffect")
    @NativeTypeRegistration(value=class_4174.class_9423.class, zenCodeName="crafttweaker.api.food.FoodPropertiesPossibleEffect")
    public static class ExpandFoodPropertiesPossibleEffect {
        @ZenCodeType.StaticExpansionMethod
        public static class_4174.class_9423 of(class_1293 effect, float probability) {
            return Services.PLATFORM.createPossibleEffect(effect, probability);
        }

        @ZenCodeType.Getter(value="effect")
        public static class_1293 effect(class_4174.class_9423 internal) {
            return internal.comp_2496();
        }

        @ZenCodeType.Getter(value="probability")
        public static float probability(class_4174.class_9423 internal) {
            return internal.comp_2497();
        }
    }

    @ZenRegister
    @Document(value="vanilla/api/food/FoodPropertiesBuilder")
    @NativeTypeRegistration(value=class_4174.class_4175.class, zenCodeName="crafttweaker.api.food.FoodPropertiesBuilder")
    public static class ExpandFoodPropertiesBuilder {
        @ZenCodeType.StaticExpansionMethod
        public static class_4174.class_4175 of() {
            return new class_4174.class_4175();
        }

        @ZenCodeType.Method
        public static class_4174.class_4175 nutrition(class_4174.class_4175 internal, int nutrition) {
            return internal.method_19238(nutrition);
        }

        @ZenCodeType.Method
        public static class_4174.class_4175 fast(class_4174.class_4175 internal) {
            return internal.method_19241();
        }

        @ZenCodeType.Method
        public static class_4174.class_4175 effect(class_4174.class_4175 internal, class_1293 effect, float probability) {
            return internal.method_19239(effect, probability);
        }

        @ZenCodeType.Method
        public static class_4174.class_4175 saturationModifier(class_4174.class_4175 internal, float saturationModifier) {
            return internal.method_19237(saturationModifier);
        }

        @ZenCodeType.Method
        @ZenCodeType.Caster(implicit=true)
        public static class_4174 build(class_4174.class_4175 internal) {
            return internal.method_19242();
        }

        @ZenCodeType.Method
        public static class_4174.class_4175 alwaysEdible(class_4174.class_4175 internal) {
            return internal.method_19240();
        }
    }
}

