/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import java.util.Arrays;
import stdlib.Strings;

public class JavaClass
implements Comparable<JavaClass> {
    public static final JavaClass CLASS = new JavaClass("java.lang", "Class", Kind.CLASS);
    public static final JavaClass ENUM = new JavaClass("java.lang", "Enum", Kind.CLASS);
    public static final JavaClass OBJECT = new JavaClass("java.lang", "Object", Kind.CLASS);
    public static final JavaClass STRING = new JavaClass("java.lang", "String", Kind.CLASS);
    public static final JavaClass CLOSEABLE = new JavaClass("java.lang", "AutoCloseable", Kind.INTERFACE);
    public static final JavaClass MAP = new JavaClass("java.util", "Map", Kind.INTERFACE);
    public static final JavaClass HASHMAP = new JavaClass("java.util", "HashMap", Kind.CLASS);
    public static final JavaClass ITERATOR = new JavaClass("java.util", "Iterator", Kind.INTERFACE);
    public static final JavaClass ITERABLE = new JavaClass("java.lang", "Iterable", Kind.INTERFACE);
    public static final JavaClass ARRAYS = new JavaClass("java.util", "Arrays", Kind.CLASS);
    public static final JavaClass BOOLEAN = new JavaClass("java.lang", "Boolean", Kind.CLASS);
    public static final JavaClass BYTE = new JavaClass("java.lang", "Byte", Kind.CLASS);
    public static final JavaClass SHORT = new JavaClass("java.lang", "Short", Kind.CLASS);
    public static final JavaClass INTEGER = new JavaClass("java.lang", "Integer", Kind.CLASS);
    public static final JavaClass LONG = new JavaClass("java.lang", "Long", Kind.CLASS);
    public static final JavaClass FLOAT = new JavaClass("java.lang", "Float", Kind.CLASS);
    public static final JavaClass DOUBLE = new JavaClass("java.lang", "Double", Kind.CLASS);
    public static final JavaClass CHARACTER = new JavaClass("java.lang", "Character", Kind.CLASS);
    public static final JavaClass COLLECTION = new JavaClass("java.util", "Collection", Kind.INTERFACE);
    public static final JavaClass COLLECTIONS = new JavaClass("java.util", "Collections", Kind.CLASS);
    public static final JavaClass SHARED = new JavaClass("zsynthetic", "Shared", Kind.CLASS);
    public final JavaClass outer;
    public final String pkg;
    public final String fullName;
    public final String internalName;
    public final Kind kind;
    private final String[] classNameParts;
    public boolean empty = false;
    public boolean membersPrepared = false;

    private JavaClass(String pkg, String internalName, Kind kind, String[] classNameParts) {
        if (classNameParts.length > 1) {
            String[] outerParts = Arrays.copyOf(classNameParts, classNameParts.length - 1);
            this.outer = new JavaClass(pkg, internalName.substring(0, internalName.lastIndexOf(36)), kind, outerParts);
        } else {
            this.outer = null;
        }
        this.pkg = pkg;
        this.fullName = String.join((CharSequence)".", classNameParts);
        this.internalName = internalName;
        this.kind = kind;
        this.classNameParts = classNameParts;
    }

    public JavaClass(String pkg, String name, Kind kind) {
        this.pkg = pkg;
        this.classNameParts = new String[]{name};
        this.fullName = pkg + "." + name;
        this.internalName = pkg.isEmpty() ? name : pkg.replace('.', '/') + "/" + name;
        this.kind = kind;
        this.outer = this;
    }

    public JavaClass(JavaClass outer, String name, Kind kind) {
        this.pkg = outer.pkg;
        this.classNameParts = Arrays.copyOf(outer.classNameParts, outer.classNameParts.length + 1);
        this.classNameParts[outer.classNameParts.length] = name;
        this.fullName = outer.fullName + "." + name;
        this.internalName = outer.internalName + "$" + name;
        this.kind = kind;
        this.outer = outer.outer;
    }

    public static JavaClass fromInternalName(String internalName, Kind kind) {
        if (kind == Kind.ARRAY) {
            return new JavaClass("", internalName, kind, new String[0]);
        }
        int lastSlash = internalName.lastIndexOf(47);
        String pkg = lastSlash < 0 ? "" : internalName.substring(0, lastSlash);
        String className = lastSlash < 0 ? internalName : internalName.substring(lastSlash + 1);
        String[] nameParts = Strings.split(className, '$');
        return new JavaClass(pkg, internalName, kind, nameParts);
    }

    public static String getNameFromFile(String filename) {
        if (filename.indexOf(46) > 0) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    public String getName() {
        return this.classNameParts[this.classNameParts.length - 1];
    }

    public String getClassName() {
        return this.fullName.substring(this.pkg.length() + 1);
    }

    @Override
    public int compareTo(JavaClass o) {
        return this.fullName.compareTo(o.fullName);
    }

    public boolean isEnum() {
        return this.kind == Kind.ENUM;
    }

    public boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    public static enum Kind {
        CLASS,
        INTERFACE,
        ENUM,
        ARRAY;

    }
}

