/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.catheter;

import com.github.cao.awa.catheter.BooleanCatheter;
import com.github.cao.awa.catheter.ByteCatheter;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.catheter.IntCatheter;
import com.github.cao.awa.catheter.LongCatheter;
import com.github.cao.awa.catheter.action.BiDoublePredicate;
import com.github.cao.awa.catheter.action.BiDoubleToDoubleFunction;
import com.github.cao.awa.catheter.action.BooleanConsumer;
import com.github.cao.awa.catheter.action.DoubleToByteFunction;
import com.github.cao.awa.catheter.action.IntegerAndBiDoublePredicate;
import com.github.cao.awa.catheter.action.IntegerAndBiDoubleToDoubleFunction;
import com.github.cao.awa.catheter.action.IntegerAndDoubleConsumer;
import com.github.cao.awa.catheter.action.IntegerAndDoublePredicate;
import com.github.cao.awa.catheter.matrix.MatrixFlockPos;
import com.github.cao.awa.catheter.matrix.MatrixPos;
import com.github.cao.awa.catheter.pair.IntegerAndDoublePair;
import com.github.cao.awa.catheter.receptacle.BooleanReceptacle;
import com.github.cao.awa.catheter.receptacle.DoubleReceptacle;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.sinuatum.function.consumer.TriConsumer;
import com.github.cao.awa.sinuatum.function.function.QuinFunction;
import com.github.cao.awa.sinuatum.function.function.TriFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import java.util.stream.DoubleStream;

public class DoubleCatheter {
    private static final Random RANDOM = new Random();
    private double[] targets;

    public DoubleCatheter(double[] targets) {
        this.targets = targets;
    }

    public static DoubleCatheter make(double ... targets) {
        return new DoubleCatheter(targets);
    }

    public static DoubleCatheter makeCapacity(int size) {
        return new DoubleCatheter(DoubleCatheter.array(size));
    }

    public static <X> DoubleCatheter of(double[] targets) {
        return new DoubleCatheter(targets);
    }

    public static DoubleCatheter of(Collection<Double> targets) {
        if (targets == null) {
            return new DoubleCatheter(DoubleCatheter.array(0));
        }
        double[] delegate = new double[targets.size()];
        int index = 0;
        for (double target : targets) {
            delegate[index++] = target;
        }
        return new DoubleCatheter(delegate);
    }

    public DoubleCatheter each(DoubleConsumer action) {
        double[] ts;
        for (double d : ts = this.targets) {
            action.accept(d);
        }
        return this;
    }

    public DoubleCatheter each(DoubleConsumer action, Runnable poster) {
        this.each(action);
        poster.run();
        return this;
    }

    public <X> DoubleCatheter each(X initializer, BiConsumer<X, Double> action) {
        double[] ts;
        for (double d : ts = this.targets) {
            action.accept(initializer, d);
        }
        return this;
    }

    public <X> DoubleCatheter each(X initializer, BiConsumer<X, Double> action, Consumer<X> poster) {
        this.each(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public <X> DoubleCatheter overall(X initializer, TriConsumer<X, Integer, Double> action) {
        double[] ts = this.targets;
        int index = 0;
        for (double d : ts) {
            action.accept(initializer, index++, d);
        }
        return this;
    }

    public <X> DoubleCatheter overall(X initializer, TriConsumer<X, Integer, Double> action, Consumer<X> poster) {
        this.overall(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public DoubleCatheter overall(IntegerAndDoubleConsumer action) {
        double[] ts = this.targets;
        int index = 0;
        for (double d : ts) {
            action.accept(index++, d);
        }
        return this;
    }

    public DoubleCatheter overall(IntegerAndDoubleConsumer action, Runnable poster) {
        this.overall(action);
        poster.run();
        return this;
    }

    public DoubleCatheter insert(IntegerAndBiDoubleToDoubleFunction maker) {
        HashMap indexes = new HashMap();
        DoubleReceptacle lastItem = new DoubleReceptacle(0.0);
        this.overall((index, item) -> {
            indexes.put(index + indexes.size(), new IntegerAndDoublePair(index, maker.apply(index, item, lastItem.get())));
            lastItem.set(item);
        });
        double[] ts = this.targets;
        double[] newDelegate = DoubleCatheter.array(ts.length + indexes.size());
        IntegerReceptacle lastIndex = new IntegerReceptacle(0);
        IntegerReceptacle lastDest = new IntegerReceptacle(0);
        IntCatheter.of(indexes.keySet()).sort().each((int index) -> {
            if (lastIndex.get() != index) {
                int maxCopyLength = Math.min(newDelegate.length - lastDest.get() - 1, index - lastIndex.get());
                System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), maxCopyLength);
            }
            IntegerAndDoublePair item = (IntegerAndDoublePair)indexes.get(index);
            newDelegate[index] = item.doubleValue();
            lastIndex.set(item.intValue());
            lastDest.set(index + 1);
        }, () -> System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), newDelegate.length - lastDest.get()));
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter pluck(IntegerAndBiDoublePredicate maker) {
        DoubleReceptacle lastItem = new DoubleReceptacle(0.0);
        return this.overallFilter((index, item) -> {
            if (maker.test(index, item, lastItem.get())) {
                return false;
            }
            lastItem.set(item);
            return true;
        });
    }

    public DoubleCatheter discardTo(DoublePredicate predicate) {
        DoubleCatheter result = DoubleCatheter.make(new double[0]);
        this.overallFilter((index, item) -> !predicate.test(item), result::reset);
        return result;
    }

    public <X> DoubleCatheter discardTo(Predicate<X> predicate, DoubleFunction<X> converter) {
        DoubleCatheter result = DoubleCatheter.make(new double[0]);
        this.overallFilter((index, item) -> !predicate.test(converter.apply(item)), result::reset);
        return result;
    }

    public DoubleCatheter discardTo(double initializer, BiDoublePredicate predicate) {
        DoubleCatheter result = DoubleCatheter.make(new double[0]);
        this.overallFilter((index, item) -> !predicate.test(item, initializer), result::reset);
        return result;
    }

    public DoubleCatheter orDiscardTo(boolean succeed, DoublePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate);
    }

    public <X> DoubleCatheter orDiscardTo(boolean succeed, Predicate<X> predicate, DoubleFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate, converter);
    }

    public DoubleCatheter orDiscardTo(boolean succeed, double initializer, BiDoublePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(initializer, predicate);
    }

    public DoubleCatheter discard(DoublePredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item));
    }

    public <X> DoubleCatheter discard(Predicate<X> predicate, DoubleFunction<X> converter) {
        return this.overallFilter((index, item) -> !predicate.test(converter.apply(item)));
    }

    public DoubleCatheter discard(double initializer, BiDoublePredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item, initializer));
    }

    public DoubleCatheter orDiscard(boolean succeed, DoublePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate);
    }

    public <X> DoubleCatheter orDiscard(boolean succeed, Predicate<X> predicate, DoubleFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate, converter);
    }

    public DoubleCatheter orDiscard(boolean succeed, double initializer, BiDoublePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(initializer, predicate);
    }

    public DoubleCatheter filterTo(DoublePredicate predicate) {
        return this.dump().filter(predicate);
    }

    public <X> DoubleCatheter filterTo(Predicate<X> predicate, DoubleFunction<X> converter) {
        return this.dump().filter(predicate, converter);
    }

    public DoubleCatheter filterTo(double initializer, BiDoublePredicate predicate) {
        return this.dump().filter(initializer, predicate);
    }

    public DoubleCatheter orFilterTo(boolean succeed, DoublePredicate predicate) {
        return this.dump().orFilter(succeed, predicate);
    }

    public <X> DoubleCatheter orFilterTo(boolean succeed, Predicate<X> predicate, DoubleFunction<X> converter) {
        return this.dump().orFilter(succeed, predicate, converter);
    }

    public DoubleCatheter orFilterTo(boolean succeed, double initializer, BiDoublePredicate predicate) {
        return this.dump().orFilter(succeed, initializer, predicate);
    }

    public DoubleCatheter filter(DoublePredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item));
    }

    public <X> DoubleCatheter filter(Predicate<X> predicate, DoubleFunction<X> converter) {
        return this.overallFilter((index, item) -> predicate.test(converter.apply(item)));
    }

    public DoubleCatheter filter(double initializer, BiDoublePredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item, initializer));
    }

    public DoubleCatheter orFilter(boolean succeed, DoublePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate);
    }

    public <X> DoubleCatheter orFilter(boolean succeed, Predicate<X> predicate, DoubleFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate, converter);
    }

    public DoubleCatheter orFilter(boolean succeed, double initializer, BiDoublePredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(initializer, predicate);
    }

    public DoubleCatheter overallFilter(IntegerAndDoublePredicate predicate) {
        return this.overallFilter(predicate, (double[] x) -> {});
    }

    public DoubleCatheter overallFilter(IntegerAndDoublePredicate predicate, Consumer<double[]> discarding) {
        if (this.isEmpty()) {
            return this;
        }
        double[] ts = this.targets;
        int length = ts.length;
        boolean[] deleting = new boolean[length];
        int newDelegateSize = length;
        int index = 0;
        for (double target : ts) {
            if (predicate.test(index, target)) {
                ++index;
                continue;
            }
            deleting[index++] = true;
            --newDelegateSize;
        }
        double[] newDelegate = DoubleCatheter.array(newDelegateSize);
        double[] discardingDelegate = DoubleCatheter.array(length - newDelegateSize);
        int discardingDelegateIndex = 0;
        int newDelegateIndex = 0;
        index = 0;
        for (boolean isDeleting : deleting) {
            double t = ts[index++];
            if (isDeleting) {
                discardingDelegate[discardingDelegateIndex++] = t;
                continue;
            }
            newDelegate[newDelegateIndex++] = t;
        }
        discarding.accept(discardingDelegate);
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter overallFilter(double initializer, IntegerAndBiDoublePredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(index, item, initializer));
    }

    public DoubleCatheter distinct() {
        HashMap map = new HashMap();
        return this.filter(item -> {
            if (map.getOrDefault(item, false).booleanValue()) {
                return false;
            }
            map.put(item, true);
            return true;
        });
    }

    public DoubleCatheter sort() {
        Arrays.sort(this.targets);
        return this;
    }

    public DoubleCatheter sort(Comparator<Double> comparator) {
        Double[] array = new Double[this.targets.length];
        int index = 0;
        for (double target : this.targets) {
            array[index++] = target;
        }
        Arrays.sort(array, comparator);
        index = 0;
        Double[] doubleArray = array;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double target;
            target = doubleArray[i];
            this.targets[index++] = target;
        }
        return this;
    }

    public DoubleCatheter holdTill(int index) {
        if (this.isEmpty()) {
            return this;
        }
        index = Math.min(index, this.targets.length);
        double[] ts = this.targets;
        double[] newDelegate = DoubleCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter holdTill(DoublePredicate predicate) {
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        double[] ts = this.targets;
        double[] newDelegate = DoubleCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter whenFlock(double source, BiDoubleToDoubleFunction maker, DoubleConsumer consumer) {
        consumer.accept(this.flock(source, maker));
        return this;
    }

    public DoubleCatheter whenFlock(BiDoubleToDoubleFunction maker, DoubleConsumer consumer) {
        consumer.accept(this.flock(maker));
        return this;
    }

    public double flock(double source, BiDoubleToDoubleFunction maker) {
        double[] ts = this.targets;
        double result = source;
        for (double d : ts) {
            result = maker.applyAsDouble(result, d);
        }
        return result;
    }

    public double flock(BiDoubleToDoubleFunction maker) {
        double[] ts = this.targets;
        int length = ts.length;
        double result = length > 0 ? ts[0] : 0.0;
        for (int i = 1; i < length; ++i) {
            result = maker.applyAsDouble(result, ts[i]);
        }
        return result;
    }

    public <X> X alternate(X source, BiFunction<X, Double, X> maker) {
        double[] ts = this.targets;
        X result = source;
        for (double d : ts) {
            result = maker.apply(result, d);
        }
        return result;
    }

    public <X> DoubleCatheter whenAlternate(X source, BiFunction<X, Double, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public <X> DoubleCatheter whenAlternate(BiFunction<X, Double, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(null, maker));
        return this;
    }

    public boolean alternate(boolean source, BiDoublePredicate maker) {
        BooleanReceptacle result = new BooleanReceptacle(source);
        this.flock((older, newer) -> {
            result.and(maker.test(older, newer));
            return newer;
        });
        return result.get();
    }

    public DoubleCatheter whenAlternate(boolean source, BiDoublePredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public DoubleCatheter whenAlternate(BiDoublePredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(false, maker));
        return this;
    }

    public DoubleCatheter waiveTill(int index) {
        double[] newDelegate;
        if (this.isEmpty()) {
            return this;
        }
        double[] ts = this.targets;
        if (index >= ts.length) {
            newDelegate = DoubleCatheter.array(0);
        } else {
            newDelegate = DoubleCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter waiveTill(DoublePredicate predicate) {
        double[] newDelegate;
        double[] ts;
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        if (index >= (ts = this.targets).length) {
            newDelegate = DoubleCatheter.array(0);
        } else {
            newDelegate = DoubleCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter till(DoublePredicate predicate) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (predicate.test(d)) break;
        }
        return this;
    }

    public int findTill(DoublePredicate predicate) {
        double[] ts = this.targets;
        int index = 0;
        for (double d : ts) {
            if (predicate.test(d)) break;
        }
        return index;
    }

    public DoubleCatheter replace(DoubleUnaryOperator handler) {
        if (this.isEmpty()) {
            return this;
        }
        double[] ts = this.targets;
        int index = 0;
        for (double d : ts) {
            ts[index++] = handler.applyAsDouble(d);
        }
        return this;
    }

    public DoubleCatheter vary(DoubleUnaryOperator handler) {
        return this.replace(handler);
    }

    public IntCatheter vary(DoubleToIntFunction handler) {
        if (this.isEmpty()) {
            return IntCatheter.make(new int[0]);
        }
        double[] ts = this.targets;
        int[] array = new int[ts.length];
        int index = 0;
        for (double d : ts) {
            array[index++] = handler.applyAsInt(d);
        }
        return IntCatheter.of(array);
    }

    public LongCatheter vary(DoubleToLongFunction handler) {
        if (this.isEmpty()) {
            return LongCatheter.make(new long[0]);
        }
        double[] ts = this.targets;
        long[] array = new long[ts.length];
        int index = 0;
        for (double d : ts) {
            array[index++] = handler.applyAsLong(d);
        }
        return LongCatheter.of(array);
    }

    public BooleanCatheter vary(DoublePredicate handler) {
        if (this.isEmpty()) {
            return BooleanCatheter.make(new boolean[0]);
        }
        double[] ts = this.targets;
        boolean[] array = new boolean[ts.length];
        int index = 0;
        for (double d : ts) {
            array[index++] = handler.test(d);
        }
        return BooleanCatheter.of(array);
    }

    public ByteCatheter vary(DoubleToByteFunction handler) {
        if (this.isEmpty()) {
            return ByteCatheter.make(new byte[0]);
        }
        double[] ts = this.targets;
        byte[] array = new byte[ts.length];
        int index = 0;
        for (double d : ts) {
            array[index++] = handler.applyAsByte(d);
        }
        return ByteCatheter.of(array);
    }

    public <X> Catheter<X> vary(DoubleFunction<X> handler) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        double[] ts = this.targets;
        X[] array = DoubleCatheter.xArray(ts.length);
        int index = 0;
        for (double d : ts) {
            array[index++] = handler.apply(d);
        }
        return new Catheter<X>(array);
    }

    public <X> Catheter<X> vary(DoubleFunction<X> handler, IntFunction<X[]> arrayGenerator) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        double[] ts = this.targets;
        X[] array = arrayGenerator.apply(ts.length);
        int index = 0;
        for (double d : ts) {
            array[index++] = handler.apply(d);
        }
        return Catheter.of(array).arrayGenerator(arrayGenerator);
    }

    public DoubleCatheter whenAny(DoublePredicate predicate, DoubleConsumer action) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (!predicate.test(d)) continue;
            action.accept(d);
            break;
        }
        return this;
    }

    public DoubleCatheter whenAll(DoublePredicate predicate, Runnable action) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (predicate.test(d)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public DoubleCatheter whenAll(DoublePredicate predicate, DoubleConsumer action) {
        return this.whenAll(predicate, () -> this.each(action));
    }

    private DoubleCatheter whenNone(DoublePredicate predicate, Runnable action) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (!predicate.test(d)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public boolean hasAny(DoublePredicate predicate) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (!predicate.test(d)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(DoublePredicate predicate) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (predicate.test(d)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNone(DoublePredicate predicate) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (!predicate.test(d)) continue;
            return false;
        }
        return true;
    }

    public double findFirst(DoublePredicate predicate) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (!predicate.test(d)) continue;
            return d;
        }
        return 0.0;
    }

    public double findLast(DoublePredicate predicate) {
        double[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            double t;
            if (!predicate.test(t = ts[index--])) continue;
            return t;
        }
        return 0.0;
    }

    public <X> X whenFoundFirst(DoublePredicate predicate, DoubleFunction<X> function) {
        double[] ts;
        for (double d : ts = this.targets) {
            if (!predicate.test(d)) continue;
            return function.apply(d);
        }
        return null;
    }

    public <X> X whenFoundLast(DoublePredicate predicate, DoubleFunction<X> function) {
        double[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            double t;
            if (!predicate.test(t = ts[index--])) continue;
            return function.apply(t);
        }
        return null;
    }

    public DoubleCatheter any(DoubleConsumer consumer) {
        if (this.targets.length > 0) {
            double[] ls = this.targets;
            int index = RANDOM.nextInt(ls.length);
            consumer.accept(ls.length > index ? ls[index] : ls[ls.length - 1]);
        }
        return this;
    }

    public DoubleCatheter first(DoubleConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[0]);
        }
        return this;
    }

    public DoubleCatheter tail(DoubleConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[this.targets.length - 1]);
        }
        return this;
    }

    public DoubleCatheter reverse() {
        if (this.isEmpty()) {
            return this;
        }
        double[] ts = this.targets;
        int length = ts.length;
        int split = length / 2;
        for (int index = 0; index < split; ++index) {
            int swapIndex = length - index - 1;
            double temp = ts[index];
            ts[index] = ts[swapIndex];
            ts[swapIndex] = temp;
        }
        return this;
    }

    public double max(Comparator<Double> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
    }

    public double min(Comparator<Double> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
    }

    public DoubleCatheter whenMax(Comparator<Double> comparator, DoubleConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result));
        return this;
    }

    public DoubleCatheter whenMin(Comparator<Double> comparator, DoubleConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result));
        return this;
    }

    public int count() {
        return this.targets.length;
    }

    public DoubleCatheter count(AtomicInteger target) {
        target.set(this.count());
        return this;
    }

    public DoubleCatheter count(IntegerReceptacle target) {
        target.set(this.count());
        return this;
    }

    public DoubleCatheter count(Consumer<Integer> consumer) {
        consumer.accept(this.count());
        return this;
    }

    @SafeVarargs
    public final DoubleCatheter append(double ... objects) {
        double[] ts = this.targets;
        double[] newDelegate = DoubleCatheter.array(ts.length + objects.length);
        System.arraycopy(ts, 0, newDelegate, 0, ts.length);
        System.arraycopy(objects, 0, newDelegate, ts.length, objects.length);
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter append(DoubleCatheter objects) {
        return this.append(objects.array());
    }

    public DoubleCatheter repeat(int count) {
        double[] ts = this.array();
        for (int i = 0; i < count; ++i) {
            this.append(ts);
        }
        return this;
    }

    public double fetch(int index) {
        return this.targets[Math.min(index, this.targets.length - 1)];
    }

    public void fetch(int index, double item) {
        this.targets[index] = item;
    }

    public DoubleCatheter matrixEach(int width, BiConsumer<MatrixPos, Double> action) {
        return this.matrixReplace(width, (pos, item) -> {
            action.accept((MatrixPos)pos, (Double)item);
            return item;
        });
    }

    public <X> Catheter<X> matrixHomoVary(int width, DoubleCatheter input, TriFunction<MatrixPos, Double, Double, X> action) {
        if (input.count() == this.count()) {
            IntegerReceptacle index = new IntegerReceptacle(0);
            return this.matrixVary(width, (pos, item) -> {
                int indexValue = index.get();
                double inputX = input.fetch(indexValue);
                Object result = action.apply((MatrixPos)pos, (Double)item, inputX);
                index.set(indexValue + 1);
                return result;
            });
        }
        throw new IllegalArgumentException("The matrix is not homogeneous matrix");
    }

    public DoubleCatheter matrixMap(int width, int inputWidth, DoubleCatheter input, QuinFunction<MatrixFlockPos, MatrixPos, MatrixPos, Double, Double, Double> scanFlocked, TriFunction<MatrixPos, Double, Double, Double> combineFlocked) {
        int sourceHeight;
        boolean homoMatrix;
        int inputHeight = input.count() / inputWidth;
        boolean bl = homoMatrix = inputHeight == (sourceHeight = this.count() / width) && width == inputWidth;
        if (width != inputHeight && !homoMatrix) {
            throw new IllegalArgumentException("The matrix cannot be constructed because input height does not match to source width");
        }
        DoubleCatheter newMatrix = DoubleCatheter.makeCapacity(homoMatrix ? sourceHeight * width : sourceHeight * inputWidth);
        DoubleCatheter flockingCatheter = DoubleCatheter.makeCapacity(width);
        return newMatrix.matrixReplace(inputWidth, (pos, ignored) -> {
            int posX = pos.x();
            int posY = pos.y();
            int flockingIndex = 0;
            int inputY = 0;
            for (int sourceX = 0; sourceX < width; ++sourceX) {
                MatrixFlockPos flockPos = new MatrixFlockPos(posX, posY);
                MatrixPos inputPos = new MatrixPos(posX, inputY);
                MatrixPos sourcePos = new MatrixPos(sourceX, posY);
                double fetchedSource = this.fetch(posY * width + sourceX);
                double fetchedInput = input.fetch(inputY * inputWidth + posX);
                flockingCatheter.fetch(flockingIndex++, (Double)scanFlocked.apply(flockPos, sourcePos, inputPos, fetchedSource, fetchedInput));
                ++inputY;
            }
            return flockingCatheter.flock((current, next) -> (Double)combineFlocked.apply((MatrixPos)pos, current, next));
        });
    }

    public <X> Catheter<X> matrixVary(int width, double input, TriFunction<MatrixPos, Double, Double, X> action) {
        return this.matrixVary(width, (pos, item) -> action.apply((MatrixPos)pos, (Double)item, input));
    }

    public DoubleCatheter matrixReplace(int width, BiFunction<MatrixPos, Double, Double> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.replace(item -> {
            int wValue = w.get();
            int hValue = h.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return (Double)action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public <X> Catheter<X> matrixVary(int width, BiFunction<MatrixPos, Double, X> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.vary((double item) -> {
            int hValue = h.get();
            int wValue = w.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public Catheter<DoubleCatheter> matrixLines(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int sourceHeight = this.count() / width;
        Catheter<DoubleCatheter> results = Catheter.makeCapacity(sourceHeight);
        DoubleCatheter catheter = DoubleCatheter.makeCapacity(width);
        for (int y = 0; y < sourceHeight; ++y) {
            for (int x = 0; x < width; ++x) {
                double element = this.fetch(y * width + x);
                catheter.fetch(x, element);
            }
            results.fetch(y, catheter.dump());
        }
        return results;
    }

    public DoubleCatheter removeWithIndex(int index) {
        if (this.isEmpty() || index >= this.count() || index < 0) {
            return this;
        }
        double[] newDelegate = DoubleCatheter.array(this.count() - 1);
        if (index > 0) {
            System.arraycopy(this.targets, 0, newDelegate, 0, index);
        }
        System.arraycopy(this.targets, index + 1, newDelegate, index, this.count() - 1 - index);
        this.targets = newDelegate;
        return this;
    }

    public DoubleCatheter shuffle() {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public DoubleCatheter shuffle(RandomGenerator random) {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public DoubleCatheter swapShuffle(RandomGenerator random) {
        int i;
        double[] elements = this.targets;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            double fromElement = elements[swapFrom];
            double toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
        return this;
    }

    public boolean has(double target) {
        return this.hasAny(t -> t == target);
    }

    public boolean not(double target) {
        return !this.has(target);
    }

    public DoubleCatheter merge(DoubleCatheter other) {
        return this.append(other.filter(this::not));
    }

    public boolean isPresent() {
        return this.count() > 0;
    }

    public DoubleCatheter ifPresent(Consumer<DoubleCatheter> action) {
        if (this.count() > 0) {
            action.accept(this);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public DoubleCatheter ifEmpty(Consumer<DoubleCatheter> action) {
        if (this.count() == 0) {
            action.accept(this);
        }
        return this;
    }

    public DoubleCatheter dump() {
        return new DoubleCatheter(this.array());
    }

    public DoubleCatheter flat(DoubleFunction<DoubleCatheter> function) {
        if (this.isEmpty()) {
            return this;
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (double element : this.targets) {
            DoubleCatheter flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        this.targets = DoubleCatheter.array(totalSize);
        int pos = 0;
        for (DoubleCatheter flat : (DoubleCatheter[])catheter.targets) {
            System.arraycopy(flat.targets, 0, this.targets, pos, flat.targets.length);
            pos += flat.targets.length;
        }
        return this;
    }

    public <X> Catheter<X> flatTo(DoubleFunction<Catheter<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (double element : this.targets) {
            Catheter<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        return Catheter.flatting(catheter, totalSize);
    }

    public <X> Catheter<X> flatToByCollection(DoubleFunction<Collection<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (double element : this.targets) {
            Collection<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.size();
        }
        return Catheter.flattingCollection(catheter, totalSize);
    }

    public DoubleCatheter reset() {
        this.targets = DoubleCatheter.array(0);
        return this;
    }

    public DoubleCatheter reset(double[] targets) {
        this.targets = targets;
        return this;
    }

    public double[] array() {
        return (double[])this.targets.clone();
    }

    public double[] dArray() {
        return this.targets;
    }

    public DoubleStream stream() {
        return DoubleStream.of(this.array());
    }

    public List<Double> list() {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double l : this.array()) {
            list.add(l);
        }
        return list;
    }

    public Set<Double> set() {
        HashSet<Double> set = new HashSet<Double>();
        for (double l : this.array()) {
            set.add(l);
        }
        return set;
    }

    public static void main(String[] args) {
        DoubleCatheter source = DoubleCatheter.make(3.0, 3.0, 3.0, 4.0, 1.0, 1.0, 5.0, 9.0, 9.0);
        DoubleCatheter input = DoubleCatheter.make(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        source.dump().matrixHomoVary(3, input, (pos, sourceX, inputX) -> sourceX - inputX).matrixEach(3, (MatrixPos pos, T item) -> {
            System.out.println(pos);
            System.out.println(item);
        });
        System.out.println("------");
        source.matrixMap(3, 3, input, (flockPos, sourcePos, inputPos, sourceX, inputX) -> sourceX * inputX, (destPos, combine1, combine2) -> combine1 + combine2).matrixEach(3, (pos, item) -> {
            System.out.println(pos);
            System.out.println(item);
        });
    }

    private static double[] array(int size) {
        return new double[size];
    }

    private static <X> X[] xArray(int size) {
        return new Object[size];
    }
}

