/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.catheter;

import com.github.cao.awa.catheter.BooleanCatheter;
import com.github.cao.awa.catheter.ByteCatheter;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.catheter.DoubleCatheter;
import com.github.cao.awa.catheter.IntCatheter;
import com.github.cao.awa.catheter.action.BiLongFunction;
import com.github.cao.awa.catheter.action.BiLongPredicate;
import com.github.cao.awa.catheter.action.BooleanConsumer;
import com.github.cao.awa.catheter.action.IntegerAndBiLongPredicate;
import com.github.cao.awa.catheter.action.IntegerAndBiToLongFunction;
import com.github.cao.awa.catheter.action.IntegerAndLongConsumer;
import com.github.cao.awa.catheter.action.IntegerAndLongPredicate;
import com.github.cao.awa.catheter.action.LongArrayFunction;
import com.github.cao.awa.catheter.action.LongToByteFunction;
import com.github.cao.awa.catheter.matrix.MatrixFlockPos;
import com.github.cao.awa.catheter.matrix.MatrixPos;
import com.github.cao.awa.catheter.pair.IntegerAndLongPair;
import com.github.cao.awa.catheter.receptacle.BooleanReceptacle;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.catheter.receptacle.LongReceptacle;
import com.github.cao.awa.sinuatum.function.consumer.TriConsumer;
import com.github.cao.awa.sinuatum.function.function.QuinFunction;
import com.github.cao.awa.sinuatum.function.function.TriFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import java.util.stream.LongStream;

public class LongCatheter {
    private static final Random RANDOM = new Random();
    private long[] targets;

    public LongCatheter(long[] targets) {
        this.targets = targets;
    }

    public static LongCatheter make(long ... targets) {
        return new LongCatheter(targets);
    }

    public static LongCatheter makeCapacity(int size) {
        return new LongCatheter(LongCatheter.array(size));
    }

    public static LongCatheter of(long[] targets) {
        return new LongCatheter(targets);
    }

    public static LongCatheter of(Collection<Long> targets) {
        if (targets == null) {
            return new LongCatheter(LongCatheter.array(0));
        }
        long[] delegate = new long[targets.size()];
        int index = 0;
        for (long target : targets) {
            delegate[index++] = target;
        }
        return new LongCatheter(delegate);
    }

    public LongCatheter each(LongConsumer action) {
        long[] ts;
        for (long l : ts = this.targets) {
            action.accept(l);
        }
        return this;
    }

    public LongCatheter each(LongConsumer action, Runnable poster) {
        this.each(action);
        poster.run();
        return this;
    }

    public <X> LongCatheter each(X initializer, BiConsumer<X, Long> action) {
        long[] ts;
        for (long l : ts = this.targets) {
            action.accept(initializer, l);
        }
        return this;
    }

    public <X> LongCatheter each(X initializer, BiConsumer<X, Long> action, Consumer<X> poster) {
        this.each(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public <X> LongCatheter overall(X initializer, TriConsumer<X, Integer, Long> action) {
        long[] ts = this.targets;
        int index = 0;
        for (long l : ts) {
            action.accept(initializer, index++, l);
        }
        return this;
    }

    public <X> LongCatheter overall(X initializer, TriConsumer<X, Integer, Long> action, Consumer<X> poster) {
        this.overall(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public LongCatheter overall(IntegerAndLongConsumer action) {
        long[] ts = this.targets;
        int index = 0;
        for (long l : ts) {
            action.accept(index++, l);
        }
        return this;
    }

    public LongCatheter overall(IntegerAndLongConsumer action, Runnable poster) {
        this.overall(action);
        poster.run();
        return this;
    }

    public LongCatheter insert(IntegerAndBiToLongFunction maker) {
        HashMap indexes = new HashMap();
        LongReceptacle lastItem = new LongReceptacle(0L);
        this.overall((index, item) -> {
            indexes.put(index + indexes.size(), new IntegerAndLongPair(index, maker.apply(index, item, lastItem.get())));
            lastItem.set(item);
        });
        long[] ts = this.targets;
        long[] newDelegate = LongCatheter.array(ts.length + indexes.size());
        IntegerReceptacle lastIndex = new IntegerReceptacle(0);
        IntegerReceptacle lastDest = new IntegerReceptacle(0);
        IntCatheter.of(indexes.keySet()).sort().each((int index) -> {
            if (lastIndex.get() != index) {
                int maxCopyLength = Math.min(newDelegate.length - lastDest.get() - 1, index - lastIndex.get());
                System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), maxCopyLength);
            }
            IntegerAndLongPair item = (IntegerAndLongPair)indexes.get(index);
            newDelegate[index] = item.longValue();
            lastIndex.set(item.intValue());
            lastDest.set(index + 1);
        }, () -> System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), newDelegate.length - lastDest.get()));
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter pluck(IntegerAndBiLongPredicate maker) {
        if (this.isEmpty()) {
            return this;
        }
        LongReceptacle lastItem = new LongReceptacle(0L);
        return this.overallFilter((index, item) -> {
            if (maker.test(index, item, lastItem.get())) {
                return false;
            }
            lastItem.set(item);
            return true;
        });
    }

    public LongCatheter discardTo(LongPredicate predicate) {
        LongCatheter result = LongCatheter.make(new long[0]);
        this.overallFilter((index, item) -> !predicate.test(item), result::reset);
        return result;
    }

    public <X> LongCatheter discardTo(Predicate<X> predicate, LongFunction<X> converter) {
        LongCatheter result = LongCatheter.make(new long[0]);
        this.overallFilter((index, item) -> !predicate.test(converter.apply(item)), result::reset);
        return result;
    }

    public LongCatheter discardTo(long initializer, BiLongPredicate predicate) {
        LongCatheter result = LongCatheter.make(new long[0]);
        this.overallFilter((index, item) -> !predicate.test(item, initializer), result::reset);
        return result;
    }

    public LongCatheter orDiscardTo(boolean succeed, LongPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate);
    }

    public <X> LongCatheter orDiscardTo(boolean succeed, Predicate<X> predicate, LongFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate, converter);
    }

    public LongCatheter orDiscardTo(boolean succeed, long initializer, BiLongPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(initializer, predicate);
    }

    public LongCatheter discard(LongPredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item));
    }

    public <X> LongCatheter discard(Predicate<X> predicate, LongFunction<X> converter) {
        return this.overallFilter((index, item) -> !predicate.test(converter.apply(item)));
    }

    public LongCatheter discard(long initializer, BiLongPredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item, initializer));
    }

    public LongCatheter orDiscard(boolean succeed, LongPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate);
    }

    public <X> LongCatheter orDiscard(boolean succeed, Predicate<X> predicate, LongFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate, converter);
    }

    public LongCatheter orDiscard(boolean succeed, long initializer, BiLongPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(initializer, predicate);
    }

    public LongCatheter filterTo(LongPredicate predicate) {
        return this.dump().filter(predicate);
    }

    public <X> LongCatheter filterTo(Predicate<X> predicate, LongFunction<X> converter) {
        return this.dump().filter(predicate, converter);
    }

    public LongCatheter filterTo(long initializer, BiLongPredicate predicate) {
        return this.dump().filter(initializer, predicate);
    }

    public LongCatheter orFilterTo(boolean succeed, LongPredicate predicate) {
        return this.dump().orFilter(succeed, predicate);
    }

    public <X> LongCatheter orFilterTo(boolean succeed, Predicate<X> predicate, LongFunction<X> converter) {
        return this.dump().orFilter(succeed, predicate, converter);
    }

    public LongCatheter orFilterTo(boolean succeed, long initializer, BiLongPredicate predicate) {
        return this.dump().orFilter(succeed, initializer, predicate);
    }

    public LongCatheter filter(LongPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item));
    }

    public <X> LongCatheter filter(Predicate<X> predicate, LongFunction<X> converter) {
        return this.overallFilter((index, item) -> predicate.test(converter.apply(item)));
    }

    public LongCatheter filter(long initializer, BiLongPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item, initializer));
    }

    public LongCatheter orFilter(boolean succeed, LongPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate);
    }

    public <X> LongCatheter orFilter(boolean succeed, Predicate<X> predicate, LongFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate, converter);
    }

    public LongCatheter orFilter(boolean succeed, long initializer, BiLongPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(initializer, predicate);
    }

    public LongCatheter overallFilter(IntegerAndLongPredicate predicate) {
        return this.overallFilter(predicate, (long[] x) -> {});
    }

    public LongCatheter overallFilter(IntegerAndLongPredicate predicate, Consumer<long[]> discarding) {
        if (this.isEmpty()) {
            return this;
        }
        long[] ts = this.targets;
        int length = ts.length;
        boolean[] deleting = new boolean[length];
        int newDelegateSize = length;
        int index = 0;
        for (long target : ts) {
            if (predicate.test(index, target)) {
                ++index;
                continue;
            }
            deleting[index++] = true;
            --newDelegateSize;
        }
        long[] newDelegate = LongCatheter.array(newDelegateSize);
        long[] discardingDelegate = LongCatheter.array(length - newDelegateSize);
        int newDelegateIndex = 0;
        int discardingDelegateIndex = 0;
        index = 0;
        for (boolean isDeleting : deleting) {
            long t = ts[index++];
            if (isDeleting) {
                discardingDelegate[discardingDelegateIndex++] = t;
                continue;
            }
            newDelegate[newDelegateIndex++] = t;
        }
        discarding.accept(discardingDelegate);
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter overallFilter(long initializer, IntegerAndBiLongPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(index, item, initializer));
    }

    public boolean isPresent() {
        return this.count() > 0;
    }

    public LongCatheter ifPresent(Consumer<LongCatheter> action) {
        if (this.count() > 0) {
            action.accept(this);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public LongCatheter ifEmpty(Consumer<LongCatheter> action) {
        if (this.count() == 0) {
            action.accept(this);
        }
        return this;
    }

    public LongCatheter removeWithIndex(int index) {
        if (this.isEmpty() || index >= this.count() || index < 0) {
            return this;
        }
        long[] newDelegate = LongCatheter.array(this.count() - 1);
        if (index > 0) {
            System.arraycopy(this.targets, 0, newDelegate, 0, index);
        }
        System.arraycopy(this.targets, index + 1, newDelegate, index, this.count() - 1 - index);
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter distinct() {
        if (this.isEmpty()) {
            return this;
        }
        HashMap map = new HashMap();
        return this.filter(item -> {
            if (map.getOrDefault(item, false).booleanValue()) {
                return false;
            }
            map.put(item, true);
            return true;
        });
    }

    public LongCatheter sort() {
        Arrays.sort(this.targets);
        return this;
    }

    public LongCatheter sort(Comparator<Long> comparator) {
        Long[] array = new Long[this.targets.length];
        int index = 0;
        for (long target : this.targets) {
            array[index++] = target;
        }
        Arrays.sort(array, comparator);
        index = 0;
        Long[] longArray = array;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long target;
            target = longArray[i];
            this.targets[index++] = target;
        }
        return this;
    }

    public LongCatheter holdTill(int index) {
        if (this.isEmpty()) {
            return this;
        }
        index = Math.min(index, this.targets.length);
        long[] ts = this.targets;
        long[] newDelegate = LongCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter holdTill(LongPredicate predicate) {
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        long[] ts = this.targets;
        long[] newDelegate = LongCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter whenFlock(long source, BiLongFunction maker, LongConsumer consumer) {
        consumer.accept(this.flock(source, maker));
        return this;
    }

    public LongCatheter whenFlock(BiLongFunction maker, LongConsumer consumer) {
        consumer.accept(this.flock(maker));
        return this;
    }

    public <X> X alternate(X source, BiFunction<X, Long, X> maker) {
        long[] ts = this.targets;
        X result = source;
        for (long l : ts) {
            result = maker.apply(result, l);
        }
        return result;
    }

    public long flock(BiLongFunction maker) {
        long[] ts = this.targets;
        int length = ts.length;
        long result = length > 0 ? ts[0] : 0L;
        for (int i = 1; i < length; ++i) {
            result = maker.apply(result, ts[i]);
        }
        return result;
    }

    public <X> LongCatheter whenAlternate(X source, BiFunction<X, Long, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public <X> LongCatheter whenAlternate(BiFunction<X, Long, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(null, maker));
        return this;
    }

    public long flock(long source, BiLongFunction maker) {
        long[] ts = this.targets;
        long result = source;
        for (long l : ts) {
            result = maker.apply(result, l);
        }
        return result;
    }

    public boolean alternate(boolean source, BiLongPredicate maker) {
        BooleanReceptacle result = new BooleanReceptacle(source);
        this.flock((older, newer) -> {
            result.and(maker.test(older, newer));
            return newer;
        });
        return result.get();
    }

    public LongCatheter whenAlternate(boolean source, BiLongPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public LongCatheter whenAlternate(BiLongPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(false, maker));
        return this;
    }

    public LongCatheter waiveTill(int index) {
        long[] newDelegate;
        if (this.isEmpty()) {
            return this;
        }
        long[] ts = this.targets;
        if (index >= ts.length) {
            newDelegate = LongCatheter.array(0);
        } else {
            newDelegate = LongCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter waiveTill(LongPredicate predicate) {
        long[] newDelegate;
        long[] ts;
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        if (index >= (ts = this.targets).length) {
            newDelegate = LongCatheter.array(0);
        } else {
            newDelegate = LongCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter till(LongPredicate predicate) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (predicate.test(l)) break;
        }
        return this;
    }

    public int findTill(LongPredicate predicate) {
        long[] ts = this.targets;
        int index = 0;
        for (long l : ts) {
            if (predicate.test(l)) break;
            ++index;
        }
        return index;
    }

    public LongCatheter replace(LongUnaryOperator handler) {
        if (this.isEmpty()) {
            return this;
        }
        long[] ts = this.targets;
        int index = 0;
        for (long t : ts) {
            ts[index++] = handler.applyAsLong(t);
        }
        return this;
    }

    public BooleanCatheter vary(LongPredicate handler) {
        if (this.isEmpty()) {
            return BooleanCatheter.make(new boolean[0]);
        }
        long[] ts = this.targets;
        boolean[] array = new boolean[ts.length];
        int index = 0;
        for (long t : ts) {
            array[index++] = handler.test(t);
        }
        return BooleanCatheter.of(array);
    }

    public ByteCatheter vary(LongToByteFunction handler) {
        if (this.isEmpty()) {
            return ByteCatheter.make(new byte[0]);
        }
        long[] ts = this.targets;
        byte[] array = new byte[ts.length];
        int index = 0;
        for (long t : ts) {
            array[index++] = handler.applyAsByte(t);
        }
        return ByteCatheter.of(array);
    }

    public DoubleCatheter vary(LongToDoubleFunction handler) {
        if (this.isEmpty()) {
            return DoubleCatheter.make(new double[0]);
        }
        long[] ts = this.targets;
        double[] array = new double[ts.length];
        int index = 0;
        for (long t : ts) {
            array[index++] = handler.applyAsDouble(t);
        }
        return DoubleCatheter.of(array);
    }

    public IntCatheter vary(LongToIntFunction handler) {
        if (this.isEmpty()) {
            return IntCatheter.make(new int[0]);
        }
        long[] ts = this.targets;
        int[] array = new int[ts.length];
        int index = 0;
        for (long t : ts) {
            array[index++] = handler.applyAsInt(t);
        }
        return IntCatheter.of(array);
    }

    public LongCatheter vary(LongUnaryOperator handler) {
        return this.replace(handler);
    }

    public <X> Catheter<X> vary(LongFunction<X> handler) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        long[] ts = this.targets;
        X[] array = LongCatheter.xArray(ts.length);
        int index = 0;
        for (long t : ts) {
            array[index++] = handler.apply(t);
        }
        return Catheter.of(array);
    }

    public <X> Catheter<X> vary(LongFunction<X> handler, IntFunction<X[]> arrayGenerator) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        long[] ts = this.targets;
        X[] array = arrayGenerator.apply(ts.length);
        int index = 0;
        for (long l : ts) {
            array[index++] = handler.apply(l);
        }
        return Catheter.of(array).arrayGenerator(arrayGenerator);
    }

    public LongCatheter whenAny(LongPredicate predicate, LongConsumer action) {
        long[] ts;
        for (long t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            action.accept(t);
            break;
        }
        return this;
    }

    public LongCatheter whenAll(LongPredicate predicate, Runnable action) {
        long[] ts;
        for (long t : ts = this.targets) {
            if (predicate.test(t)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public LongCatheter whenAll(LongPredicate predicate, LongConsumer action) {
        return this.whenAll(predicate, () -> this.each(action));
    }

    private LongCatheter whenNone(LongPredicate predicate, Runnable action) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (!predicate.test(l)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public boolean hasAny(LongPredicate predicate) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (!predicate.test(l)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(LongPredicate predicate) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (predicate.test(l)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNone(LongPredicate predicate) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (!predicate.test(l)) continue;
            return false;
        }
        return true;
    }

    public long findFirst(LongPredicate predicate) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (!predicate.test(l)) continue;
            return l;
        }
        return 0L;
    }

    public long findLast(LongPredicate predicate) {
        long[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            long t;
            if (!predicate.test(t = ts[index--])) continue;
            return t;
        }
        return 0L;
    }

    public <X> X whenFoundFirst(LongPredicate predicate, LongFunction<X> function) {
        long[] ts;
        for (long l : ts = this.targets) {
            if (!predicate.test(l)) continue;
            return function.apply(l);
        }
        return null;
    }

    public <X> X whenFoundLast(LongPredicate predicate, LongFunction<X> function) {
        long[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            long t;
            if (!predicate.test(t = ts[index--])) continue;
            return function.apply(t);
        }
        return null;
    }

    public LongCatheter any(LongConsumer consumer) {
        if (this.targets.length > 0) {
            long[] ls = this.targets;
            int index = RANDOM.nextInt(ls.length);
            consumer.accept(ls.length > index ? ls[index] : ls[ls.length - 1]);
        }
        return this;
    }

    public LongCatheter first(LongConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[0]);
        }
        return this;
    }

    public LongCatheter tail(LongConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[this.targets.length - 1]);
        }
        return this;
    }

    public LongCatheter reverse() {
        if (this.isEmpty()) {
            return this;
        }
        long[] ts = this.targets;
        int length = ts.length;
        int split = length / 2;
        for (int index = 0; index < split; ++index) {
            int swapIndex = length - index - 1;
            long temp = ts[index];
            ts[index] = ts[swapIndex];
            ts[swapIndex] = temp;
        }
        return this;
    }

    public long max(Comparator<Long> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
    }

    public long min(Comparator<Long> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
    }

    public LongCatheter whenMax(Comparator<Long> comparator, LongConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result));
        return this;
    }

    public LongCatheter whenMin(Comparator<Long> comparator, LongConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result));
        return this;
    }

    public int count() {
        return this.targets.length;
    }

    public LongCatheter count(AtomicInteger target) {
        target.set(this.count());
        return this;
    }

    public LongCatheter count(IntegerReceptacle target) {
        target.set(this.count());
        return this;
    }

    public LongCatheter count(Consumer<Integer> consumer) {
        consumer.accept(this.count());
        return this;
    }

    public final LongCatheter append(long ... objects) {
        long[] ts = this.targets;
        long[] newDelegate = LongCatheter.array(ts.length + objects.length);
        System.arraycopy(ts, 0, newDelegate, 0, ts.length);
        System.arraycopy(objects, 0, newDelegate, ts.length, objects.length);
        this.targets = newDelegate;
        return this;
    }

    public LongCatheter append(LongCatheter objects) {
        return this.append(objects.array());
    }

    public LongCatheter repeat(int count) {
        long[] ts = this.array();
        for (int i = 0; i < count; ++i) {
            this.append(ts);
        }
        return this;
    }

    public long fetch(int index) {
        return this.targets[Math.min(index, this.targets.length - 1)];
    }

    public void fetch(int index, long item) {
        this.targets[index] = item;
    }

    public LongCatheter matrixEach(int width, BiConsumer<MatrixPos, Long> action) {
        return this.matrixReplace(width, (pos, item) -> {
            action.accept((MatrixPos)pos, (Long)item);
            return item;
        });
    }

    public <X> Catheter<X> matrixHomoVary(int width, LongCatheter input, TriFunction<MatrixPos, Long, Long, X> action) {
        if (input.count() == this.count()) {
            IntegerReceptacle index = new IntegerReceptacle(0);
            return this.matrixVary(width, (pos, item) -> {
                int indexValue = index.get();
                long inputX = input.fetch(indexValue);
                Object result = action.apply((MatrixPos)pos, (Long)item, inputX);
                index.set(indexValue + 1);
                return result;
            });
        }
        throw new IllegalArgumentException("The matrix is not homogeneous matrix");
    }

    public LongCatheter matrixMap(int width, int inputWidth, LongCatheter input, QuinFunction<MatrixFlockPos, MatrixPos, MatrixPos, Long, Long, Long> scanFlocked, TriFunction<MatrixPos, Long, Long, Long> combineFlocked) {
        int sourceHeight;
        boolean homoMatrix;
        int inputHeight = input.count() / inputWidth;
        boolean bl = homoMatrix = inputHeight == (sourceHeight = this.count() / width) && width == inputWidth;
        if (width != inputHeight && !homoMatrix) {
            throw new IllegalArgumentException("The matrix cannot be constructed because input height does not match to source width");
        }
        LongCatheter newMatrix = LongCatheter.makeCapacity(homoMatrix ? sourceHeight * width : sourceHeight * inputWidth);
        LongCatheter flockingCatheter = LongCatheter.makeCapacity(width);
        return newMatrix.matrixReplace(inputWidth, (pos, ignored) -> {
            int posX = pos.x();
            int posY = pos.y();
            int flockingIndex = 0;
            int inputY = 0;
            for (int sourceX = 0; sourceX < width; ++sourceX) {
                MatrixFlockPos flockPos = new MatrixFlockPos(posX, posY);
                MatrixPos inputPos = new MatrixPos(posX, inputY);
                MatrixPos sourcePos = new MatrixPos(sourceX, posY);
                long fetchedSource = this.fetch(posY * width + sourceX);
                long fetchedInput = input.fetch(inputY * inputWidth + posX);
                flockingCatheter.fetch(flockingIndex++, (Long)scanFlocked.apply(flockPos, sourcePos, inputPos, fetchedSource, fetchedInput));
                ++inputY;
            }
            return flockingCatheter.flock((current, next) -> (Long)combineFlocked.apply((MatrixPos)pos, current, next));
        });
    }

    public <X> Catheter<X> matrixVary(int width, long input, TriFunction<MatrixPos, Long, Long, X> action) {
        return this.matrixVary(width, (pos, item) -> action.apply((MatrixPos)pos, (Long)item, input));
    }

    public LongCatheter matrixReplace(int width, BiFunction<MatrixPos, Long, Long> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.replace(item -> {
            int wValue = w.get();
            int hValue = h.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return (Long)action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public <X> Catheter<X> matrixVary(int width, BiFunction<MatrixPos, Long, X> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.vary((long item) -> {
            int hValue = h.get();
            int wValue = w.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public Catheter<LongCatheter> matrixLines(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int sourceHeight = this.count() / width;
        Catheter<LongCatheter> results = Catheter.makeCapacity(sourceHeight);
        LongCatheter catheter = LongCatheter.makeCapacity(width);
        for (int y = 0; y < sourceHeight; ++y) {
            for (int x = 0; x < width; ++x) {
                long element = this.fetch(y * width + x);
                catheter.fetch(x, element);
            }
            results.fetch(y, catheter.dump());
        }
        return results;
    }

    public LongCatheter shuffle() {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public LongCatheter shuffle(RandomGenerator random) {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public LongCatheter swapShuffle(RandomGenerator random) {
        int i;
        long[] elements = this.targets;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            long fromElement = elements[swapFrom];
            long toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
        return this;
    }

    public boolean has(long target) {
        return this.hasAny(t -> t == target);
    }

    public boolean not(long target) {
        return !this.has(target);
    }

    public LongCatheter merge(LongCatheter other) {
        return this.append(other.filter(this::not));
    }

    public LongCatheter dump() {
        return new LongCatheter(this.array());
    }

    public LongCatheter flat(LongFunction<LongCatheter> function) {
        return this.arrayFlat(generator -> ((LongCatheter)function.apply((long)generator)).targets);
    }

    public LongCatheter arrayFlat(LongArrayFunction function) {
        long[] targets;
        if (this.isEmpty()) {
            return this;
        }
        long[][] longs = new long[this.count()][];
        int totalSize = 0;
        int index = 0;
        for (long element : targets = this.targets) {
            long[] flatting = function.apply(element);
            longs[index++] = flatting;
            totalSize += flatting.length;
        }
        targets = LongCatheter.array(totalSize);
        int pos = 0;
        long[][] lArrayArray = longs;
        int n = lArrayArray.length;
        for (int i = 0; i < n; ++i) {
            long[] flat;
            for (long l : flat = lArrayArray[i]) {
                targets[pos++] = l;
            }
        }
        this.targets = targets;
        return this;
    }

    public LongCatheter streamFlat(LongFunction<LongStream> function) {
        long[] targets;
        if (this.isEmpty()) {
            return this;
        }
        long[][] longs = new long[this.count()][];
        int totalSize = 0;
        int index = 0;
        for (long element : targets = this.targets) {
            long[] flatting = function.apply(element).toArray();
            longs[index++] = flatting;
            totalSize += flatting.length;
        }
        targets = LongCatheter.array(totalSize);
        int pos = 0;
        long[][] lArrayArray = longs;
        int n = lArrayArray.length;
        for (int i = 0; i < n; ++i) {
            long[] flat;
            for (long l : flat = lArrayArray[i]) {
                targets[pos++] = l;
            }
        }
        this.targets = targets;
        return this;
    }

    public <X> Catheter<X> flatTo(LongFunction<Catheter<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (long element : this.targets) {
            Catheter<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        return Catheter.flatting(catheter, totalSize);
    }

    public <X> Catheter<X> collectionFlatTo(LongFunction<Collection<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (long element : this.targets) {
            Collection<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.size();
        }
        return Catheter.flattingCollection(catheter, totalSize);
    }

    public <X> Catheter<X> arrayFlatTo(LongFunction<X[]> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter<X[]> catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (long element : this.targets) {
            X[] flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.length;
        }
        return Catheter.flattingArray(catheter, totalSize);
    }

    public LongCatheter reset() {
        this.targets = LongCatheter.array(0);
        return this;
    }

    public LongCatheter reset(long[] targets) {
        this.targets = targets;
        return this;
    }

    public long[] array() {
        return (long[])this.targets.clone();
    }

    public long[] dArray() {
        return this.targets;
    }

    public LongStream stream() {
        return LongStream.of(this.array());
    }

    public List<Long> list() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long l : this.array()) {
            list.add(l);
        }
        return list;
    }

    public Set<Long> set() {
        HashSet<Long> set = new HashSet<Long>();
        for (long l : this.array()) {
            set.add(l);
        }
        return set;
    }

    public static void main(String[] args) {
        LongCatheter source = LongCatheter.make(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L);
        System.out.println("???");
        System.out.println(source.removeWithIndex(4).list());
        System.out.println("???");
    }

    private static long[] array(int size) {
        return new long[size];
    }

    private static <X> X[] xArray(int size) {
        return new Object[size];
    }
}

