/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.fapals.command;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.catheter.action.BooleanPredicate;
import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import com.github.cao.awa.sepals.entity.ai.brain.TaskDelegate;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsCompositeTask;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsTaskStatus;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_4831;
import net.minecraft.server.MinecraftServer;

public class SepalsDebugCommand {
    public static final Set<class_2338> commandBlocks = ApricotCollectionFactor.hashSet();

    public static void register(MinecraftServer server) {
        server.method_3734().method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debugs").requires(serverCommandSource -> serverCommandSource.method_9259(4))).then(class_2170.method_9247((String)"tasks").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> SepalsDebugCommand.showTasks((CommandContext<class_2168>)context, b -> true))).then(class_2170.method_9247((String)"onlyRunning").executes(context -> SepalsDebugCommand.showTasks((CommandContext<class_2168>)context, b -> b)))).then(class_2170.method_9247((String)"onlyStopped").executes(context -> SepalsDebugCommand.showTasks((CommandContext<class_2168>)context, b -> !b))))).then((ArgumentBuilder)class_2170.method_9247((String)"special"))))).then(class_2170.method_9247((String)"memories").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> SepalsDebugCommand.showMemories((CommandContext<class_2168>)context, b -> true))).then(class_2170.method_9247((String)"onlyPresent").executes(context -> SepalsDebugCommand.showMemories((CommandContext<class_2168>)context, b -> b)))).then(class_2170.method_9247((String)"onlyEmpty").executes(context -> SepalsDebugCommand.showMemories((CommandContext<class_2168>)context, b -> !b))))).then((ArgumentBuilder)class_2170.method_9247((String)"special"))))).then(class_2170.method_9247((String)"locate").then(class_2170.method_9247((String)"commandBlock").executes(SepalsDebugCommand::showCommandBlocks))));
    }

    private static int showCommandBlocks(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (commandBlocks.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Current not any command block running in the world"));
            return -1;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Found " + commandBlocks.size() + " command blocks: ")).method_27694(style -> style.method_10977(class_124.field_1054)), true);
        source.method_9226(() -> class_2561.method_43470((String)commandBlocks.stream().map(pos -> "<x: " + pos.method_10263() + ", y: " + pos.method_10264() + ", z: " + pos.method_10260() + ">").toList().toString()).method_27694(style -> style.method_10977(class_124.field_1075)), true);
        return 0;
    }

    private static int showTasks(CommandContext<class_2168> context, BooleanPredicate showWhenRunning) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        if (entity == null) {
            source.method_9213(class_2561.method_30163((String)"Unable to select to an entity"));
            return -1;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            source.method_9226(() -> class_2561.method_43470((String)("Tasks of " + String.valueOf(entity.method_5667()))).method_27694(style -> style.method_10977(class_124.field_1054)), true);
            ((TaskDelegate)livingEntity.method_18868()).sepals$tasks().each(task -> {
                if (task instanceof DetailedDebuggableTask) {
                    boolean running;
                    DetailedDebuggableTask detailedTask = (DetailedDebuggableTask)task;
                    boolean bl = running = ((DetailedDebuggableTask)task).alwaysRunning() || SepalsTaskStatus.isRunning(task);
                    if (showWhenRunning.test(running)) {
                        if (task instanceof SepalsCompositeTask) {
                            SepalsCompositeTask compositeTask = (SepalsCompositeTask)task;
                            source.method_9226(() -> class_2561.method_43470((String)("* " + compositeTask.information())).method_27694(style -> style.method_10977(class_124.field_1077)), true);
                            compositeTask.sepals$tasks().each(compositedTask -> {
                                if (compositedTask instanceof DetailedDebuggableTask) {
                                    DetailedDebuggableTask compositedDetailedTask = (DetailedDebuggableTask)compositedTask;
                                    source.method_9226(() -> class_2561.method_43470((String)("# " + (compositedDetailedTask.alwaysRunning() || SepalsTaskStatus.isStopped(compositedTask) ? "+ " : "- "))).method_27694(style -> style.method_10977(class_124.field_1080)), true);
                                    source.method_9226(() -> class_2561.method_43470((String)compositedDetailedTask.information()).method_27694(style -> style.method_10977(class_124.field_1076)), true);
                                } else {
                                    source.method_9226(() -> class_2561.method_43470((String)("# " + (SepalsTaskStatus.isStopped(compositedTask) ? "+ " : "- "))).method_27694(style -> style.method_10977(class_124.field_1080)), true);
                                    source.method_9226(() -> class_2561.method_43470((String)compositedTask.toString()).method_27694(style -> style.method_10977(class_124.field_1076)), true);
                                }
                            });
                        } else {
                            source.method_9226(() -> class_2561.method_43470((String)(running ? "+ " : "- ")).method_27694(style -> style.method_10977(class_124.field_1080)), true);
                            source.method_9226(() -> class_2561.method_43470((String)detailedTask.information()).method_27694(style -> style.method_10977(running ? class_124.field_1075 : class_124.field_1061)), true);
                        }
                    }
                } else {
                    boolean running = SepalsTaskStatus.isRunning(task);
                    if (showWhenRunning.test(running)) {
                        source.method_9226(() -> class_2561.method_43470((String)((running ? "+ " : "- ") + String.valueOf(task))).method_27694(style -> style.method_10977(running ? class_124.field_1075 : class_124.field_1061)), true);
                    }
                }
            });
        } else {
            source.method_9213(class_2561.method_30163((String)"Unable to select to an entity as living entity"));
        }
        return 0;
    }

    private static int showMemories(CommandContext<class_2168> context, BooleanPredicate showWhenPresent) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        if (entity == null) {
            source.method_9213(class_2561.method_30163((String)"Unable to select to an entity"));
            return -1;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            source.method_9226(() -> class_2561.method_43470((String)("Memories of " + String.valueOf(entity.method_5667()))).method_27694(style -> style.method_10977(class_124.field_1054)), true);
            livingEntity.method_18868().method_35058().forEach((key, value) -> {
                boolean present = value.isPresent();
                class_4831 memory = value.orElse(null);
                if (showWhenPresent.test(present)) {
                    source.method_9226(() -> class_2561.method_43470((String)((present ? "+ " : "- ") + key.toString() + (String)(present ? ": " + String.valueOf(memory) : ""))).method_27694(style -> style.method_10977(present ? class_124.field_1075 : class_124.field_1061)), true);
                }
            });
        } else {
            source.method_9213(class_2561.method_30163((String)"Unable to select to an entity as living entity"));
        }
        return 0;
    }
}

