/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.collection.listener;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivableMap<K, V>
implements Map<K, V> {
    private final ActiveTrigger<K, V>[] triggers = new ActiveTrigger[ActiveTriggerType.values().length];
    private final Map<K, V> delegate;

    public ActivableMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    public ActivableMap<K, V> triggerPut(MapPutTrigger<K, V> putTrigger) {
        this.triggers[ActiveTriggerType.PUT.ordinal()] = putTrigger;
        return this;
    }

    public ActivableMap<K, V> triggerRemove(MapRemoveTrigger<K, V> removeTrigger) {
        this.triggers[ActiveTriggerType.REMOVE.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableMap<K, V> triggerPutAndRemoved(MapRemovedTrigger<K, V> removeTrigger) {
        this.triggers[ActiveTriggerType.REMOVED.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableMap<K, V> triggerPutAndRemove(MapPutTrigger<K, V> putTrigger, MapRemoveTrigger<K, V> removeTrigger) {
        this.triggers[ActiveTriggerType.PUT.ordinal()] = putTrigger;
        this.triggers[ActiveTriggerType.REMOVE.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableMap<K, V> triggerPutAndRemoved(MapPutTrigger<K, V> putTrigger, MapRemovedTrigger<K, V> removeTrigger) {
        this.triggers[ActiveTriggerType.PUT.ordinal()] = putTrigger;
        this.triggers[ActiveTriggerType.REMOVED.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableMap<K, V> triggerClear(MapClearTrigger<K, V> clearTrigger) {
        this.triggers[ActiveTriggerType.CLEAR.ordinal()] = clearTrigger;
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.trigger(ActiveTriggerType.REMOVE).trigger(key, value, this);
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V previousValue = this.delegate.remove(key);
        this.trigger(ActiveTriggerType.REMOVE).trigger(key, null, this);
        this.trigger(ActiveTriggerType.REMOVED).trigger(key, previousValue, this);
        return previousValue;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        ActiveTrigger<K, V> trigger = this.trigger(ActiveTriggerType.PUT);
        m.forEach((k, v) -> trigger.trigger(k, v, this));
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.trigger(ActiveTriggerType.CLEAR).trigger(null, null, this);
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public ActiveTrigger<K, V> trigger(ActiveTriggerType type) {
        return this.triggers[type.ordinal()];
    }

    public static enum ActiveTriggerType {
        PUT,
        REMOVE,
        REMOVED,
        CLEAR;

    }

    public static interface ActiveTrigger<K, V> {
        public void trigger(K var1, V var2, ActivableMap<K, V> var3);
    }

    public static interface MapClearTrigger<K, V>
    extends ActiveTrigger<K, V> {
        @Override
        default public void trigger(K k, V v, ActivableMap<K, V> map) {
            this.trigger(map);
        }

        public void trigger(Map<K, V> var1);
    }

    public static interface MapRemovedTrigger<K, V>
    extends ActiveTrigger<K, V> {
        @Override
        default public void trigger(K k, V v, ActivableMap<K, V> map) {
            this.trigger(k, v);
        }

        public void trigger(K var1, V var2);
    }

    public static interface MapRemoveTrigger<K, V>
    extends ActiveTrigger<K, V> {
        @Override
        default public void trigger(K k, V v, ActivableMap<K, V> map) {
            this.trigger(k);
        }

        public void trigger(K var1);
    }

    public static interface MapPutTrigger<K, V>
    extends ActiveTrigger<K, V> {
        @Override
        default public void trigger(K k, V v, ActivableMap<K, V> map) {
            this.trigger(k, v);
        }

        public void trigger(K var1, V var2);
    }
}

