/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.config;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.github.cao.awa.sepals.config.key.SepalsConfigKey;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SepalsConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"SepalsConfig");
    private static final File CONFIG_FILE = new File("config/sepals.json");
    public static final SepalsConfigKey<Boolean> FORCE_ENABLE_SEPALS_POI = SepalsConfigKey.create("forceEnableSepalsPoi", false);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_VILLAGER = SepalsConfigKey.create("enableSepalsVillager", true);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_FROG_LOOK_AT = SepalsConfigKey.create("enableSepalsFrogLookAt", true);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR = SepalsConfigKey.create("enableSepalsFrogAttackableSensor", true);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_LIVING_TARGET_CACHE = SepalsConfigKey.create("enableSepalsLivingTargetCache", true);
    public static final SepalsConfigKey<Boolean> NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT = SepalsConfigKey.create("nearestLivingEntitiesSensorUseQuickSort", true);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_BIASED_LONG_JUMP_TASK = SepalsConfigKey.create("enableSepalsBiasedLongJumpTask", true);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_ENTITIES_CRAMMING = SepalsConfigKey.create("enableSepalsEntitiesCramming", true);
    public static final SepalsConfigKey<Boolean> ENABLE_SEPALS_ITEM_MERGE = SepalsConfigKey.create("enableSepalsItemMerge", true);
    private final JSONObject config = new JSONObject();

    public boolean isForceEnableSepalsPoi() {
        return this.getConfig(FORCE_ENABLE_SEPALS_POI);
    }

    public boolean isEnableSepalsVillager() {
        return this.getConfig(ENABLE_SEPALS_VILLAGER);
    }

    public boolean isEnableSepalsFrogLookAt() {
        return this.getConfig(ENABLE_SEPALS_FROG_LOOK_AT);
    }

    public boolean isEnableSepalsFrogAttackableSensor() {
        return this.getConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR);
    }

    public boolean isEnableSepalsLivingTargetCache() {
        return this.getConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE);
    }

    public boolean isNearestLivingEntitiesSensorUseQuickSort() {
        return this.getConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT);
    }

    public boolean isEnableSepalsBiasedLongJumpTask() {
        return this.getConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK);
    }

    public boolean isEnableSepalsEntitiesCramming() {
        return this.getConfig(ENABLE_SEPALS_ENTITIES_CRAMMING);
    }

    public boolean isEnableSepalsItemMerge() {
        return this.getConfig(ENABLE_SEPALS_ITEM_MERGE);
    }

    public <X> void setConfig(SepalsConfigKey<X> configKey, X value) {
        this.config.put(configKey.name(), configKey.checkLimits(SepalsConfig.checkOrThrow(configKey, value)));
    }

    public <X> void setConfig(SepalsConfigKey<X> configKey, JSONObject json) {
        this.config.put(configKey.name(), configKey.checkLimits(SepalsConfig.checkOrThrow(configKey, json.get(configKey.name()))));
    }

    public <X> X getConfig(@NotNull SepalsConfigKey<X> configKey) {
        Object value = this.config.get(configKey.name());
        if (value == null) {
            return configKey.defaultValue();
        }
        return SepalsConfig.checkOrThrow(configKey, value);
    }

    @NotNull
    private static <X> X checkOrThrow(@NotNull SepalsConfigKey<X> configKey, Object value) {
        if (value == null) {
            throw new NullPointerException("Config value should not be null");
        }
        if (configKey.type().isInstance(value) || configKey.type().isAssignableFrom(value.getClass())) {
            return (X)Manipulate.cast(value);
        }
        throw new IllegalArgumentException("Config '" + configKey.name() + "' required '" + String.valueOf(configKey.type()) + "' but got '" + String.valueOf(value.getClass()) + "'");
    }

    public void load() {
        this.loadAsDefault();
        try {
            JSONObject config = JSONObject.parse(IOUtil.read(new FileReader(CONFIG_FILE, StandardCharsets.UTF_8)), new JSONReader.Feature[0]);
            this.setConfig(FORCE_ENABLE_SEPALS_POI, config);
            this.setConfig(ENABLE_SEPALS_VILLAGER, config);
            this.setConfig(ENABLE_SEPALS_FROG_LOOK_AT, config);
            this.setConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR, config);
            this.setConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE, config);
            this.setConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT, config);
            this.setConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK, config);
            this.setConfig(ENABLE_SEPALS_ENTITIES_CRAMMING, config);
            this.setConfig(ENABLE_SEPALS_ITEM_MERGE, config);
        }
        catch (Exception e) {
            LOGGER.warn("Config not found, use default values", (Throwable)e);
        }
        this.write();
    }

    public void write() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            IOUtil.write((Writer)new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8), this.config.toString(JSONWriter.Feature.PrettyFormat));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public void loadAsDefault() {
        this.setConfig(FORCE_ENABLE_SEPALS_POI, FORCE_ENABLE_SEPALS_POI.defaultValue());
        this.setConfig(ENABLE_SEPALS_VILLAGER, ENABLE_SEPALS_VILLAGER.defaultValue());
        this.setConfig(ENABLE_SEPALS_FROG_LOOK_AT, ENABLE_SEPALS_FROG_LOOK_AT.defaultValue());
        this.setConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR, ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR.defaultValue());
        this.setConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE, ENABLE_SEPALS_LIVING_TARGET_CACHE.defaultValue());
        this.setConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT, NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT.defaultValue());
        this.setConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK, ENABLE_SEPALS_BIASED_LONG_JUMP_TASK.defaultValue());
        this.setConfig(ENABLE_SEPALS_ENTITIES_CRAMMING, ENABLE_SEPALS_ENTITIES_CRAMMING.defaultValue());
        this.setConfig(ENABLE_SEPALS_ITEM_MERGE, ENABLE_SEPALS_ITEM_MERGE.defaultValue());
    }

    public void copyFrom(@NotNull SepalsConfig config) {
        this.setConfig(FORCE_ENABLE_SEPALS_POI, config.isForceEnableSepalsPoi());
        this.setConfig(ENABLE_SEPALS_VILLAGER, config.isEnableSepalsVillager());
        this.setConfig(ENABLE_SEPALS_FROG_LOOK_AT, config.isEnableSepalsFrogLookAt());
        this.setConfig(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR, config.isEnableSepalsFrogAttackableSensor());
        this.setConfig(ENABLE_SEPALS_LIVING_TARGET_CACHE, config.isEnableSepalsLivingTargetCache());
        this.setConfig(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT, config.isNearestLivingEntitiesSensorUseQuickSort());
        this.setConfig(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK, config.isEnableSepalsBiasedLongJumpTask());
        this.setConfig(ENABLE_SEPALS_ENTITIES_CRAMMING, config.isEnableSepalsEntitiesCramming());
        this.setConfig(ENABLE_SEPALS_ITEM_MERGE, config.isEnableSepalsItemMerge());
    }

    public void print() {
        LOGGER.info("Sepals 'forceEnableSepalsPoi' flag is {}", (Object)this.isForceEnableSepalsPoi());
        LOGGER.info("Sepals 'enableSepalsVillager' flag is {}", (Object)this.isEnableSepalsVillager());
        LOGGER.info("Sepals 'enableSepalsFrogLookAt' flag is {}", (Object)this.isEnableSepalsFrogLookAt());
        LOGGER.info("Sepals 'enableSepalsFrogAttackableSensor' flag is {}", (Object)this.isEnableSepalsFrogAttackableSensor());
        LOGGER.info("Sepals 'enableSepalsLivingTargetCache' flag is {}", (Object)this.isEnableSepalsLivingTargetCache());
        LOGGER.info("Sepals 'nearestLivingEntitiesSensorUseQuickSort' flag is {}", (Object)this.isNearestLivingEntitiesSensorUseQuickSort());
        LOGGER.info("Sepals 'enableSepalsBiasedJumpLongTask' flag is {}", (Object)this.isEnableSepalsBiasedLongJumpTask());
        LOGGER.info("Sepals 'enableSepalsEntitiesCramming' flag is {}", (Object)this.isEnableSepalsEntitiesCramming());
        LOGGER.info("Sepals 'enableSepalsItemMerge' flag is {}", (Object)this.isEnableSepalsItemMerge());
    }

    public Set<SepalsConfigKey<?>> collectEnabled() {
        HashSet<SepalsConfigKey<?>> enabled = CollectionFactor.hashSet();
        if (this.isForceEnableSepalsPoi()) {
            enabled.add(FORCE_ENABLE_SEPALS_POI);
        }
        if (this.isEnableSepalsVillager()) {
            enabled.add(ENABLE_SEPALS_VILLAGER);
        }
        if (this.isEnableSepalsFrogLookAt()) {
            enabled.add(ENABLE_SEPALS_FROG_LOOK_AT);
        }
        if (this.isEnableSepalsFrogAttackableSensor()) {
            enabled.add(ENABLE_SEPALS_FROG_ATTACKABLE_SENSOR);
        }
        if (this.isEnableSepalsLivingTargetCache()) {
            enabled.add(ENABLE_SEPALS_LIVING_TARGET_CACHE);
        }
        if (this.isNearestLivingEntitiesSensorUseQuickSort()) {
            enabled.add(NEAREST_LIVING_ENTITIES_SENSOR_USE_QUICK_SORT);
        }
        if (this.isEnableSepalsBiasedLongJumpTask()) {
            enabled.add(ENABLE_SEPALS_BIASED_LONG_JUMP_TASK);
        }
        if (this.isEnableSepalsEntitiesCramming()) {
            enabled.add(ENABLE_SEPALS_ENTITIES_CRAMMING);
        }
        if (this.isEnableSepalsItemMerge()) {
            enabled.add(ENABLE_SEPALS_ITEM_MERGE);
        }
        return enabled;
    }
}

