/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.biased;

import com.github.cao.awa.sepals.entity.ai.task.SepalsLongJumpTask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1308;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_6019;
import net.minecraft.class_6862;

public class SepalsBiasedLongJumpTask<E extends class_1308>
extends SepalsLongJumpTask<E> {
    private final class_6862<class_2248> favoredBlocks;
    private final float biasChance;
    private final List<SepalsLongJumpTask.Target> unfavoredTargets = new ArrayList<SepalsLongJumpTask.Target>();
    private boolean useBias;

    public SepalsBiasedLongJumpTask(class_6019 cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, class_3414> entityToSound, class_6862<class_2248> favoredBlocks, float biasChance, BiPredicate<E, class_2338> jumpToPredicate) {
        super(cooldownRange, verticalRange, horizontalRange, maxRange, entityToSound, jumpToPredicate);
        this.favoredBlocks = favoredBlocks;
        this.biasChance = biasChance;
    }

    @Override
    protected void run(class_3218 serverWorld, E mobEntity, long l) {
        super.run(serverWorld, mobEntity, l);
        this.unfavoredTargets.clear();
        this.useBias = mobEntity.method_59922().method_43057() < this.biasChance;
    }

    @Override
    protected SepalsLongJumpTask.Target getTarget(class_3218 world) {
        if (this.useBias) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            while (this.targets.isPresent()) {
                SepalsLongJumpTask.Target target = super.getTarget(world);
                if (!this.addUnfavored(world, mutable, target)) continue;
                return target;
            }
            return this.unfavoredTargets.isEmpty() ? null : this.unfavoredTargets.removeFirst();
        }
        return super.getTarget(world);
    }

    private boolean addUnfavored(class_3218 world, class_2338.class_2339 mutable, SepalsLongJumpTask.Target target) {
        if (world.method_8320((class_2338)mutable.method_25505((class_2382)target.getPos(), class_2350.field_11033)).method_26164(this.favoredBlocks)) {
            return true;
        }
        this.unfavoredTargets.add(target);
        return false;
    }
}

