/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.transform.mixin.handler;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.sepals.transform.mixin.handler.world.SepalsWorldMixinHandler;
import com.github.cao.awa.sepals.transform.mixin.handler.world.poi.SepalsWorldPoiMixinHandler;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SepalsMixinHandler {
    private static final List<Runnable> postProcesses = ApricotCollectionFactor.arrayList();
    private static final Map<String, SepalsMixinHandler> handlers = ApricotCollectionFactor.hashMap();
    public static final Logger LOGGER = LogManager.getLogger((String)"SepalsMixinHandler");

    public abstract boolean canApply(String var1, String var2, String var3);

    public abstract void postProcess(String var1, String var2, String var3);

    public static void registerHandler(String group, SepalsMixinHandler handler) {
        handlers.put(group, handler);
    }

    public static void appendPostProcesses(Runnable handler) {
        postProcesses.add(handler);
    }

    public static void startPostProcess() {
        postProcesses.forEach(Runnable::run);
        postProcesses.clear();
    }

    public static <H extends SepalsMixinHandler> H handler(String group) {
        return (H)handlers.get(group);
    }

    public static void registerDefaultHandlers() {
        if (handlers.isEmpty()) {
            SepalsMixinHandler.registerHandler("poi", new SepalsWorldPoiMixinHandler());
            SepalsMixinHandler.registerHandler("entities", new SepalsWorldMixinHandler());
        }
    }
}

