/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.transform.mixin.handler.world.poi;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.transform.mixin.handler.SepalsMixinHandler;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;

public class SepalsWorldPoiMixinHandler
extends SepalsMixinHandler {
    @Override
    public boolean canApply(String mixinGroup, String mixinName, String mixinClassName) {
        if (Sepals.CONFIG.isForceEnableSepalsPoi()) {
            return true;
        }
        if (!mixinGroup.equals("poi")) {
            return false;
        }
        boolean lithiumLoaded = Sepals.LOADED_MODS.contains("lithium");
        switch (mixinName) {
            case "region_based_storage": 
            case "poi_set": {
                return !lithiumLoaded;
            }
        }
        return true;
    }

    @Override
    public void postProcess(String mixinGroup, String mixinName, String mixinClassName) {
        if (Sepals.CONFIG.isForceEnableSepalsPoi()) {
            return;
        }
        if (!mixinGroup.equals("poi")) {
            return;
        }
        if (mixinName.equals("region_based_storage")) {
            boolean isLithiumLoaded = Sepals.LOADED_MODS.contains("lithium");
            boolean isMoonriseLoaded = Sepals.LOADED_MODS.contains("moonrise");
            if (isLithiumLoaded) {
                LOGGER.info("Lithium is loaded, auto-disabling sepals mixin: {}({})", (Object)"region_based_storage", (Object)mixinClassName);
                SepalsPointOfInterestStorage.onLithiumLoaded();
            }
            if (isMoonriseLoaded) {
                LOGGER.info("Moonrise is loaded, sepals won't intervention chunk loading in 'getInChunk' of POI");
                SepalsPointOfInterestStorage.onMoonriseLoaded();
            }
        }
    }
}

