/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.weight;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.weight.result.WeightingResult;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.class_5819;
import net.minecraft.class_6008;

public class WeightTable<T> {
    private Ranged<T>[] weighted;
    private int range;

    public static <X extends class_6008> WeightTable<X> initWeight(Catheter<X> pool) {
        int size = pool.count();
        Range[] ranges = new Range[size];
        int range = 0;
        for (int i = 0; i < size; ++i) {
            class_6008 weighted = (class_6008)pool.fetch(i);
            int nextRange = range + weighted.method_34979().method_34976();
            ranges[i] = new Range<class_6008>(range, nextRange, weighted);
            range = nextRange;
        }
        return new WeightTable().initWeightWithPrecalculate(ranges, Math.max(range, 1));
    }

    public static <X extends class_6008> WeightTable<X> initWeight(List<X> pool) {
        class_6008[] elements = new class_6008[pool.size()];
        pool.toArray(elements);
        return WeightTable.initWeight(elements, (X weighted) -> weighted.method_34979().method_34976());
    }

    public static <X> WeightTable<X> initWeight(Collection<X> pool, ToIntFunction<X> weightGenerator) {
        int size = pool.size();
        Object[] elements = new Object[size];
        pool.toArray(elements);
        Range[] ranges = new Range[size];
        int range = 0;
        for (int i = 0; i < size; ++i) {
            Object weighted = elements[i];
            int nextRange = range + weightGenerator.applyAsInt(weighted);
            ranges[i] = new Range<Object>(range, nextRange, weighted);
            range = nextRange;
        }
        return new WeightTable().initWeightWithPrecalculate(ranges, Math.max(range, 1));
    }

    public static <X> WeightTable<X> initWeight(X[] pool, ToIntFunction<X> weightGenerator) {
        int size = pool.length;
        Range[] ranges = new Range[size];
        int range = 0;
        for (int i = 0; i < size; ++i) {
            X weighted = pool[i];
            int nextRange = range + weightGenerator.applyAsInt(weighted);
            ranges[i] = new Range<X>(range, nextRange, weighted);
            range = nextRange;
        }
        return new WeightTable().initWeightWithPrecalculate(ranges, Math.max(range, 1));
    }

    public static <X> WeightTable<X> initWeight(Pair<X, Integer>[] pool) {
        int size = pool.length;
        Range[] ranges = new Range[size];
        int range = 0;
        for (int i = 0; i < size; ++i) {
            Pair<X, Integer> pair = pool[i];
            Object x = pair.getFirst();
            int nextRange = range + (Integer)pair.getSecond();
            ranges[i] = new Range<Object>(range, nextRange, x);
            range = nextRange;
        }
        return new WeightTable().initWeightWithPrecalculate(ranges, Math.max(range, 1));
    }

    public WeightTable<T> initWeightWithPrecalculate(Ranged<T>[] weighted, int range) {
        this.weighted = weighted;
        this.range = range;
        return this;
    }

    public T select(class_5819 random) {
        WeightingResult<T> result = this.selectRange(random);
        if (result == null) {
            return null;
        }
        return result.value();
    }

    public WeightingResult<T> selectRange(class_5819 random) {
        Ranged<T>[] ranges = this.weighted;
        if (ranges.length == 1) {
            return new WeightingResult<T>(ranges[0].element(), 0);
        }
        if (this.range == 1) {
            int index = random.method_43048(ranges.length);
            return new WeightingResult<T>(ranges[index].element(), index);
        }
        int expected = random.method_43048(this.range);
        int size = ranges.length;
        int maxEdge = size - 1;
        int index = maxEdge / 2;
        Range<Object> weightedEdge = new Range<Object>(0, maxEdge, null);
        int dynamicMaxEdge = maxEdge;
        while (index < size && index > -1 && weightedEdge.isIn(index)) {
            Ranged<T> range = ranges[index];
            if (range.isIn(expected)) {
                return new WeightingResult<T>(range.element(), index);
            }
            if (range.isBigger(expected)) {
                index += Math.max((dynamicMaxEdge - index) / 2, 1);
                continue;
            }
            dynamicMaxEdge = index;
            index -= Math.max(index / 2, 1);
        }
        return null;
    }

    public WeightingResult<T> selectWithIndex(int index) {
        if (index < this.weighted.length) {
            return new WeightingResult<T>(this.weighted[index].element(), index);
        }
        return new WeightingResult<Object>(null, index);
    }

    public static final class Range<T>
    implements Ranged<T> {
        private final int min;
        private final int max;
        private final T element;

        public Range(int min, int max, T element) {
            this.min = min;
            this.max = max;
            this.element = element;
        }

        @Override
        public int min() {
            return this.min;
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public T element() {
            return this.element;
        }
    }

    public static interface Ranged<T> {
        default public boolean isIn(int value) {
            return this.min() <= value && this.max() >= value;
        }

        default public boolean isSmaller(int value) {
            return this.min() > value;
        }

        default public boolean isBigger(int value) {
            return this.max() < value;
        }

        public int min();

        public int max();

        public T element();
    }
}

