/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.DSL;
import java.util.function.BiConsumer;
import mc.recraftors.unruled_api.rules.DoubleRule;
import mc.recraftors.unruled_api.rules.EntitySelectorRule;
import mc.recraftors.unruled_api.rules.EnumRule;
import mc.recraftors.unruled_api.rules.FloatRule;
import mc.recraftors.unruled_api.rules.LongRule;
import mc.recraftors.unruled_api.rules.RegistryEntryRule;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.rules.StringRule;
import mc.recraftors.unruled_api.rules.TextRule;
import mc.recraftors.unruled_api.utils.EncapsulatedException;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import net.minecraft.class_1208;
import net.minecraft.class_1928;
import net.minecraft.class_2300;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class UnruledApi {
    public static final String MOD_ID = "unruled_api";
    public static final Logger LOGGER = LogManager.getLogger((String)"unruled_api");
    public static final DynamicCommandExceptionType INVALID_INT = new DynamicCommandExceptionType(v -> new LiteralMessage("Invalid integer '" + String.valueOf(v) + "'"));
    public static final DSL.TypeReference GAMERULES_TYPE = class_1208.method_59518((String)"gamerules");

    private static int strLen(String s, int i) {
        return Math.max(i, (int)Math.ceil((double)s.length() / 8.0) * 8);
    }

    public static <T extends class_1928.class_4315<T>> class_1928.class_4313<T> register(String name, class_1928.class_5198 category, class_1928.class_4314<T> type) {
        return class_1928.method_8359((String)name, (class_1928.class_5198)category, type);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static class_1928.class_4314<class_1928.class_4310> createBoolean(boolean initialValue, BiConsumer<MinecraftServer, class_1928.class_4310> changeCallback) {
        return class_1928.class_4310.method_20760((boolean)initialValue, changeCallback);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static class_1928.class_4314<class_1928.class_4310> createBoolean(boolean initialValue) {
        return class_1928.class_4310.method_20759((boolean)initialValue);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<class_1928.class_4310> registerBoolean(String name, class_1928.class_5198 category, boolean initialValue, BiConsumer<MinecraftServer, class_1928.class_4310> changeCallback) {
        return UnruledApi.register(name, category, UnruledApi.createBoolean(initialValue, changeCallback));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<class_1928.class_4310> registerBoolean(String name, class_1928.class_5198 category, boolean initialValue) {
        return UnruledApi.register(name, category, UnruledApi.createBoolean(initialValue));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static class_1928.class_4314<class_1928.class_4312> createInt(int initialValue, BiConsumer<MinecraftServer, class_1928.class_4312> changeCallback) {
        return class_1928.class_4312.method_20766((int)initialValue, changeCallback);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static class_1928.class_4314<class_1928.class_4312> createInt(int initialValue) {
        return class_1928.class_4312.method_20768((int)initialValue);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<class_1928.class_4312> registerInt(String name, class_1928.class_5198 category, int initialValue, BiConsumer<MinecraftServer, class_1928.class_4312> changeCallback) {
        return UnruledApi.register(name, category, UnruledApi.createInt(initialValue, changeCallback));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<class_1928.class_4312> registerInt(String name, class_1928.class_5198 category, int initialValue) {
        return UnruledApi.register(name, category, UnruledApi.createInt(initialValue));
    }

    public static RuleBuilder<class_1928.class_4312, Integer> intRuleBuilder(int initialValue) {
        return new RuleBuilder.IntRuleBuilder(initialValue);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<DoubleRule> registerDoubleRule(String name, class_1928.class_5198 category, double initialValue) {
        return UnruledApi.doubleRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<EntitySelectorRule> registerEntitySelectorRule(String name, class_1928.class_5198 category, String initialValue) {
        return UnruledApi.entitySelectorRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T extends Enum<T>> class_1928.class_4313<EnumRule<T>> registerEnumRule(String name, class_1928.class_5198 category, Class<T> enumClass, T initialValue) {
        return UnruledApi.enumRuleBuilder(enumClass, initialValue).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<FloatRule> registerFloatRule(String name, class_1928.class_5198 category, float initialValue) {
        return UnruledApi.floatRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<LongRule> registerLongRule(String name, class_1928.class_5198 category, long initialValue) {
        return UnruledApi.longRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T> class_1928.class_4313<RegistryEntryRule<T>> registerRegistryEntryRule(String name, class_1928.class_5198 category, class_2378<T> registry, T initialValue) {
        return UnruledApi.registryEntryRuleBuilder(registry, initialValue).register(name, category);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<StringRule> registerStringRule(String name, class_1928.class_5198 category, String initialValue, int maxLength) {
        return UnruledApi.stringRuleBuilder(initialValue, maxLength).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static class_1928.class_4313<TextRule> registerTextRule(String name, class_1928.class_5198 category, String initialValue) {
        return UnruledApi.textRuleBuilder(initialValue).register(name, category);
    }

    public static DoubleRule.Builder doubleRuleBuilder(double initialValue) {
        return new DoubleRule.Builder(initialValue);
    }

    public static EntitySelectorRule.Builder entitySelectorRuleBuilder(String initialValue) throws EncapsulatedException {
        return new EntitySelectorRule.Builder(initialValue);
    }

    public static <T extends Enum<T>> EnumRule.Builder<T> enumRuleBuilder(Class<T> enumClass, T initialValue) {
        return new EnumRule.Builder<T>(enumClass, initialValue);
    }

    public static FloatRule.Builder floatRuleBuilder(float initialValue) {
        return new FloatRule.Builder(initialValue);
    }

    public static LongRule.Builder longRuleBuilder(long initialValue) {
        return new LongRule.Builder(initialValue);
    }

    public static <T> RegistryEntryRule.Builder<T> registryEntryRuleBuilder(class_2378<T> registry, T initialValue) {
        return new RegistryEntryRule.Builder<T>(registry, initialValue);
    }

    public static <T> RegistryEntryRule.Builder<T> registryEntryRuleBuilder(class_5321<? extends class_2378<T>> key, class_2960 valueId) {
        return new RegistryEntryRule.Builder(key, valueId);
    }

    public static StringRule.Builder stringRuleBuilder(String initialValue, int maxLength) throws UnsupportedOperationException {
        return new StringRule.Builder(initialValue, maxLength);
    }

    public static TextRule.Builder textRuleBuilder(String initialValue) {
        return new TextRule.Builder(initialValue);
    }

    public static boolean getBoolean(class_1928 gameRules, class_1928.class_4313<class_1928.class_4310> key) {
        return gameRules.method_8355(key);
    }

    public static int getInt(class_1928 gamerules, class_1928.class_4313<class_1928.class_4312> key) {
        return gamerules.method_8356(key);
    }

    public static long getLong(class_1928 gameRules, class_1928.class_4313<LongRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getLong(key);
    }

    public static float getFloat(class_1928 gameRules, class_1928.class_4313<FloatRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getFloat(key);
    }

    public static double getDouble(class_1928 gameRules, class_1928.class_4313<DoubleRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getDouble(key);
    }

    public static <T extends Enum<T>> T getEnum(class_1928 gameRules, class_1928.class_4313<EnumRule<T>> key) {
        return ((IGameRulesProvider)gameRules).unruled_getEnum(key);
    }

    public static String getString(class_1928 gameRules, class_1928.class_4313<StringRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getString(key);
    }

    public static String getText(class_1928 gameRules, class_1928.class_4313<TextRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getText(key);
    }

    public static class_2300 getEntitySelector(class_1928 gameRules, class_1928.class_4313<EntitySelectorRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getEntitySelector(key);
    }

    public static <T> T getRegistryEntry(class_1928 gameRules, class_1928.class_4313<RegistryEntryRule<T>> key) {
        return ((IGameRulesProvider)gameRules).unruled_getRegistryEntry(key);
    }
}

