/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.mixin;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import mc.recraftors.unruled_api.utils.LangFallbacks;
import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/server/command/GameRuleCommand$1"})
public abstract class GameruleCommandVisitorMixin {
    @Inject(method={"visit"}, at={@At(value="TAIL")})
    private <T extends class_1928.class_4315<T>> void setupOverridesSubArgs(class_1928.class_4313<T> key, class_1928.class_4314<T> type, CallbackInfo ci) {
        LiteralArgumentBuilder<class_2168> builder = Utils.argumentBuilderThreadLocal.get();
        if (builder == null) {
            return;
        }
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(context -> GameruleCommandVisitorMixin.unruled_queryOverrideSimple((CommandContext<class_2168>)context, key))).then(type.method_20775("value").executes(context -> GameruleCommandVisitorMixin.unruled_setOverrideSimple((CommandContext<class_2168>)context, key)))).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> GameruleCommandVisitorMixin.unruled_queryOverrideInWorld((CommandContext<class_2168>)context, key))).then(type.method_20775("value").executes(context -> GameruleCommandVisitorMixin.unruled_setOverrideInWorld((CommandContext<class_2168>)context, key))))));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverrideSimple(CommandContext<class_2168> context, class_1928.class_4313<T> key) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        return GameruleCommandVisitorMixin.unruled_queryOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverrideInWorld(CommandContext<class_2168> context, class_1928.class_4313<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_queryOverride(context, key, class_2181.method_9289(context, (String)"dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverrideSimple(CommandContext<class_2168> context, class_1928.class_4313<T> key) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        return GameruleCommandVisitorMixin.unruled_setOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverrideInWorld(CommandContext<class_2168> context, class_1928.class_4313<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_setOverride(context, key, class_2181.method_9289(context, (String)"dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverride(CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        if (!manager.hasOverride(key)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.none", (String)LangFallbacks.OVERRIDE_NONE.format(keyName, worldId), (Object[])new Object[]{keyName, worldId.toString()}), false);
            return 0;
        }
        Object rule = manager.get(key);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.query", (String)LangFallbacks.OVERRIDE_QUERY.format(keyName, worldId, rule.toString()), (Object[])new Object[]{keyName, worldId.toString(), rule.toString()}), false);
        return rule.method_20781();
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverride(CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        manager.override(key, context);
        Object rule = manager.get(key);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.set", (String)LangFallbacks.OVERRIDE_SET.format(keyName, worldId, rule.toString()), (Object[])new Object[]{keyName, worldId.toString(), rule.toString()}), true);
        return rule.method_20781();
    }
}

