/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.EncapsulatedException;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySelectorRule
extends class_1928.class_4315<EntitySelectorRule>
implements GameruleAccessor<class_2300> {
    private class_2300 value;
    private String str;
    private IGameruleValidator<class_2300> validator;
    private IGameruleAdapter<class_2300> adapter;

    public EntitySelectorRule(class_1928.class_4314<EntitySelectorRule> type, String initialValue, IGameruleValidator<class_2300> validator, IGameruleAdapter<class_2300> adapter) {
        super(type);
        Objects.requireNonNull(initialValue);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.str = initialValue;
        this.value = EntitySelectorRule.parseStr(initialValue);
        this.validator = validator;
        this.adapter = adapter;
    }

    public EntitySelectorRule(class_1928.class_4314<EntitySelectorRule> type, String initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public class_2300 get() {
        return this.value;
    }

    public boolean validate(String input) {
        input = input.trim();
        try {
            class_2300 e = EntitySelectorRule.parseStr(input);
            if (this.validator.validate(e)) {
                this.value = EntitySelectorRule.parseStr(input);
                this.str = input;
                return true;
            }
            Optional<class_2300> o = this.adapter.adapt(e);
            if (o.isPresent() && this.validator.validate(o.get())) {
                this.value = o.get();
                this.str = input;
                return true;
            }
            return false;
        }
        catch (EncapsulatedException e) {
            return false;
        }
    }

    private static class_2300 parseStr(String s) throws EncapsulatedException {
        try {
            return new class_2303(new StringReader(s)).method_9882();
        }
        catch (CommandSyntaxException e) {
            throw new EncapsulatedException((Exception)((Object)e));
        }
    }

    protected void method_20776(CommandContext<class_2168> context, String name) {
        String s = (String)context.getArgument(name, String.class);
        class_2300 e = (class_2300)context.getArgument(name, class_2300.class);
        if (this.validator.validate(e)) {
            this.value = e;
            this.str = s;
            return;
        }
        throw new IllegalArgumentException("Unsupported value for input " + s);
    }

    protected void method_20777(String value) {
        try {
            Optional<class_2300> o;
            class_2300 e = EntitySelectorRule.parseStr(value);
            boolean b = this.validator.validate(e);
            if (!b && (o = this.adapter.adapt(e)).isPresent()) {
                e = o.get();
                b = this.validator.validate(e);
            }
            if (b) {
                this.str = value;
                this.value = e;
            }
        }
        catch (EncapsulatedException e) {
            UnruledApi.LOGGER.warn("Failed to parse entity selector from '{}'", (Object)value);
            UnruledApi.LOGGER.warn((Object)e);
        }
    }

    public String method_20779() {
        return this.str;
    }

    public int method_20781() {
        return this.str.length();
    }

    protected EntitySelectorRule getThis() {
        return this;
    }

    public EntitySelectorRule copy() {
        return new EntitySelectorRule((class_1928.class_4314<EntitySelectorRule>)this.field_19417, this.str, this.validator, this.adapter);
    }

    public void setValue(EntitySelectorRule rule, @Nullable MinecraftServer server) {
        class_2300 e = rule.get();
        if (this.validator.validate(e)) {
            this.value = e;
            this.str = rule.method_20779();
            return;
        }
        Optional<class_2300> o = this.adapter.adapt(e);
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return;
        }
        this.str = rule.method_20779();
        this.value = o.get();
    }

    @Override
    public IGameruleValidator<class_2300> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<class_2300> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<class_2300> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<class_2300> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<EntitySelectorRule, class_2300> {
        private final String initialStr;

        public Builder(String initialValue) {
            super(class_2186::method_9306, Builder::acceptor, EntitySelectorRule.parseStr(initialValue));
            this.initialStr = initialValue;
        }

        @Override
        @NotNull
        protected EntitySelectorRule ruleBuilder(class_1928.class_4314<EntitySelectorRule> type) {
            return new EntitySelectorRule(type, this.initialStr, this.validator, this.adapter);
        }

        static void acceptor(class_1928.class_4311 consumer, class_1928.class_4313<EntitySelectorRule> key, class_1928.class_4314<EntitySelectorRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitEntitySelector(key, type);
        }
    }
}

