/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingMaterial;
import folk.sisby.tinkerers_smithing.data.SmithingUnitCostManager;
import folk.sisby.tinkerers_smithing.recipe.SacrificeUpgradeRecipe;
import folk.sisby.tinkerers_smithing.recipe.ShapelessRepairRecipe;
import folk.sisby.tinkerers_smithing.recipe.ShapelessUpgradeRecipe;
import folk.sisby.tinkerers_smithing.recipe.SmithingUpgradeRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class TinkerersSmithingLoader {
    public static final TinkerersSmithingLoader INSTANCE = new TinkerersSmithingLoader();
    public final Map<class_2960, Collection<class_1792>> SMITHING_TYPES = new HashMap<class_2960, Collection<class_1792>>();
    public final Map<class_2960, TinkerersSmithingMaterial> TOOL_MATERIALS = new HashMap<class_2960, TinkerersSmithingMaterial>();
    public final Map<class_2960, TinkerersSmithingMaterial> ARMOR_MATERIALS = new HashMap<class_2960, TinkerersSmithingMaterial>();
    public final Map<class_1792, SmithingUnitCostManager.UnitCostOverride> COST_OVERRIDES = new HashMap<class_1792, SmithingUnitCostManager.UnitCostOverride>();
    public final List<class_8786<?>> RECIPES = new ArrayList();

    public static class_2960 recipeId(String recipeType, String ... names) {
        return class_2960.method_60655((String)"tinkerers_smithing", (String)(recipeType + "/" + String.join((CharSequence)"/", names)));
    }

    public static class_2960 recipeId(String recipeType, class_2960 ... ids) {
        return TinkerersSmithingLoader.recipeId(recipeType, (String[])Arrays.stream(ids).map(id -> id.method_12836().equals("minecraft") ? id.method_12832() : id.method_12836() + "/" + id.method_12832()).toArray(String[]::new));
    }

    public static class_2960 recipeId(String recipeType, class_1792 ... items) {
        return TinkerersSmithingLoader.recipeId(recipeType, (class_2960[])Arrays.stream(items).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).toArray(class_2960[]::new));
    }

    public static class_2960 appendId(class_2960 id, String name) {
        return class_2960.method_60654((String)(id.toString() + "/" + name));
    }

    public static class_2960 repairRecipeId(class_1792 baseItem, class_1856 ingredient) {
        class_2960 class_29602;
        if (ingredient.field_9019.length == 0) {
            throw new IllegalArgumentException("Ingredients for Tinkerer's Smithing recipes can't be empty! When repairing item %s".formatted(class_7923.field_41178.method_10221((Object)baseItem)));
        }
        class_1856.class_1859 class_18592 = ingredient.field_9019[0];
        if (class_18592 instanceof class_1856.class_1857) {
            class_1856.class_1857 se = (class_1856.class_1857)class_18592;
            class_29602 = class_7923.field_41178.method_10221((Object)se.comp_1930.method_7909());
        } else {
            class_18592 = ingredient.field_9019[0];
            if (class_18592 instanceof class_1856.class_1858) {
                class_1856.class_1858 te = (class_1856.class_1858)class_18592;
                class_29602 = te.comp_1931.comp_327();
            } else {
                class_29602 = class_2960.method_60654((String)"ERROR");
            }
        }
        class_2960 ingredientId = class_29602;
        return TinkerersSmithingLoader.recipeId("repair", class_7923.field_41178.method_10221((Object)baseItem), ingredientId);
    }

    public void generateItemSmithingData(Map<class_2960, class_1860<?>> recipes) {
        new LoaderRun().generateItemSmithingData(recipes);
        this.SMITHING_TYPES.clear();
        this.TOOL_MATERIALS.clear();
        this.ARMOR_MATERIALS.clear();
        this.COST_OVERRIDES.clear();
    }

    public class LoaderRun {
        public final List<class_2960> WARN_NO_RECIPE = new ArrayList<class_2960>();
        public final List<class_2960> WARN_NO_MATERIALS = new ArrayList<class_2960>();
        public final Map<class_2960, class_6880<class_1741>> WARN_DEFAULT_MATERIAL_ARMOR = new HashMap<class_2960, class_6880<class_1741>>();
        public final Map<class_2960, class_1832> WARN_DEFAULT_MATERIAL_TOOL = new HashMap<class_2960, class_1832>();
        public int INFO_ADDED_COSTS = 0;
        public int INFO_ADDED_COST_ITEMS = 0;
        public int INFO_ADDED_UPGRADES = 0;
        public int INFO_ADDED_UPGRADE_ITEMS = 0;
        public int INFO_ADDED_SACRIFICES = 0;
        public int INFO_ADDED_SACRIFICE_ITEMS = 0;

        public List<TinkerersSmithingMaterial> getAllMaterials() {
            ArrayList<TinkerersSmithingMaterial> outList = new ArrayList<TinkerersSmithingMaterial>();
            outList.addAll(TinkerersSmithingLoader.this.TOOL_MATERIALS.values());
            outList.addAll(TinkerersSmithingLoader.this.ARMOR_MATERIALS.values());
            return outList;
        }

        public List<class_1856> getMaterialRepairIngredients(BiConsumer<class_2960, class_6880<class_1741>> armorDefaults, BiConsumer<class_2960, class_1832> toolDefaults, class_1792 item) {
            class_1831 ti;
            class_1738 ai;
            ArrayList<class_1856> outList = new ArrayList<class_1856>();
            boolean noneMatch = true;
            for (TinkerersSmithingMaterial material : this.getAllMaterials()) {
                if (!material.items.contains(item)) continue;
                noneMatch = false;
                material.repairMaterials.stream().filter(i -> !i.method_8103()).forEach(outList::add);
            }
            if (noneMatch && item instanceof class_1738 && (ai = (class_1738)item).method_7686() != null) {
                armorDefaults.accept(class_7923.field_41178.method_10221((Object)item), (class_6880<class_1741>)ai.method_7686());
            }
            if (noneMatch && item instanceof class_1831 && (ti = (class_1831)item).method_8022() != null) {
                toolDefaults.accept(class_7923.field_41178.method_10221((Object)item), ti.method_8022());
            }
            if (outList.isEmpty()) {
                class_1856 repairIngredient;
                TinkerersSmithingMaterial material;
                if (item.method_7854().method_7963() && item instanceof class_1738 && (material = (class_1741)(ai = (class_1738)item).method_7686().comp_349()) != null && (repairIngredient = (class_1856)material.comp_2301().get()) != null && !repairIngredient.method_8103()) {
                    outList.add(repairIngredient);
                }
                if (item.method_7854().method_7963() && item instanceof class_1831 && (material = (ti = (class_1831)item).method_8022()) != null && (repairIngredient = material.method_8023()) != null && !repairIngredient.method_8103()) {
                    outList.add(repairIngredient);
                }
            }
            return outList;
        }

        public Collection<class_1792> getUpgradePaths(class_1792 item) {
            HashSet<class_1792> outSet = new HashSet<class_1792>();
            ArrayList types = new ArrayList();
            TinkerersSmithingLoader.this.SMITHING_TYPES.forEach((id, items) -> {
                if (items.contains(item)) {
                    types.add(items);
                }
            });
            if (!types.isEmpty()) {
                for (TinkerersSmithingMaterial material : this.getAllMaterials()) {
                    if (!material.items.contains(item)) continue;
                    Map<class_2960, TinkerersSmithingMaterial> map = material.type == TinkerersSmithingMaterial.EQUIPMENT_TYPE.ARMOR ? TinkerersSmithingLoader.this.ARMOR_MATERIALS : TinkerersSmithingLoader.this.TOOL_MATERIALS;
                    for (class_2960 id2 : material.upgradesTo) {
                        TinkerersSmithingMaterial upgradeMaterial = map.get(id2);
                        if (upgradeMaterial.sacrificesVia != null) continue;
                        for (class_1792 upgradeItem : upgradeMaterial.items) {
                            if (!types.stream().anyMatch(type -> type.contains(upgradeItem))) continue;
                            outSet.add(upgradeItem);
                        }
                    }
                }
            }
            if (!outSet.isEmpty()) {
                ++this.INFO_ADDED_UPGRADE_ITEMS;
                this.INFO_ADDED_UPGRADES += outSet.size();
            }
            return outSet;
        }

        public Map<class_1856, Integer> getUnitCosts(class_1792 item, Map<class_2960, class_1860<?>> recipes) {
            HashMap<class_1856, Integer> outMap = new HashMap<class_1856, Integer>();
            class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
            SmithingUnitCostManager.UnitCostOverride override = TinkerersSmithingLoader.this.COST_OVERRIDES.get(item);
            List<class_1856> repairIngredients = this.getMaterialRepairIngredients(this.WARN_DEFAULT_MATERIAL_ARMOR::put, this.WARN_DEFAULT_MATERIAL_TOOL::put, item);
            if ((override == null || !override.replace()) && repairIngredients.isEmpty() && item.method_7854().method_7963()) {
                this.WARN_NO_MATERIALS.add(itemId);
            }
            if (!(override != null && override.replace() || repairIngredients.isEmpty())) {
                ArrayList recipeIds = new ArrayList();
                recipes.keySet().stream().filter(id -> id.method_12836().equals(itemId.method_12836()) && itemId.method_12832().equals(id.method_12832().substring(id.method_12832().lastIndexOf(47) + 1))).forEach(recipeIds::add);
                for (class_2960 recipeId : recipeIds) {
                    class_1860<?> recipe = recipes.get(recipeId);
                    if (recipe == null || !recipe.method_8110((class_7225.class_7874)class_5455.method_40302((class_2378)class_7923.field_41167)).method_31574(item)) continue;
                    for (class_1856 repairIngredient : repairIngredients) {
                        int unitCost = Math.toIntExact(recipe.method_8117().stream().filter(craftingIngredient -> TinkerersSmithing.CONFIG.matchesOrEquivalent(repairIngredient, (class_1856)craftingIngredient)).count());
                        if (unitCost <= 0) continue;
                        outMap.put(repairIngredient, unitCost);
                    }
                }
                if (recipeIds.isEmpty()) {
                    this.WARN_NO_RECIPE.add(itemId);
                }
            }
            if (override != null) {
                outMap.putAll(override.costs());
                if (override.replace()) {
                    this.WARN_DEFAULT_MATERIAL_TOOL.remove(itemId);
                    this.WARN_DEFAULT_MATERIAL_ARMOR.remove(itemId);
                }
            }
            if (!outMap.isEmpty()) {
                ++this.INFO_ADDED_COST_ITEMS;
                this.INFO_ADDED_COSTS += outMap.size();
            }
            return outMap;
        }

        public Map<class_1792, class_3545<Integer, Multimap<Integer, class_1792>>> getSacrificePaths(class_1792 item, Map<class_1792, Map<class_1856, Integer>> unitCosts) {
            HashMap<class_1792, class_3545<Integer, Multimap<Integer, class_1792>>> outMap = new HashMap<class_1792, class_3545<Integer, Multimap<Integer, class_1792>>>();
            ArrayList types = new ArrayList();
            TinkerersSmithingLoader.this.SMITHING_TYPES.forEach((id, items) -> {
                if (items.contains(item)) {
                    types.add(items);
                }
            });
            if (!types.isEmpty()) {
                for (TinkerersSmithingMaterial material : this.getAllMaterials()) {
                    if (!material.items.contains(item)) continue;
                    Map<class_2960, TinkerersSmithingMaterial> map = material.type == TinkerersSmithingMaterial.EQUIPMENT_TYPE.ARMOR ? TinkerersSmithingLoader.this.ARMOR_MATERIALS : TinkerersSmithingLoader.this.TOOL_MATERIALS;
                    Map<class_2960, TinkerersSmithingMaterial> otherMap = material.type == TinkerersSmithingMaterial.EQUIPMENT_TYPE.ARMOR ? TinkerersSmithingLoader.this.TOOL_MATERIALS : TinkerersSmithingLoader.this.ARMOR_MATERIALS;
                    for (class_2960 upgradeId : material.upgradesTo) {
                        TinkerersSmithingMaterial upgradeMaterial = map.get(upgradeId);
                        if (upgradeMaterial.sacrificesVia == null) continue;
                        ArrayList<class_1792> sacrificesViaItems = new ArrayList<class_1792>(map.get((Object)upgradeMaterial.sacrificesVia).items);
                        ArrayList<class_1792> sacrificeItems = new ArrayList<class_1792>(map.get((Object)upgradeId).items);
                        if (otherMap.containsKey(upgradeId)) {
                            TinkerersSmithingMaterial otherUpgradeMaterial = otherMap.get(upgradeId);
                            if (otherUpgradeMaterial.sacrificesVia.equals((Object)upgradeMaterial.sacrificesVia)) {
                                sacrificesViaItems.addAll(otherMap.get((Object)otherUpgradeMaterial.sacrificesVia).items);
                                sacrificeItems.addAll(otherUpgradeMaterial.items);
                            }
                        }
                        for (class_1792 upgradeItem : upgradeMaterial.items) {
                            if (types.stream().noneMatch(type -> type.contains(upgradeItem))) continue;
                            HashMultimap sacrifices = HashMultimap.create();
                            int upgradeViaCost = 0;
                            for (class_1792 viaItem : map.get((Object)upgradeMaterial.sacrificesVia).items) {
                                if (!types.stream().anyMatch(type -> type.contains(viaItem))) continue;
                                upgradeViaCost = unitCosts.get(viaItem).values().stream().findFirst().orElse(0);
                            }
                            if (upgradeViaCost <= 0) continue;
                            for (class_1792 sacrificeItem : sacrificeItems) {
                                ArrayList<Collection<class_1792>> sacrificeTypes = new ArrayList<Collection<class_1792>>();
                                for (Collection<class_1792> items2 : TinkerersSmithingLoader.this.SMITHING_TYPES.values()) {
                                    if (!items2.contains(sacrificeItem)) continue;
                                    sacrificeTypes.add(items2);
                                }
                                int sacrificesViaCost = 0;
                                for (class_1792 viaItem : sacrificesViaItems) {
                                    if (!sacrificeTypes.stream().anyMatch(type -> type.contains(viaItem))) continue;
                                    sacrificesViaCost = unitCosts.get(viaItem).values().stream().findFirst().orElse(0);
                                }
                                if (sacrificesViaCost <= 0) continue;
                                sacrifices.put((Object)sacrificesViaCost, (Object)sacrificeItem);
                            }
                            if (sacrifices.isEmpty()) continue;
                            outMap.put(upgradeItem, (class_3545<Integer, Multimap<Integer, class_1792>>)new class_3545((Object)upgradeViaCost, (Object)sacrifices));
                        }
                    }
                }
            }
            if (!outMap.isEmpty()) {
                ++this.INFO_ADDED_SACRIFICE_ITEMS;
                this.INFO_ADDED_SACRIFICES += outMap.size();
            }
            return outMap;
        }

        public void generateItemSmithingData(Map<class_2960, class_1860<?>> recipes) {
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Data Initializing.");
            TinkerersSmithingLoader.this.RECIPES.clear();
            HashMap<class_1792, Map<class_1856, Integer>> unitCosts = new HashMap<class_1792, Map<class_1856, Integer>>();
            for (class_1792 item : class_7923.field_41178) {
                Map<class_1856, Integer> unitCost = this.getUnitCosts(item, recipes);
                if (item.method_7854().method_7936() > 0) {
                    unitCost.forEach((unit, count) -> TinkerersSmithingLoader.this.RECIPES.add(new ShapelessRepairRecipe(item, (class_1856)unit, (int)count).toEntry()));
                }
                unitCosts.put(item, unitCost);
            }
            for (class_1792 base : class_7923.field_41178) {
                for (class_1792 result2 : this.getUpgradePaths(base)) {
                    ((Map)unitCosts.get(result2)).forEach((addition, additionCount) -> {
                        TinkerersSmithingLoader.this.RECIPES.add(new SmithingUpgradeRecipe(base, (class_1856)addition, (int)additionCount, result2).toEntry());
                        TinkerersSmithingLoader.this.RECIPES.add(new ShapelessUpgradeRecipe(base, (class_1856)addition, (int)additionCount, result2).toEntry());
                    });
                }
                this.getSacrificePaths(base, unitCosts).forEach((result, sacrifice) -> ((Multimap)sacrifice.method_15441()).keySet().forEach(additionUnits -> {
                    Collection additions = ((Multimap)sacrifice.method_15441()).get(additionUnits);
                    if (result.method_7854().method_7936() > 0) {
                        TinkerersSmithingLoader.this.RECIPES.add(new SacrificeUpgradeRecipe(base, class_1856.method_8091((class_1935[])((class_1935[])additions.toArray(class_1792[]::new))), (int)additionUnits, (class_1792)result, (Integer)sacrifice.method_15442()).toEntry());
                    }
                }));
            }
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Registered {} Tool Materials with {} items: [{}]", new Object[]{TinkerersSmithingLoader.this.TOOL_MATERIALS.size(), TinkerersSmithingLoader.this.TOOL_MATERIALS.values().stream().map(m -> m.items.size()).reduce(Integer::sum).orElse(0), TinkerersSmithingLoader.this.TOOL_MATERIALS.entrySet().stream().map(e -> ((class_2960)e.getKey()).toString() + "(" + ((TinkerersSmithingMaterial)e.getValue()).items.size() + ")").collect(Collectors.joining(", "))});
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Registered {} Armor Materials with {} items: [{}].", new Object[]{TinkerersSmithingLoader.this.ARMOR_MATERIALS.size(), TinkerersSmithingLoader.this.ARMOR_MATERIALS.values().stream().map(m -> m.items.size()).reduce(Integer::sum).orElse(0), TinkerersSmithingLoader.this.ARMOR_MATERIALS.entrySet().stream().map(e -> ((class_2960)e.getKey()).toString() + "(" + ((TinkerersSmithingMaterial)e.getValue()).items.size() + ")").collect(Collectors.joining(", "))});
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Registered {} Equipment Types with {} items: [{}]", new Object[]{TinkerersSmithingLoader.this.SMITHING_TYPES.size(), TinkerersSmithingLoader.this.SMITHING_TYPES.values().stream().map(Collection::size).reduce(Integer::sum).orElse(0), TinkerersSmithingLoader.this.SMITHING_TYPES.entrySet().stream().map(e -> ((class_2960)e.getKey()).toString() + "(" + ((Collection)e.getValue()).size() + ")").collect(Collectors.joining(", "))});
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Applied {} Unit Costs to {} items", (Object)this.INFO_ADDED_COSTS, (Object)this.INFO_ADDED_COST_ITEMS);
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Applied {} Upgrade Paths to {} items", (Object)this.INFO_ADDED_UPGRADES, (Object)this.INFO_ADDED_UPGRADE_ITEMS);
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Applied {} Sacrifice Paths to {} items", (Object)this.INFO_ADDED_SACRIFICES, (Object)this.INFO_ADDED_SACRIFICE_ITEMS);
            if (!this.WARN_DEFAULT_MATERIAL_ARMOR.isEmpty()) {
                HashSet<class_6880<class_1741>> armorMats = new HashSet<class_6880<class_1741>>(this.WARN_DEFAULT_MATERIAL_ARMOR.values());
                TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Found {} unregistered armor materials with {} armor items: [{}] - items: [{}]", new Object[]{armorMats.size(), this.WARN_DEFAULT_MATERIAL_ARMOR.size(), armorMats.stream().map(class_6880::method_55840).collect(Collectors.joining(", ")), this.WARN_DEFAULT_MATERIAL_ARMOR.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList()))).entrySet().stream().map(e -> "%s[%s]".formatted(((class_6880)e.getKey()).method_55840(), ((List)e.getValue()).stream().map(class_2960::toString).collect(Collectors.joining(", ")))).collect(Collectors.joining(", "))});
            }
            if (!this.WARN_DEFAULT_MATERIAL_TOOL.isEmpty()) {
                HashSet<class_1832> toolMats = new HashSet<class_1832>(this.WARN_DEFAULT_MATERIAL_TOOL.values());
                TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Found {} unregistered tool materials with {} tool items: [{}] - items: [{}]", new Object[]{toolMats.size(), this.WARN_DEFAULT_MATERIAL_TOOL.size(), toolMats.stream().map(Object::toString).collect(Collectors.joining(", ")), this.WARN_DEFAULT_MATERIAL_TOOL.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList()))).entrySet().stream().map(e -> "%s[%s]".formatted(((class_1832)e.getKey()).toString(), ((List)e.getValue()).stream().map(class_2960::toString).collect(Collectors.joining(", ")))).collect(Collectors.joining(", "))});
            }
            if (!this.WARN_NO_RECIPE.isEmpty()) {
                TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Found {} equipment items without unit cost recipes: [{}]", (Object)this.WARN_NO_RECIPE.size(), (Object)this.WARN_NO_RECIPE.stream().map(class_2960::toString).collect(Collectors.joining(", ")));
            }
            if (!this.WARN_NO_MATERIALS.isEmpty()) {
                TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Found {} damageable items without repair materials: [{}]", (Object)this.WARN_NO_MATERIALS.size(), (Object)this.WARN_NO_MATERIALS.stream().map(class_2960::toString).collect(Collectors.joining(", ")));
            }
            TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Data Initialized!");
        }
    }
}

