/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public abstract class MultiJsonDataLoader
extends class_4080<Map<class_2960, Collection<class_3545<JsonElement, String>>>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FILE_SUFFIX = ".json";
    private final Gson gson;
    private final String dataType;

    public MultiJsonDataLoader(Gson gson, String dataType) {
        this.gson = gson;
        this.dataType = dataType;
    }

    protected Map<class_2960, Collection<class_3545<JsonElement, String>>> prepare(class_3300 manager, class_3695 profiler) {
        HashMap outMap = Maps.newHashMap();
        for (Map.Entry entry : manager.method_41265(this.dataType, id -> id.method_12832().endsWith(FILE_SUFFIX)).entrySet()) {
            class_2960 fileId = (class_2960)entry.getKey();
            class_2960 id2 = class_2960.method_60655((String)fileId.method_12836(), (String)fileId.method_12832().substring(this.dataType.length() + 1, fileId.method_12832().length() - FILE_SUFFIX.length()));
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement jsonContents = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                        outMap.computeIfAbsent(id2, k -> new ArrayList()).add(new class_3545((Object)jsonContents, (Object)resource.method_45304().method_14409()));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException e) {
                    LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id2, fileId, e});
                }
            }
        }
        return outMap;
    }
}

